/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.texture.TextureManager;

public class WebTextureCustomizationItem
extends CustomizationItemBase {
    public WebTextureResourceLocation texture;
    public String rawURL = "";

    public WebTextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtexture")) {
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = PlaceholderTextValueHelper.convertFromRaw(this.value);
                try {
                    this.texture = TextureHandler.getWebResource((String)this.value);
                    if (this.texture == null || !this.texture.isReady()) {
                        this.width = 100;
                        this.height = 100;
                        return;
                    }
                    int w = this.texture.getWidth();
                    int h = this.texture.getHeight();
                    double ratio = (double)w / (double)h;
                    if (this.width < 0 && this.height >= 0) {
                        this.width = (int)((double)this.height * ratio);
                    }
                    if (this.height < 0 && this.width >= 0) {
                        this.height = (int)((double)this.width / ratio);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void render(MatrixStack matrix) {
        if (this.shouldRender()) {
            int x = this.getPosX();
            int y = this.getPosY();
            if (this.texture != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture.getResourceLocation());
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureManager.field_194008_a);
            }
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            IngameGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            RenderSystem.disableBlend();
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.width < 0 || this.height < 0) {
            return false;
        }
        return super.shouldRender();
    }
}

