/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen;

import de.keksuccino.drippyloadingscreen.api.PlaceholderTextValueRegistry;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemRegistry;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelper;
import de.keksuccino.drippyloadingscreen.customization.items.visibilityrequirements.VisibilityRequirementHandler;
import de.keksuccino.drippyloadingscreen.customization.rendering.SimpleTextRenderer;
import de.keksuccino.drippyloadingscreen.customization.rendering.slideshow.SlideshowHandler;
import de.keksuccino.drippyloadingscreen.keybinding.Keybinding;
import de.keksuccino.drippyloadingscreen.logger.Logging;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.localization.Locals;
import java.io.File;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="drippyloadingscreen")
public class DrippyLoadingScreen {
    public static final String VERSION = "1.2.0";
    public static final File HOME_DIR = new File("config/drippyloadingscreen");
    public static final File CUSTOMIZATION_DIR = new File(HOME_DIR.getPath() + "/customization");
    public static final File SLIDESHOW_DIR = new File(HOME_DIR.getPath() + "/slideshows");
    public static Config config;
    private static boolean fancymenuLoaded;
    private static boolean optifineLoaded;

    public DrippyLoadingScreen() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            if (!HOME_DIR.exists()) {
                HOME_DIR.mkdirs();
            }
            if (!CUSTOMIZATION_DIR.exists()) {
                CUSTOMIZATION_DIR.mkdirs();
            }
            if (!SLIDESHOW_DIR.exists()) {
                SLIDESHOW_DIR.mkdirs();
            }
            if (ModList.get().isLoaded("fancymenu")) {
                System.out.println("[DRIPPY LOADING SCREEN] FancyMenu found!");
                fancymenuLoaded = true;
            }
            DrippyLoadingScreen.updateConfig();
            Logging.init();
            SlideshowHandler.init();
            CustomizationHandler.init();
            CustomizationHelper.init();
            VisibilityRequirementHandler.init();
            SimpleTextRenderer.init();
            if (((Boolean)config.getOrDefault("enablekeybinds", (Object)true)).booleanValue()) {
                Keybinding.init();
            }
            Konkrete.addPostLoadingEvent((String)"drippyloadingscreen", this::onClientSetup);
        } else {
            System.out.println("## WARNING ## 'Drippy Loading Screen' is a client mod and has no effect when loaded on a server!");
        }
    }

    private void onClientSetup() {
        try {
            DrippyLoadingScreen.initLocals();
            try {
                Class.forName("optifine.Installer");
                optifineLoaded = true;
                System.out.println("[DRIPPY LOADING SCREEN] Optifine found!");
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isFancyMenuLoaded() {
        return fancymenuLoaded;
    }

    public static boolean isOptifineLoaded() {
        return optifineLoaded;
    }

    public static void updateConfig() {
        try {
            config = new Config(HOME_DIR.getPath() + "/config.cfg");
            config.registerValue("printwarnings", Boolean.valueOf(true), "logging");
            config.registerValue("editordeleteconfirmation", Boolean.valueOf(true), "layouteditor");
            config.registerValue("showgrid", Boolean.valueOf(false), "layouteditor");
            config.registerValue("gridsize", Integer.valueOf(10), "layouteditor");
            config.registerValue("showcustomizationcontrols", Boolean.valueOf(true), "customization");
            config.registerValue("enablekeybinds", Boolean.valueOf(true), "customization");
            config.registerValue("uiscale", Float.valueOf(1.0f), "ui");
            config.syncConfig();
            config.clearUnusedValues();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initLocals() {
        String baseresdir = "locals/";
        File f = new File("config/drippyloadingscreen/locals");
        if (!f.exists()) {
            f.mkdirs();
        }
        Locals.copyLocalsFileToDir((ResourceLocation)new ResourceLocation("drippyloadingscreen", baseresdir + "en_us.local"), (String)"en_us", (String)f.getPath());
        Locals.getLocalsFromDir((String)f.getPath());
    }

    public static PlaceholderTextValueRegistry getDynamicValueRegistry() {
        return PlaceholderTextValueRegistry.getInstance();
    }

    public static CustomizationItemRegistry getCustomizationItemRegistry() {
        return CustomizationItemRegistry.getInstance();
    }

    static {
        fancymenuLoaded = false;
        optifineLoaded = false;
    }
}

