/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHPopup;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.visibilityrequirements.VisibilityRequirementContainer;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class VisibilityRequirementsPopup
extends FHPopup {
    protected CustomizationItemBase parent;
    protected List<Requirement> requirements = new ArrayList<Requirement>();
    protected int currentRequirement = 0;
    protected AdvancedButton doneButton;
    protected AdvancedButton leftButton;
    protected AdvancedButton rightButton;

    public VisibilityRequirementsPopup(CustomizationItemBase parent) {
        super(240);
        this.parent = parent;
        this.doneButton = new AdvancedButton(0, 0, 100, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.setDisplayed(false));
        this.addButton(this.doneButton);
        this.leftButton = new AdvancedImageButton(0, 0, 20, 20, new ResourceLocation("keksuccino", "arrow_left.png"), true, press -> {
            int i = this.currentRequirement - 1;
            if (i >= 0) {
                this.currentRequirement = i;
            }
        });
        this.addButton(this.leftButton);
        this.rightButton = new AdvancedImageButton(0, 0, 20, 20, new ResourceLocation("keksuccino", "arrow_right.png"), true, press -> {
            int i = this.currentRequirement + 1;
            if (i <= this.requirements.size() - 1) {
                this.currentRequirement = i;
            }
        });
        this.addButton(this.rightButton);
        this.initRequirements();
    }

    protected void initRequirements() {
        VisibilityRequirementContainer c = this.parent.visibilityRequirementContainer;
    }

    public void render(PoseStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        int centerX = renderIn.f_96543_ / 2;
        int centerY = renderIn.f_96544_ / 2;
        this.doneButton.f_93620_ = centerX - this.doneButton.m_5711_() / 2;
        this.doneButton.f_93621_ = centerY + 50;
        this.leftButton.f_93620_ = centerX - this.leftButton.m_5711_() - 135;
        this.leftButton.f_93621_ = centerY - this.leftButton.m_93694_() / 2;
        this.rightButton.f_93620_ = centerX + 135;
        this.rightButton.f_93621_ = centerY - this.leftButton.m_93694_() / 2;
        Requirement r = this.requirements.get(this.currentRequirement);
        if (r != null) {
            r.render(matrix, mouseX, mouseY, renderIn);
        }
        this.renderButtons(matrix, mouseX, mouseY);
    }

    public static class Requirement
    extends GuiComponent {
        protected VisibilityRequirementsPopup parent;
        protected String name;
        protected String desc;
        protected String valueName;
        protected Consumer<Boolean> enabledCallback;
        protected Consumer<Boolean> showIfCallback;
        protected Consumer<String> valueCallback;
        protected CharacterFilter valueFilter;
        protected boolean enabled;
        protected boolean showIf;
        protected String valueString;
        protected List<Runnable> preRenderTasks = new ArrayList<Runnable>();
        protected List<AdvancedButton> buttonList = new ArrayList<AdvancedButton>();
        protected AdvancedButton enableRequirementButton;
        protected AdvancedButton showIfButton;
        protected AdvancedButton showIfNotButton;
        protected AdvancedTextField valueTextField;

        public Requirement(VisibilityRequirementsPopup parent, String name, String desc, @Nullable String valueName, boolean enabled, boolean showIf, Consumer<Boolean> enabledCallback, Consumer<Boolean> showIfCallback, @Nullable Consumer<String> valueCallback, CharacterFilter valueFilter, String valueString) {
            this.parent = parent;
            this.name = name;
            this.desc = desc;
            this.valueName = valueName;
            this.enabledCallback = enabledCallback;
            this.showIfCallback = showIfCallback;
            this.valueCallback = valueCallback;
            this.valueFilter = valueFilter;
            this.enabled = enabled;
            this.showIf = showIf;
            this.valueString = valueString;
            this.init();
        }

        protected void init() {
            String enabledString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.enabled", (String[])new String[]{this.name});
            if (!this.enabled) {
                enabledString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.disabled", (String[])new String[]{this.name});
            }
            this.enableRequirementButton = new AdvancedButton(0, 0, 150, 20, enabledString, true, press -> {
                if (this.enabled) {
                    this.enabled = false;
                    this.enabledCallback.accept(false);
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.disabled", (String[])new String[]{this.name}));
                } else {
                    this.enabled = true;
                    this.enabledCallback.accept(true);
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.enabled", (String[])new String[]{this.name}));
                }
            });
            ArrayList<String> descLines = new ArrayList<String>();
            descLines.addAll(Arrays.asList(StringUtils.splitLines((String)this.desc, (String)"%n%")));
            descLines.add("");
            descLines.add(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.toggle.btn.desc", (String[])new String[0]));
            this.enableRequirementButton.setDescription(descLines.toArray(new String[0]));
            this.preRenderTasks.add(() -> this.enableRequirementButton.m_93674_(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.enableRequirementButton.m_6035_()) + 10));
            this.addButton(this.enableRequirementButton);
            Object showIfString = "\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]);
            if (!this.showIf) {
                showIfString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]);
            }
            this.showIfButton = new AdvancedButton(0, 0, 100, 20, (String)showIfString, true, press -> {
                this.showIf = true;
                this.showIfCallback.accept(true);
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]));
                this.showIfNotButton.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]));
            });
            this.showIfButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfButton);
            Object showIfNotString = "\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]);
            if (this.showIf) {
                showIfNotString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]);
            }
            this.showIfNotButton = new AdvancedButton(0, 0, 100, 20, (String)showIfNotString, true, press -> {
                this.showIf = false;
                this.showIfCallback.accept(false);
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]));
                this.showIfButton.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]));
            });
            this.showIfNotButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfNotButton);
            if (this.valueCallback != null && this.valueName != null) {
                this.valueTextField = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 150, 20, true, this.valueFilter);
                this.valueTextField.m_94190_(true);
                this.valueTextField.m_94178_(false);
                this.valueTextField.m_94199_(1000);
                if (this.valueString != null) {
                    this.valueTextField.m_94144_(this.valueString);
                }
            }
        }

        public void render(PoseStack matrix, int mouseX, int mouseY, Screen renderIn) {
            for (Runnable r : this.preRenderTasks) {
                r.run();
            }
            float partial = Minecraft.m_91087_().m_91296_();
            int centerX = renderIn.f_96543_ / 2;
            int centerY = renderIn.f_96544_ / 2;
            Requirement.m_93208_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.requirement", (String[])new String[0]) + ":"), (int)centerX, (int)(centerY - 83), (int)-1);
            this.enableRequirementButton.f_93620_ = centerX - this.enableRequirementButton.m_5711_() / 2;
            this.enableRequirementButton.f_93621_ = centerY - 70;
            this.showIfButton.f_93620_ = centerX - this.showIfButton.m_5711_() - 5;
            this.showIfButton.f_93621_ = centerY - 40;
            this.showIfNotButton.f_93623_ = this.enabled;
            this.showIfNotButton.f_93620_ = centerX + 5;
            this.showIfNotButton.f_93621_ = centerY - 40;
            this.showIfButton.f_93623_ = this.enabled;
            if (this.valueTextField != null) {
                Requirement.m_93208_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)(this.valueName + ":"), (int)centerX, (int)(centerY - 10), (int)-1);
                this.valueTextField.f_93620_ = centerX - this.valueTextField.m_5711_() / 2;
                this.valueTextField.f_93621_ = centerY + 3;
                this.valueTextField.m_6305_(matrix, mouseX, mouseY, partial);
                this.valueTextField.f_93623_ = this.enabled;
                this.valueTextField.m_94186_(this.enabled);
                this.valueCallback.accept(this.valueTextField.m_94155_());
                this.valueString = this.valueTextField.m_94155_();
            }
            this.renderButtons(matrix, mouseX, mouseY, partial);
        }

        protected void renderButtons(PoseStack matrix, int mouseX, int mouseY, float partial) {
            for (AdvancedButton b : this.buttonList) {
                b.m_6305_(matrix, mouseX, mouseY, partial);
            }
        }

        protected void addButton(AdvancedButton b) {
            if (!this.buttonList.contains(b)) {
                this.buttonList.add(b);
                b.ignoreBlockedInput = true;
                this.parent.colorizePopupButton(b);
            }
        }
    }
}

