/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.ui.content;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.screens.FHConfigScreen;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.content.ContextMenu;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class MenuBar
extends UIBase {
    public static final ResourceLocation FH_LOGO_TEXTURE = new ResourceLocation("drippyloadingscreen", "dl_pixel_logo.png");
    public static final ResourceLocation SHRINK_BTN_TEXTURE = new ResourceLocation("drippyloadingscreen", "shrink_btn.png");
    public static final ResourceLocation EXPAND_BTN_TEXTURE = new ResourceLocation("drippyloadingscreen", "expand_btn.png");
    protected Map<String, AdvancedButton> leftElements = new LinkedHashMap<String, AdvancedButton>();
    protected Map<String, AdvancedButton> rightElements = new LinkedHashMap<String, AdvancedButton>();
    protected List<String> persistentElements = new ArrayList<String>();
    protected Map<String, ContextMenu> childs = new HashMap<String, ContextMenu>();
    protected int height = 20;
    protected Color barColor = new Color(247, 237, 255, 255);
    protected boolean expanded = true;
    protected boolean visible = true;
    public boolean opacityChange = true;
    public float barOpacity = 0.8f;
    public int elementSpace = -1;

    public MenuBar() {
        AdvancedImageButton fhBtn = new AdvancedImageButton(0, 0, 0, 0, FH_LOGO_TEXTURE, true, press -> Minecraft.m_91087_().m_91152_((Screen)new FHConfigScreen(Minecraft.m_91087_().f_91080_))){

            public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
                this.f_93618_ = this.f_93619_;
                super.m_6305_(matrix, mouseX, mouseY, partialTicks);
            }
        };
        fhBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.config", (String[])new String[0]), (String)"%n%"));
        this.addElement((AdvancedButton)fhBtn, "menubar.default.fancymenubtn", ElementAlignment.LEFT, true);
        AdvancedImageButton expandBtn = new AdvancedImageButton(0, 0, 20, 20, SHRINK_BTN_TEXTURE, true, press -> {
            this.toggleExpanded();
            if (this.expanded) {
                ((AdvancedImageButton)press).setImage(SHRINK_BTN_TEXTURE);
                ((AdvancedButton)press).setDescription(new String[]{Locals.localize((String)"drippyloadingscreen.helper.menubar.shrink", (String[])new String[0])});
            } else {
                ((AdvancedImageButton)press).setImage(EXPAND_BTN_TEXTURE);
                ((AdvancedButton)press).setDescription(new String[]{Locals.localize((String)"drippyloadingscreen.helper.menubar.expand", (String[])new String[0])});
            }
        }){

            public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
                this.f_93618_ = this.f_93619_;
                super.m_6305_(matrix, mouseX, mouseY, partialTicks);
            }
        };
        expandBtn.setDescription(new String[]{Locals.localize((String)"drippyloadingscreen.helper.menubar.shrink", (String[])new String[0])});
        this.addElement((AdvancedButton)expandBtn, "menubar.default.extendbtn", ElementAlignment.RIGHT, true);
    }

    public void addElement(AdvancedButton element, String key, ElementAlignment alignment, boolean persistent) {
        if (key != null && element != null) {
            this.removeElement(key);
            if (alignment == ElementAlignment.LEFT) {
                this.leftElements.put(key, element);
            } else if (alignment == ElementAlignment.RIGHT) {
                this.rightElements.put(key, element);
            } else {
                this.leftElements.put(key, element);
            }
            this.setElementPersistent(key, persistent);
        }
    }

    public void addElement(AdvancedButton element, String key) {
        this.addElement(element, key, null, false);
    }

    public AdvancedButton getElement(String key) {
        if (this.leftElements.containsKey(key)) {
            return this.leftElements.get(key);
        }
        if (this.rightElements.containsKey(key)) {
            return this.rightElements.get(key);
        }
        return null;
    }

    public void setElementPersistent(String key, boolean persistent) {
        if (persistent) {
            if (!this.persistentElements.contains(key)) {
                this.persistentElements.add(key);
            }
        } else {
            this.persistentElements.remove(key);
        }
    }

    public void removeElement(String key) {
        if (key != null && !this.persistentElements.contains(key)) {
            if (this.leftElements.containsKey(key)) {
                this.leftElements.remove(key);
            }
            if (this.rightElements.containsKey(key)) {
                this.rightElements.remove(key);
            }
        }
    }

    public void removeElement(AdvancedButton element) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, AdvancedButton> m : this.leftElements.entrySet()) {
            if (m.getValue() != element) continue;
            keys.add(m.getKey());
        }
        for (Map.Entry<String, AdvancedButton> m : this.rightElements.entrySet()) {
            if (m.getValue() != element) continue;
            keys.add(m.getKey());
        }
        for (String s : keys) {
            this.removeElement(s);
        }
    }

    public void removeAllElements() {
        for (String s : this.getElementKeys()) {
            if (this.persistentElements.contains(s)) continue;
            this.removeElement(s);
        }
    }

    public void addChild(ContextMenu child, String key, ElementAlignment alignment) {
        child.setAutoAlignment(false);
        if (alignment == ElementAlignment.LEFT) {
            child.setAlignment(false, false);
        } else if (alignment == ElementAlignment.RIGHT) {
            child.setAlignment(false, true);
        } else {
            child.setAlignment(false, false);
        }
        this.childs.put(key, child);
    }

    public ContextMenu getChild(String key) {
        return this.childs.get(key);
    }

    public List<String> getElementKeys() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.leftElements.keySet());
        l.addAll(this.rightElements.keySet());
        return l;
    }

    public List<AdvancedButton> getElements() {
        ArrayList<AdvancedButton> l = new ArrayList<AdvancedButton>();
        l.addAll(this.leftElements.values());
        l.addAll(this.rightElements.values());
        return l;
    }

    public void removeChild(String key) {
        if (this.childs.containsKey(key)) {
            this.childs.remove(key);
        }
    }

    public void removeChild(ContextMenu child) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, ContextMenu> m : this.childs.entrySet()) {
            if (m.getValue() != child) continue;
            keys.add(m.getKey());
        }
        for (String s : keys) {
            this.removeChild(s);
        }
    }

    public void removeAllChilds() {
        this.childs.clear();
    }

    public boolean isChildOpen() {
        for (ContextMenu m : this.childs.values()) {
            if (!m.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void render(PoseStack matrix, Screen screen) {
        if (screen != null && this.visible) {
            if (this.isChildOpen()) {
                MouseInput.blockVanillaInput((String)"fmcustomizationhelper");
            } else {
                MouseInput.unblockVanillaInput((String)"fmcustomizationhelper");
            }
            MouseInput.setRenderScale((float)this.getScale());
            int mouseX = MouseInput.getMouseX();
            int mouseY = MouseInput.getMouseY();
            int width = screen.f_96543_;
            float partialTicks = Minecraft.m_91087_().m_91296_();
            MouseInput.resetRenderScale();
            RenderUtils.setZLevelPre((PoseStack)matrix, (int)400);
            matrix.m_85841_(this.getScale(), this.getScale(), this.getScale());
            RenderSystem.m_69478_();
            if (this.expanded) {
                this.renderBackground(matrix, screen);
                for (ContextMenu contextMenu : this.childs.values()) {
                    contextMenu.setButtonHeight(this.height);
                    contextMenu.render(matrix, mouseX, mouseY);
                }
                int xl = 0;
                for (AdvancedButton b : this.leftElements.values()) {
                    if (!b.f_93624_) continue;
                    b.setHeight(this.height);
                    if (!(b instanceof AdvancedImageButton)) {
                        int i = Minecraft.m_91087_().f_91062_.m_92895_(b.getMessageString());
                        b.m_93674_(i + 12);
                    }
                    b.f_93620_ = xl;
                    b.f_93621_ = 0;
                    MenuBar.colorizeButton(b);
                    b.m_6305_(matrix, mouseX, mouseY, partialTicks);
                    xl += b.m_5711_() + this.elementSpace;
                }
                int n = (int)((float)width / this.getScale());
                for (AdvancedButton b : this.rightElements.values()) {
                    if (!b.f_93624_) continue;
                    b.setHeight(this.height);
                    if (!(b instanceof AdvancedImageButton)) {
                        int i = Minecraft.m_91087_().f_91062_.m_92895_(b.getMessageString());
                        b.m_93674_(i + 12);
                    }
                    b.f_93620_ = var8_13 -= b.m_5711_();
                    b.f_93621_ = 0;
                    MenuBar.colorizeButton(b);
                    b.m_6305_(matrix, mouseX, mouseY, partialTicks);
                    var8_13 -= this.elementSpace;
                }
            } else {
                AdvancedButton right = this.rightElements.get("menubar.default.extendbtn");
                if (right != null) {
                    right.setHeight(this.height);
                    right.f_93620_ = (int)((float)width / this.getScale() - (float)right.m_5711_());
                    right.f_93621_ = 0;
                    MenuBar.colorizeButton(right);
                    right.m_6305_(matrix, mouseX, mouseY, partialTicks);
                }
            }
            RenderUtils.setZLevelPost((PoseStack)matrix);
        }
    }

    protected void renderBackground(PoseStack matrix, Screen screen) {
        if (this.expanded && screen != null && this.barColor != null) {
            RenderUtils.fill((PoseStack)matrix, (float)0.0f, (float)0.0f, (float)((float)screen.f_96543_ / this.getScale()), (float)this.height, (int)this.barColor.getRGB(), (float)this.barOpacity);
        }
    }

    public boolean isHovered() {
        if (Minecraft.m_91087_().f_91080_ == null) {
            return false;
        }
        MouseInput.setRenderScale((float)this.getScale());
        int width = Minecraft.m_91087_().f_91080_.f_96543_;
        int mX = MouseInput.getMouseX();
        int mY = MouseInput.getMouseY();
        MouseInput.resetRenderScale();
        for (ContextMenu m : this.childs.values()) {
            if (!m.isOpen() || !m.isHovered()) continue;
            return true;
        }
        return mX <= width && mX >= 0 && mY <= this.height && mY >= 0;
    }

    public float getScale() {
        return MenuBar.getUIScale();
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setBarColor(Color color) {
        this.barColor = color;
    }

    public void setExtended(boolean extended) {
        this.expanded = extended;
    }

    public void toggleExpanded() {
        this.expanded = !this.expanded;
    }

    public boolean isExtended() {
        return this.expanded;
    }

    public static enum ElementAlignment {
        LEFT,
        RIGHT;

    }
}

