/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class WebTextureCustomizationItem
extends CustomizationItemBase {
    public WebTextureResourceLocation texture;
    public String rawURL = "";

    public WebTextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtexture")) {
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = PlaceholderTextValueHelper.convertFromRaw(this.value);
                try {
                    this.texture = TextureHandler.getWebResource((String)this.value);
                    if (this.texture == null || !this.texture.isReady()) {
                        this.width = 100;
                        this.height = 100;
                        return;
                    }
                    int w = this.texture.getWidth();
                    int h = this.texture.getHeight();
                    double ratio = (double)w / (double)h;
                    if (this.width < 0 && this.height >= 0) {
                        this.width = (int)((double)this.height * ratio);
                    }
                    if (this.height < 0 && this.width >= 0) {
                        this.height = (int)((double)this.width / ratio);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void render(PoseStack matrix) {
        if (this.shouldRender()) {
            int x = this.getPosX();
            int y = this.getPosY();
            if (this.texture != null) {
                RenderUtils.bindTexture((ResourceLocation)this.texture.getResourceLocation());
            } else {
                RenderUtils.bindTexture((ResourceLocation)TextureManager.f_118466_);
            }
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            WebTextureCustomizationItem.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            RenderSystem.m_69461_();
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.width < 0 || this.height < 0) {
            return false;
        }
        return super.shouldRender();
    }
}

