/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.custombars;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.awt.Color;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public abstract class CustomBarCustomizationItemBase
extends CustomizationItemBase {
    public BarDirection direction = BarDirection.RIGHT;
    public Color barColor = new Color(0, 0, 0);
    public Color backgroundColor = new Color(0, 0, 0, 50);
    public ResourceLocation barTexture = null;
    public ResourceLocation backgroundTexture = null;
    public ResourceLocation barEndTexture = null;
    public int barEndTextureWidth = 10;
    public int barEndTextureHeight = 10;
    public String barColorHex = null;
    public String backgroundColorHex = null;
    public String barTexturePath = null;
    public String backgroundTexturePath = null;
    public String barEndTexturePath = null;
    protected int currentPercentWidthHeight = 0;

    public CustomBarCustomizationItemBase(PropertiesSection item) {
        super(item);
        this.init(item);
    }

    public void init(PropertiesSection item) {
        String barDirec;
        String barEndHeightString;
        this.barColorHex = item.getEntryValue("barcolor");
        this.backgroundColorHex = item.getEntryValue("backgroundcolor");
        this.barTexturePath = item.getEntryValue("bartexture");
        this.backgroundTexturePath = item.getEntryValue("backgroundtexture");
        this.barEndTexturePath = item.getEntryValue("barendtexture");
        String barEndWidthString = item.getEntryValue("barendtexturewidth");
        if (barEndWidthString != null && MathUtils.isInteger((String)barEndWidthString)) {
            this.barEndTextureWidth = Integer.parseInt(barEndWidthString);
        }
        if ((barEndHeightString = item.getEntryValue("barendtextureheight")) != null && MathUtils.isInteger((String)barEndHeightString)) {
            this.barEndTextureHeight = Integer.parseInt(barEndHeightString);
        }
        if ((barDirec = item.getEntryValue("direction")) != null) {
            this.direction = BarDirection.byName(barDirec);
        }
        this.updateItem();
    }

    protected abstract void renderBar(PoseStack var1);

    protected abstract void renderBarBackground(PoseStack var1);

    public void updateItem() {
        ExternalTextureResourceLocation er;
        File f;
        Color c;
        if (this.barColorHex != null && (c = RenderUtils.getColorFromHexString((String)this.barColorHex)) != null) {
            this.barColor = c;
        }
        if (this.backgroundColorHex != null && (c = RenderUtils.getColorFromHexString((String)this.backgroundColorHex)) != null) {
            this.backgroundColor = c;
        }
        if (this.barTexturePath != null) {
            f = new File(this.barTexturePath);
            if (f.exists() && f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (er = TextureHandler.getResource((String)this.barTexturePath)) != null) {
                er.loadTexture();
                this.barTexture = er.getResourceLocation();
            }
        } else {
            this.barTexture = null;
        }
        if (this.backgroundTexturePath != null) {
            f = new File(this.backgroundTexturePath);
            if (f.exists() && f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (er = TextureHandler.getResource((String)this.backgroundTexturePath)) != null) {
                er.loadTexture();
                this.backgroundTexture = er.getResourceLocation();
            }
        } else {
            this.backgroundTexture = null;
        }
        if (this.barEndTexturePath != null) {
            f = new File(this.barEndTexturePath);
            if (f.exists() && f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (er = TextureHandler.getResource((String)this.barEndTexturePath)) != null) {
                er.loadTexture();
                this.barEndTexture = er.getResourceLocation();
            }
        } else {
            this.barEndTexture = null;
        }
    }

    protected boolean isEditor() {
        return Minecraft.m_91087_().f_91080_ instanceof LayoutEditorScreen;
    }

    public static enum BarDirection {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down");

        private String name;

        private BarDirection(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static BarDirection byName(String name) {
            for (BarDirection d : BarDirection.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return LEFT;
        }
    }
}

