/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.placeholdervalues;

import de.keksuccino.drippyloadingscreen.api.PlaceholderTextValueRegistry;
import de.keksuccino.konkrete.input.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.mcp.MCPVersion;

public class PlaceholderTextValueHelper {
    public static String convertFromRaw(String in) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null) {
                return in;
            }
            in = StringUtils.convertFormatCodes((String)in, (String)"&", (String)"\u00a7");
            in = in.replace("%guiwidth%", "" + Minecraft.m_91087_().m_91268_().m_85445_());
            in = in.replace("%guiheight%", "" + Minecraft.m_91087_().m_91268_().m_85446_());
            in = in.replace("%playername%", mc.m_91094_().m_92546_());
            in = in.replace("%playeruuid%", mc.m_91094_().m_92545_());
            in = in.replace("%mcversion%", MCPVersion.getMCVersion());
            in = PlaceholderTextValueHelper.replaceModVersionPlaceholder(in);
            in = in.replace("%loadedmods%", "" + PlaceholderTextValueHelper.getLoadedMods());
            if ((in = in.replace("%totalmods%", "" + PlaceholderTextValueHelper.getTotalMods())).contains("%realtime")) {
                Calendar c = Calendar.getInstance();
                in = in.replace("%realtimeyear%", "" + c.get(1));
                in = in.replace("%realtimemonth%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(2) + 1));
                in = in.replace("%realtimeday%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(5)));
                in = in.replace("%realtimehour%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(11)));
                in = in.replace("%realtimeminute%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(12)));
                in = in.replace("%realtimesecond%", PlaceholderTextValueHelper.formatToFancyDateTime(c.get(13)));
            }
            if (in.contains("%fps%")) {
                in = in.replace("%fps%", mc.f_90977_.split("[ ]", 2)[0]);
            }
            if (in.contains("ram%")) {
                long i = Runtime.getRuntime().maxMemory();
                long j = Runtime.getRuntime().totalMemory();
                long k = Runtime.getRuntime().freeMemory();
                long l = j - k;
                in = in.replace("%percentram%", l * 100L / i + "%");
                in = in.replace("%usedram%", "" + PlaceholderTextValueHelper.bytesToMb(l));
                in = in.replace("%maxram%", "" + PlaceholderTextValueHelper.bytesToMb(i));
            }
            for (PlaceholderTextValueRegistry.PlaceholderValue v : PlaceholderTextValueRegistry.getInstance().getValuesAsList()) {
                in = in.replace(v.getPlaceholder(), v.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    public static boolean containsPlaceholderValues(String in) {
        String s = PlaceholderTextValueHelper.convertFromRaw(in);
        return !s.equals(in);
    }

    private static String replaceModVersionPlaceholder(String in) {
        try {
            if (in.contains("%version:")) {
                ArrayList<String> l = new ArrayList<String>();
                int index = -1;
                for (int i = 0; i < in.length(); ++i) {
                    String s = "" + in.charAt(i);
                    if (!s.equals("%")) continue;
                    if (index == -1) {
                        index = i;
                        continue;
                    }
                    String sub = in.substring(index, i + 1);
                    if (sub.startsWith("%version:") && sub.endsWith("%")) {
                        l.add(sub);
                    }
                    index = -1;
                }
                for (String s : l) {
                    Optional o;
                    if (!s.contains(":")) continue;
                    String blank = s.substring(1, s.length() - 1);
                    String mod = blank.split(":", 2)[1];
                    if (!ModList.get().isLoaded(mod) || !(o = ModList.get().getModContainerById(mod)).isPresent()) continue;
                    ModContainer c = (ModContainer)o.get();
                    String version = c.getModInfo().getVersion().toString();
                    in = in.replace(s, version);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    private static int getTotalMods() {
        File modDir = new File("mods");
        if (modDir.exists()) {
            int i = 0;
            File[] modList = modDir.listFiles();
            if (modList != null) {
                for (File f : modList) {
                    if (!f.isFile() || !f.getName().toLowerCase().endsWith(".jar")) continue;
                    ++i;
                }
            }
            return i + 2;
        }
        return -1;
    }

    private static int getLoadedMods() {
        try {
            return ModList.get().getMods().size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static String formatToFancyDateTime(int in) {
        String s = "" + in;
        if (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

