/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItem;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemContainer;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemRegistry;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.CustomizationPropertiesHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelperScreen;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.ShapeCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SlideshowCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SplashTextCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.StringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.TextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebStringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebTextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.custombars.CustomProgressBarCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.LogoSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.ProgressBarSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.LogoSplashElement;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.ProgressBarSplashElement;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class SplashCustomizationLayer
extends GuiComponent {
    protected static SplashCustomizationLayer instance;
    private static int backgroundColor;
    private static int backgroundColor2;
    public final LogoSplashElement logoSplashElement = new LogoSplashElement(this);
    public final ProgressBarSplashElement progressBarSplashElement = new ProgressBarSplashElement(this);
    public String customBackgroundHex = null;
    protected String lastCustomBackgroundHex = null;
    public Color customBackgroundColor;
    public ResourceLocation backgroundImage = null;
    public String backgroundImagePath = null;
    public boolean scaled = false;
    public boolean fadeOut = true;
    public final boolean isEditor;
    public ReloadInstance reload;
    public Consumer<Optional<Throwable>> onFinish;
    public boolean fadeIn;
    public long fadeOutStart;
    public long fadeInStart;
    public float currentProgress;
    protected List<CustomizationItemBase> backgroundElements = new ArrayList<CustomizationItemBase>();
    protected List<CustomizationItemBase> foregroundElements = new ArrayList<CustomizationItemBase>();
    protected Minecraft mc = Minecraft.m_91087_();

    public SplashCustomizationLayer(boolean isEditor) {
        this.isEditor = isEditor;
        this.updateCustomizations();
    }

    public void renderLayer() {
        if (this.customBackgroundHex != null && !this.customBackgroundHex.equals(this.lastCustomBackgroundHex)) {
            this.customBackgroundColor = RenderUtils.getColorFromHexString((String)this.customBackgroundHex);
        }
        this.lastCustomBackgroundHex = this.customBackgroundHex;
        if (Minecraft.m_91087_() == null || Minecraft.m_91087_().m_91268_() == null) {
            return;
        }
        PoseStack matrix = new PoseStack();
        float partial = Minecraft.m_91087_().m_91296_();
        int screenWidth = this.mc.m_91268_().m_85445_();
        int screenHeight = this.mc.m_91268_().m_85446_();
        float elementOpacity = 1.0f;
        if (!this.isEditor) {
            float f1;
            long time = Util.m_137550_();
            float f = this.fadeOutStart > -1L ? (float)(time - this.fadeOutStart) / 1000.0f : -1.0f;
            float f2 = f1 = this.fadeInStart > -1L ? (float)(time - this.fadeInStart) / 500.0f : -1.0f;
            if (SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded() || !this.fadeOut) {
                f = 1.0f;
            }
            if (f >= 1.0f) {
                int l = Mth.m_14167_((float)((1.0f - Mth.m_14036_((float)(f - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(this.customBackgroundColor.getRGB(), l));
                } else {
                    SplashCustomizationLayer.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(backgroundColor2, l));
                }
                elementOpacity = 1.0f - Mth.m_14036_((float)(f - 1.0f), (float)0.0f, (float)1.0f);
            } else if (this.fadeIn) {
                int i2 = Mth.m_14165_((double)(Mth.m_14008_((double)f1, (double)0.15, (double)1.0) * 255.0));
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(this.customBackgroundColor.getRGB(), i2));
                } else {
                    SplashCustomizationLayer.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(backgroundColor2, i2));
                }
                elementOpacity = f1;
            } else {
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)this.customBackgroundColor.getRGB());
                } else {
                    SplashCustomizationLayer.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)backgroundColor);
                }
                elementOpacity = 1.0f;
            }
            if (elementOpacity > 1.0f) {
                elementOpacity = 1.0f;
            }
            if (elementOpacity < 0.0f) {
                elementOpacity = 0.0f;
            }
            if (this.backgroundImage != null) {
                RenderUtils.bindTexture((ResourceLocation)this.backgroundImage);
                if (!SplashCustomizationLayer.isCustomizationHelperScreen()) {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)elementOpacity);
                } else {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                SplashCustomizationLayer.m_93133_((PoseStack)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)screenWidth, (int)screenHeight, (int)screenWidth, (int)screenHeight);
                RenderSystem.m_69461_();
            }
        }
        if (this.isEditor || SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded() || !this.fadeOut) {
            elementOpacity = 1.0f;
        }
        for (CustomizationItemBase i : this.backgroundElements) {
            i.opacity = elementOpacity;
        }
        for (CustomizationItemBase i : this.foregroundElements) {
            i.opacity = elementOpacity;
        }
        if (!this.isEditor) {
            for (CustomizationItemBase i : this.backgroundElements) {
                i.render(matrix);
            }
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.logoSplashElement.render(matrix, screenWidth, screenHeight, partial);
        this.progressBarSplashElement.render(matrix, screenWidth, screenHeight, partial);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.isEditor) {
            for (CustomizationItemBase i : this.foregroundElements) {
                i.render(matrix);
            }
        }
    }

    public void updateCustomizations() {
        if (this.isEditor) {
            return;
        }
        try {
            this.logoSplashElement.onReloadCustomizations();
            this.progressBarSplashElement.onReloadCustomizations();
            this.customBackgroundHex = null;
            this.lastCustomBackgroundHex = null;
            this.customBackgroundColor = null;
            this.backgroundImage = null;
            this.backgroundImagePath = null;
            this.foregroundElements.clear();
            this.backgroundElements.clear();
            this.scaled = false;
            this.fadeOut = true;
            List<PropertiesSet> props = CustomizationPropertiesHandler.getProperties();
            boolean logoSet = false;
            boolean forgeTextSet = false;
            boolean forgeMemoryInfoSet = false;
            boolean progressBarSet = false;
            for (PropertiesSet s : props) {
                File f;
                String backgroundImageString;
                String cusBackColorString;
                String fadeOutString;
                boolean renderInBackground = false;
                List metas = s.getPropertiesOfType("customization-meta");
                if (metas.isEmpty()) continue;
                String roString = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
                if (roString != null && roString.equalsIgnoreCase("background")) {
                    renderInBackground = true;
                }
                Window w = Minecraft.m_91087_().m_91268_();
                String scaleString = ((PropertiesSection)metas.get(0)).getEntryValue("scale");
                if (scaleString != null && (MathUtils.isInteger((String)scaleString.replace(" ", "")) || MathUtils.isDouble((String)scaleString.replace(" ", "")))) {
                    int newscale = (int)Double.parseDouble(scaleString.replace(" ", ""));
                    if (newscale <= 0) {
                        newscale = 1;
                    }
                    w.m_85378_((double)newscale);
                    if (this.mc.f_91080_ != null) {
                        this.mc.f_91080_.f_96543_ = w.m_85445_();
                        this.mc.f_91080_.f_96544_ = w.m_85446_();
                    }
                    this.scaled = true;
                }
                int autoScaleBaseWidth = 0;
                int autoScaleBaseHeight = 0;
                String baseWidth = ((PropertiesSection)metas.get(0)).getEntryValue("autoscale_basewidth");
                String baseHeight = ((PropertiesSection)metas.get(0)).getEntryValue("autoscale_baseheight");
                if (baseWidth != null && baseHeight != null && MathUtils.isInteger((String)baseWidth) && MathUtils.isInteger((String)baseHeight)) {
                    autoScaleBaseWidth = Integer.parseInt(baseWidth);
                    autoScaleBaseHeight = Integer.parseInt(baseHeight);
                }
                if (autoScaleBaseWidth != 0 && autoScaleBaseHeight != 0) {
                    double guiWidth = w.m_85443_();
                    double guiHeight = w.m_85444_();
                    double percentX = guiWidth / (double)autoScaleBaseWidth * 100.0;
                    double percentY = guiHeight / (double)autoScaleBaseHeight * 100.0;
                    double newScaleX = percentX / 100.0 * w.m_85449_();
                    double newScaleY = percentY / 100.0 * w.m_85449_();
                    double newScale = Math.min(newScaleX, newScaleY);
                    w.m_85378_(newScale);
                    if (this.mc.f_91080_ != null) {
                        this.mc.f_91080_.f_96543_ = w.m_85445_();
                        this.mc.f_91080_.f_96544_ = w.m_85446_();
                    }
                    this.scaled = true;
                }
                if ((fadeOutString = ((PropertiesSection)metas.get(0)).getEntryValue("fadeout")) != null && fadeOutString.equalsIgnoreCase("false")) {
                    this.fadeOut = false;
                }
                if ((cusBackColorString = ((PropertiesSection)metas.get(0)).getEntryValue("backgroundcolor")) != null) {
                    this.customBackgroundHex = cusBackColorString;
                }
                if ((backgroundImageString = ((PropertiesSection)metas.get(0)).getEntryValue("backgroundimage")) != null && (f = new File(backgroundImageString)).isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png"))) {
                    this.backgroundImagePath = backgroundImageString;
                    ExternalTextureResourceLocation tex = TextureHandler.getResource((String)backgroundImageString);
                    tex.loadTexture();
                    this.backgroundImage = tex.getResourceLocation();
                }
                for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                    String action = sec.getEntryValue("action");
                    if (action == null) continue;
                    if (!CustomizationHandler.isLightModeEnabled()) {
                        if (action.equalsIgnoreCase("editlogo")) {
                            this.backgroundElements.add(new LogoSplashCustomizationItem(this.logoSplashElement, sec, logoSet));
                            logoSet = true;
                        }
                        if (action.equalsIgnoreCase("editprogressbar")) {
                            this.backgroundElements.add(new ProgressBarSplashCustomizationItem(this.progressBarSplashElement, sec, progressBarSet));
                            progressBarSet = true;
                        }
                    }
                    if (action.equalsIgnoreCase("addtext")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new StringCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new StringCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addwebtext")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new WebStringCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new WebStringCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addtexture")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new TextureCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new TextureCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addwebtexture")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new WebTextureCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new WebTextureCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addshape")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new ShapeCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new ShapeCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addslideshow")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new SlideshowCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new SlideshowCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addsplash")) {
                        String file = sec.getEntryValue("splashfilepath");
                        String text = sec.getEntryValue("text");
                        if (file != null || text != null) {
                            SplashTextCustomizationItem i = new SplashTextCustomizationItem(sec);
                            if (renderInBackground) {
                                this.backgroundElements.add(i);
                            } else {
                                this.foregroundElements.add(i);
                            }
                        }
                    }
                    if (action.equalsIgnoreCase("addcustomprogressbar")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new CustomProgressBarCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new CustomProgressBarCustomizationItem(sec));
                        }
                    }
                    if (!action.startsWith("add_")) continue;
                    String id = action.split("[_]", 2)[1];
                    CustomizationItemContainer c = CustomizationItemRegistry.getInstance().getElement(id);
                    if (c == null) continue;
                    CustomizationItem i = c.constructWithProperties(sec);
                    if (renderInBackground) {
                        this.backgroundElements.add(i);
                        continue;
                    }
                    this.foregroundElements.add(i);
                }
            }
            PropertiesSection dummySec = new PropertiesSection("customization");
            if (!logoSet) {
                this.backgroundElements.add(new LogoSplashCustomizationItem(this.logoSplashElement, dummySec, false));
            }
            if (!progressBarSet) {
                this.backgroundElements.add(new ProgressBarSplashCustomizationItem(this.progressBarSplashElement, dummySec, false));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int withAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static boolean isCustomizationHelperScreen() {
        return Minecraft.m_91087_().f_91080_ instanceof CustomizationHelperScreen;
    }

    public static SplashCustomizationLayer getInstance() {
        if (instance == null) {
            instance = new SplashCustomizationLayer(false);
        }
        return instance;
    }

    static {
        backgroundColor = FastColor.ARGB32.m_13660_((int)255, (int)239, (int)50, (int)61);
        backgroundColor2 = backgroundColor & 0xFFFFFF;
    }
}

