/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class PlaceholderTextValueRegistry {
    protected Map<String, PlaceholderValue> values = new TreeMap<String, PlaceholderValue>();
    protected List<String> categories = new ArrayList<String>();
    private static PlaceholderTextValueRegistry instance;

    public void registerValue(String valueKey, String valueDisplayName, @Nullable String valueCategory, IPlaceholderValueContent valueContent) {
        this.values.put(valueKey, new PlaceholderValue(valueKey, valueDisplayName, valueCategory, valueContent));
        if (!this.categories.contains(valueCategory)) {
            this.categories.add(valueCategory);
        }
    }

    public Map<String, PlaceholderValue> getValues() {
        return this.values;
    }

    public List<PlaceholderValue> getValuesAsList() {
        ArrayList<PlaceholderValue> l = new ArrayList<PlaceholderValue>();
        l.addAll(this.values.values());
        return l;
    }

    public PlaceholderValue getValue(String valueKey) {
        return this.values.get(valueKey);
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<PlaceholderValue> getValuesForCategory(String category) {
        ArrayList<PlaceholderValue> l = new ArrayList<PlaceholderValue>();
        for (PlaceholderValue v : this.getValuesAsList()) {
            if (!v.valueCategory.equals(category)) continue;
            l.add(v);
        }
        return l;
    }

    public static PlaceholderTextValueRegistry getInstance() {
        if (instance == null) {
            instance = new PlaceholderTextValueRegistry();
        }
        return instance;
    }

    public static class PlaceholderValue {
        public final String valueKey;
        public final String valueDisplayName;
        public final String valueCategory;
        public final IPlaceholderValueContent valueContent;

        public PlaceholderValue(String valueKey, String valueDisplayName, String valueCategory, IPlaceholderValueContent valueContent) {
            this.valueKey = valueKey;
            this.valueDisplayName = valueDisplayName;
            this.valueContent = valueContent;
            this.valueCategory = valueCategory;
        }

        public String get() {
            return this.valueContent.getContent(this);
        }

        public String getPlaceholder() {
            return "%" + this.valueKey + "%";
        }
    }

    public static interface IPlaceholderValueContent {
        public String getContent(PlaceholderValue var1);
    }
}

