/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItem;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemContainer;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemLayoutElement;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.EditHistory;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorUI;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.PreloadedLayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutElement;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutShape;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutSlideshow;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutSplashText;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutTexture;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutWebTexture;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.string.LayoutString;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.string.LayoutWebString;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.vanilla.LogoLayoutSplashElement;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.vanilla.ProgressBarLayoutSplashElement;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.vanilla.VanillaLayoutSplashElement;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.FHContextMenu;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHNotificationPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHYesNoPopup;
import de.keksuccino.drippyloadingscreen.customization.items.ShapeCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SlideshowCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SplashTextCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.StringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.TextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebStringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebTextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.LogoSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.ProgressBarSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.drippyloadingscreen.customization.rendering.slideshow.SlideshowHandler;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import de.keksuccino.konkrete.gui.content.ContextMenu;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.web.WebUtils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class LayoutEditorScreen
extends class_437 {
    public static boolean isActive = false;
    protected static final List<PropertiesSection> COPIED_ELEMENT_CACHE = new ArrayList<PropertiesSection>();
    protected static boolean initDone = false;
    public EditHistory history = new EditHistory(this);
    public List<Runnable> postRenderTasks = new ArrayList<Runnable>();
    protected List<LayoutElement> content = new ArrayList<LayoutElement>();
    protected List<LayoutElement> newContentMove;
    protected List<LayoutElement> newContentPaste = new ArrayList<LayoutElement>();
    public List<LayoutElement> deleteContentQueue = new ArrayList<LayoutElement>();
    protected List<LayoutElement> focusedObjects = new ArrayList<LayoutElement>();
    protected List<LayoutElement> focusedObjectsCache = new ArrayList<LayoutElement>();
    protected FHContextMenu multiselectRightclickMenu;
    protected LayoutEditorUI.LayoutPropertiesContextMenu propertiesRightclickMenu;
    protected String renderorder = "foreground";
    protected String requiredmods;
    protected String minimumMC;
    protected String maximumMC;
    protected String minimumDL;
    protected String maximumDL;
    protected int biggerThanWidth = 0;
    protected int biggerThanHeight = 0;
    protected int smallerThanWidth = 0;
    protected int smallerThanHeight = 0;
    protected int scale = 0;
    protected boolean fadeOut = true;
    protected int autoScalingWidth = 0;
    protected int autoScalingHeight = 0;
    protected boolean multiselectStretchedX = false;
    protected boolean multiselectStretchedY = false;
    protected List<ContextMenu> multiselectChilds = new ArrayList<ContextMenu>();
    protected Map<String, Boolean> focusChangeBlocker = new HashMap<String, Boolean>();
    protected LayoutElement topObject;
    public LayoutEditorUI ui = new LayoutEditorUI(this);
    public SplashCustomizationLayer splashLayer = new SplashCustomizationLayer(true);
    protected LogoLayoutSplashElement logoLayoutSplashElement;
    protected ProgressBarLayoutSplashElement progressBarLayoutSplashElement;

    public LayoutEditorScreen() {
        super((class_2561)new class_2585(""));
        if (!initDone) {
            KeyboardHandler.addKeyPressedListener(LayoutEditorScreen::onShortcutPressed);
            KeyboardHandler.addKeyPressedListener(LayoutEditorScreen::onArrowKeysPressed);
            initDone = true;
        }
        PropertiesSection sec = new PropertiesSection("customization");
        this.logoLayoutSplashElement = new LogoLayoutSplashElement(new LogoSplashCustomizationItem(this.splashLayer.logoSplashElement, sec, false), this);
        this.progressBarLayoutSplashElement = new ProgressBarLayoutSplashElement(new ProgressBarSplashCustomizationItem(this.splashLayer.progressBarSplashElement, sec, false), this);
        this.content.add(this.logoLayoutSplashElement);
        this.content.add(this.progressBarLayoutSplashElement);
    }

    protected void method_25426() {
        this.ui.updateUI();
        if (this.multiselectRightclickMenu != null) {
            this.multiselectRightclickMenu.closeMenu();
        }
        this.multiselectRightclickMenu = new LayoutEditorUI.MultiselectContextMenu(this);
        this.multiselectRightclickMenu.setAutoclose(false);
        this.multiselectRightclickMenu.setAlwaysOnTop(true);
        if (this.propertiesRightclickMenu != null) {
            this.propertiesRightclickMenu.closeMenu();
        }
        this.propertiesRightclickMenu = new LayoutEditorUI.LayoutPropertiesContextMenu(this, true);
        this.propertiesRightclickMenu.setAutoclose(false);
        this.propertiesRightclickMenu.setAlwaysOnTop(true);
        this.focusedObjects.clear();
        this.focusChangeBlocker.clear();
        class_1041 w = class_310.method_1551().method_22683();
        if (this.scale > 0) {
            w.method_15997((double)this.scale);
        } else {
            int mcScale = w.method_4476(class_310.method_1551().field_1690.field_1868, class_310.method_1551().method_1573());
            w.method_15997((double)mcScale);
        }
        this.field_22789 = w.method_4486();
        this.field_22790 = w.method_4502();
        if (this.autoScalingWidth != 0 && this.autoScalingHeight != 0) {
            double guiWidth = (double)this.field_22789 * w.method_4495();
            double guiHeight = (double)this.field_22790 * w.method_4495();
            double percentX = guiWidth / (double)this.autoScalingWidth * 100.0;
            double percentY = guiHeight / (double)this.autoScalingHeight * 100.0;
            double newScaleX = percentX / 100.0 * w.method_4495();
            double newScaleY = percentY / 100.0 * w.method_4495();
            double newScale = Math.min(newScaleX, newScaleY);
            w.method_15997(newScale);
            this.field_22789 = w.method_4486();
            this.field_22790 = w.method_4502();
        }
    }

    public boolean method_25422() {
        return false;
    }

    protected List<PropertiesSection> getAllProperties() {
        ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
        PropertiesSection meta = new PropertiesSection("customization-meta");
        meta.addEntry("renderorder", this.renderorder);
        if (this.splashLayer.customBackgroundHex != null) {
            meta.addEntry("backgroundcolor", this.splashLayer.customBackgroundHex);
        }
        if (this.splashLayer.backgroundImagePath != null) {
            meta.addEntry("backgroundimage", this.splashLayer.backgroundImagePath);
        }
        if (this.requiredmods != null && !this.requiredmods.replace(" ", "").equals("")) {
            meta.addEntry("requiredmods", this.requiredmods);
        }
        if (this.minimumMC != null && !this.minimumMC.replace(" ", "").equals("")) {
            meta.addEntry("minimummcversion", this.minimumMC);
        }
        if (this.maximumMC != null && !this.maximumMC.replace(" ", "").equals("")) {
            meta.addEntry("maximummcversion", this.maximumMC);
        }
        if (this.minimumDL != null && !this.minimumDL.replace(" ", "").equals("")) {
            meta.addEntry("minimumdlversion", this.minimumDL);
        }
        if (this.maximumDL != null && !this.maximumDL.replace(" ", "").equals("")) {
            meta.addEntry("maximumdlversion", this.maximumDL);
        }
        if (this.biggerThanWidth != 0) {
            meta.addEntry("biggerthanwidth", "" + this.biggerThanWidth);
        }
        if (this.biggerThanHeight != 0) {
            meta.addEntry("biggerthanheight", "" + this.biggerThanHeight);
        }
        if (this.smallerThanWidth != 0) {
            meta.addEntry("smallerthanwidth", "" + this.smallerThanWidth);
        }
        if (this.smallerThanHeight != 0) {
            meta.addEntry("smallerthanheight", "" + this.smallerThanHeight);
        }
        if (this.scale > 0) {
            meta.addEntry("scale", "" + this.scale);
        }
        if (!this.fadeOut) {
            meta.addEntry("fadeout", "false");
        }
        if (this.autoScalingWidth != 0 && this.autoScalingHeight != 0) {
            meta.addEntry("autoscale_basewidth", "" + this.autoScalingWidth);
            meta.addEntry("autoscale_baseheight", "" + this.autoScalingHeight);
        }
        l.add(meta);
        for (LayoutElement o : this.content) {
            l.addAll(o.getProperties());
        }
        return l;
    }

    protected void closeMultiselectChildMenus() {
        for (ContextMenu m : this.multiselectChilds) {
            m.closeMenu();
        }
    }

    public void addContent(LayoutElement object) {
        if (!this.content.contains((Object)object)) {
            this.content.add(object);
        }
    }

    public void removeContent(LayoutElement object) {
        if (this.content.contains((Object)object)) {
            if (this.isFocused(object)) {
                this.focusedObjects.remove((Object)object);
            }
            this.content.remove((Object)object);
        }
        this.focusChangeBlocker.clear();
    }

    public List<LayoutElement> getContent() {
        return this.content;
    }

    public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
        if (!MouseInput.isVanillaInputBlocked()) {
            if (!(KeyboardHandler.isCtrlPressed() || this.focusedObjects.isEmpty() || this.isFocusedHovered() || this.isFocusedDragged() || this.isFocusedGrabberPressed() || this.isFocusedGettingResized() || !MouseInput.isLeftMouseDown() && !MouseInput.isRightMouseDown() || this.multiselectRightclickMenu != null && this.multiselectRightclickMenu.isHovered() || this.propertiesRightclickMenu != null && this.propertiesRightclickMenu.isHovered() || this.isFocusChangeBlocked() || this.ui.bar.isHovered() || this.ui.bar.isChildOpen())) {
                this.focusedObjects.clear();
            }
            LayoutElement ob = null;
            LayoutElement top = null;
            for (LayoutElement o : this.content) {
                if (!o.isHovered()) continue;
                top = o;
                if (!MouseInput.isLeftMouseDown() && !MouseInput.isRightMouseDown()) continue;
                ob = o;
            }
            if (KeyboardHandler.isCtrlPressed() && !this.isFocused(ob) || !this.isObjectFocused() && ob != null) {
                this.setObjectFocused(ob, true, false);
            }
            this.topObject = top;
        } else if (!this.ui.bar.isHovered() && !this.ui.bar.isChildOpen()) {
            this.focusedObjects.clear();
        }
        this.renderEditorBackground(matrix);
        this.drawGrid(matrix);
        if (this.renderorder.equals("foreground")) {
            this.renderVanillaElements(matrix, partialTicks);
        }
        for (LayoutElement l : this.content) {
            if (this.isFocused(l) || (!(l instanceof VanillaLayoutSplashElement) || CustomizationHandler.isLightModeEnabled()) && l instanceof VanillaLayoutSplashElement) continue;
            l.render(matrix, mouseX, mouseY);
        }
        if (this.renderorder.equals("background")) {
            this.renderVanillaElements(matrix, partialTicks);
        }
        for (LayoutElement o : this.getFocusedObjects()) {
            o.render(matrix, mouseX, mouseY);
        }
        super.method_25394(matrix, mouseX, mouseY, partialTicks);
        if (this.multiselectRightclickMenu != null) {
            if (this.focusedObjects.size() > 1 && this.isFocusedHovered() && MouseInput.isRightMouseDown()) {
                UIBase.openScaledContextMenuAtMouse(this.multiselectRightclickMenu);
            }
            if (!PopupHandler.isPopupActive()) {
                UIBase.renderScaledContextMenu(matrix, this.multiselectRightclickMenu);
            } else {
                this.multiselectRightclickMenu.closeMenu();
            }
            if (MouseInput.isLeftMouseDown() && !this.multiselectRightclickMenu.isHovered()) {
                this.multiselectRightclickMenu.closeMenu();
            }
            if (this.multiselectRightclickMenu.isOpen()) {
                this.setFocusChangeBlocked("editor.context.multiselect", true);
            } else {
                this.setFocusChangeBlocked("editor.context.multiselect", false);
            }
        }
        if (this.propertiesRightclickMenu != null) {
            if (!this.isContentHovered() && MouseInput.isRightMouseDown()) {
                UIBase.openScaledContextMenuAtMouse(this.propertiesRightclickMenu);
            }
            if (!PopupHandler.isPopupActive()) {
                UIBase.renderScaledContextMenu(matrix, this.propertiesRightclickMenu);
            } else {
                this.propertiesRightclickMenu.closeMenu();
            }
            if (MouseInput.isLeftMouseDown() && !this.propertiesRightclickMenu.isHovered()) {
                this.propertiesRightclickMenu.closeMenu();
            }
            if (this.propertiesRightclickMenu.isOpen()) {
                this.setFocusChangeBlocked("editor.context.properties", true);
            } else {
                this.setFocusChangeBlocked("editor.context.properties", false);
            }
        }
        for (LayoutElement e : this.content) {
            if (e.rightclickMenu == null || PopupHandler.isPopupActive()) continue;
            UIBase.renderScaledContextMenu(matrix, e.rightclickMenu);
        }
        this.ui.render(matrix, this);
        if (this.newContentMove != null) {
            this.history.saveSnapshot(this.history.createSnapshot());
            this.content = this.newContentMove;
            this.newContentMove = null;
        }
        if (!this.newContentPaste.isEmpty()) {
            this.content.addAll(this.newContentPaste);
            this.newContentPaste.clear();
        }
        if (!this.deleteContentQueue.isEmpty()) {
            this.history.saveSnapshot(this.history.createSnapshot());
            for (LayoutElement e : this.deleteContentQueue) {
                if (!e.isDestroyable()) continue;
                this.removeContent(e);
            }
            this.deleteContentQueue.clear();
        }
        for (Runnable r : this.postRenderTasks) {
            r.run();
        }
        this.postRenderTasks.clear();
    }

    protected void drawGrid(class_4587 matrix) {
        if (((Boolean)DrippyLoadingScreen.config.getOrDefault("showgrid", (Object)false)).booleanValue()) {
            Color c = new Color(255, 255, 255, 100);
            int gridSize = (Integer)DrippyLoadingScreen.config.getOrDefault("gridsize", (Object)10);
            int lineThickness = 1;
            int verticalLines = class_310.method_1551().method_22683().method_4486() / gridSize;
            int horizontalLines = class_310.method_1551().method_22683().method_4502() / gridSize;
            int i1 = 1;
            int space1 = 0;
            while (i1 <= verticalLines) {
                int minX = gridSize * i1 + space1;
                int maxX = minX + lineThickness;
                int minY = 0;
                int maxY = class_310.method_1551().method_22683().method_4502();
                LayoutEditorScreen.method_25294((class_4587)matrix, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)c.getRGB());
                ++i1;
                space1 += lineThickness;
            }
            int i2 = 1;
            int space2 = 0;
            while (i2 <= horizontalLines) {
                int minX = 0;
                int maxX = class_310.method_1551().method_22683().method_4486();
                int minY = gridSize * i2 + space2;
                int maxY = minY + lineThickness;
                LayoutEditorScreen.method_25294((class_4587)matrix, (int)minX, (int)minY, (int)maxX, (int)maxY, (int)c.getRGB());
                ++i2;
                space2 += lineThickness;
            }
        }
    }

    protected void renderVanillaElements(class_4587 matrix, float partial) {
        this.splashLayer.renderLayer();
    }

    protected void renderEditorBackground(class_4587 matrix) {
        RenderSystem.enableBlend();
        Color c = new Color(239, 50, 61);
        if (this.splashLayer.customBackgroundColor != null) {
            c = this.splashLayer.customBackgroundColor;
        }
        LayoutEditorScreen.method_25294((class_4587)matrix, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)c.getRGB());
        if (this.splashLayer.backgroundImage != null) {
            RenderUtils.bindTexture((class_2960)this.splashLayer.backgroundImage);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            LayoutEditorScreen.method_25290((class_4587)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_22789, (int)this.field_22790, (int)this.field_22789, (int)this.field_22790);
            RenderSystem.disableBlend();
        }
    }

    public boolean isFocused(LayoutElement object) {
        if (PopupHandler.isPopupActive()) {
            return false;
        }
        return this.focusedObjects.contains((Object)object);
    }

    public void setObjectFocused(LayoutElement object, boolean focused, boolean ignoreBlockedFocusChange) {
        if (this.isFocusChangeBlocked() && !ignoreBlockedFocusChange) {
            return;
        }
        if (!this.content.contains((Object)object)) {
            return;
        }
        if (focused) {
            if (!this.focusedObjects.contains((Object)object)) {
                this.focusedObjects.add(object);
            }
        } else if (this.focusedObjects.contains((Object)object)) {
            this.focusedObjects.remove((Object)object);
        }
    }

    public boolean isObjectFocused() {
        return !this.focusedObjects.isEmpty();
    }

    public boolean isFocusedHovered() {
        for (LayoutElement o : this.focusedObjects) {
            if (!o.isHovered()) continue;
            return true;
        }
        return false;
    }

    public boolean isFocusedDragged() {
        for (LayoutElement o : this.focusedObjects) {
            if (!o.isDragged()) continue;
            return true;
        }
        return false;
    }

    public boolean isFocusedGrabberPressed() {
        for (LayoutElement o : this.focusedObjects) {
            if (!o.isGrabberPressed()) continue;
            return true;
        }
        return false;
    }

    public boolean isFocusedGettingResized() {
        for (LayoutElement o : this.focusedObjects) {
            if (!o.isGettingResized()) continue;
            return true;
        }
        return false;
    }

    public List<LayoutElement> getFocusedObjects() {
        ArrayList<LayoutElement> l = new ArrayList<LayoutElement>();
        l.addAll(this.focusedObjects);
        return l;
    }

    public void clearFocusedObjects() {
        if (this.multiselectRightclickMenu != null) {
            this.multiselectRightclickMenu.closeMenu();
        }
        this.focusedObjects.clear();
    }

    public boolean isContentHovered() {
        for (LayoutElement o : this.content) {
            if (!o.isHovered()) continue;
            return true;
        }
        return false;
    }

    public LayoutElement moveUp(LayoutElement o) {
        LayoutElement movedAbove = null;
        try {
            if (this.content.contains((Object)o)) {
                ArrayList<LayoutElement> l = new ArrayList<LayoutElement>();
                int index = this.content.indexOf((Object)o);
                int i = 0;
                if (index < this.content.size() - 1) {
                    for (LayoutElement o2 : this.content) {
                        if (o2 != o) {
                            l.add(o2);
                            if (i == index + 1) {
                                movedAbove = o2;
                                l.add(o);
                            }
                        }
                        ++i;
                    }
                    this.newContentMove = l;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return movedAbove;
    }

    public LayoutElement moveDown(LayoutElement o) {
        LayoutElement movedBehind = null;
        try {
            if (this.content.contains((Object)o)) {
                ArrayList<LayoutElement> l = new ArrayList<LayoutElement>();
                int index = this.content.indexOf((Object)o);
                int i = 0;
                if (index > 0) {
                    for (LayoutElement o2 : this.content) {
                        if (o2 != o) {
                            if (i == index - 1) {
                                l.add(o);
                                movedBehind = o2;
                            }
                            l.add(o2);
                        }
                        ++i;
                    }
                    if (!(movedBehind instanceof VanillaLayoutSplashElement)) {
                        this.newContentMove = l;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return movedBehind;
    }

    protected void addTexture(String path) {
        File home = new File("");
        if (path == null) {
            return;
        }
        if (path.startsWith(home.getAbsolutePath()) && ((path = path.replace(home.getAbsolutePath(), "")).startsWith("\\") || path.startsWith("/"))) {
            path = path.substring(1);
        }
        File f = new File(path);
        String filename = CharacterFilter.getBasicFilenameCharacterFilter().filterForAllowedChars(f.getName());
        if (f.exists()) {
            if (filename.equals(f.getName())) {
                this.history.saveSnapshot(this.history.createSnapshot());
                PropertiesSection sec = new PropertiesSection("customization");
                sec.addEntry("action", "addtexture");
                sec.addEntry("path", path);
                sec.addEntry("height", "100");
                sec.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
                TextureCustomizationItem i = new TextureCustomizationItem(sec);
                this.addContent(new LayoutTexture(i, this));
            } else {
                LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.textures.invalidcharacters", (String[])new String[0]), "", "", "", "", "", "");
            }
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.invalidimage.title", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.invalidimage.desc", (String[])new String[0]), "", "", "", "", "", "");
        }
    }

    protected void addWebTexture(String url) {
        String finalUrl = null;
        if (url != null) {
            url = WebUtils.filterURL((String)url);
            finalUrl = PlaceholderTextValueHelper.convertFromRaw(url);
        }
        if (WebUtils.isValidUrl(finalUrl)) {
            this.history.saveSnapshot(this.history.createSnapshot());
            PropertiesSection s = new PropertiesSection("customization");
            s.addEntry("action", "addwebtexture");
            s.addEntry("url", url);
            s.addEntry("height", "100");
            s.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
            this.addContent(new LayoutWebTexture(new WebTextureCustomizationItem(s), this));
        } else {
            LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.web.invalidurl", (String[])new String[0]), "", "", "", "", "", "");
        }
    }

    protected void addSlideshow(String name) {
        if (name == null) {
            return;
        }
        if (SlideshowHandler.slideshowExists(name)) {
            this.history.saveSnapshot(this.history.createSnapshot());
            PropertiesSection s = new PropertiesSection("customization");
            s.addEntry("action", "addslideshow");
            s.addEntry("name", name);
            s.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
            SlideshowCustomizationItem i = new SlideshowCustomizationItem(s);
            int w = SlideshowHandler.getSlideshow((String)name).width;
            int h = SlideshowHandler.getSlideshow((String)name).height;
            double ratio = (double)w / (double)h;
            i.height = 100;
            i.width = (int)((double)i.height * ratio);
            this.addContent(new LayoutSlideshow(i, this));
        } else {
            LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.slideshownotfound", (String[])new String[0]), "", "", "", "");
        }
    }

    protected void addShape(ShapeCustomizationItem.Shape shape) {
        PropertiesSection s = new PropertiesSection("customization");
        s.addEntry("action", "addshape");
        s.addEntry("shape", shape.name);
        s.addEntry("width", "100");
        s.addEntry("height", "100");
        s.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
        this.history.saveSnapshot(this.history.createSnapshot());
        this.addContent(new LayoutShape(new ShapeCustomizationItem(s), this));
    }

    protected void addMultiSplashText(String path) {
        File f;
        File home = new File("");
        if (path == null) {
            return;
        }
        if (path.startsWith(home.getAbsolutePath()) && ((path = path.replace(home.getAbsolutePath(), "")).startsWith("\\") || path.startsWith("/"))) {
            path = path.substring(1);
        }
        if ((f = new File(path)).exists() && f.getPath().toLowerCase().endsWith(".txt")) {
            this.history.saveSnapshot(this.history.createSnapshot());
            PropertiesSection sec = new PropertiesSection("customization");
            sec.addEntry("action", "addsplash");
            sec.addEntry("splashfilepath", path);
            sec.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
            SplashTextCustomizationItem i = new SplashTextCustomizationItem(sec);
            this.addContent(new LayoutSplashText(i, this));
        } else {
            LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.error.invalidfile", (String[])new String[0]));
        }
    }

    protected void addSingleSplashText(String content) {
        if (content == null) {
            return;
        }
        if (!content.replace(" ", "").equals("")) {
            this.history.saveSnapshot(this.history.createSnapshot());
            PropertiesSection sec = new PropertiesSection("customization");
            sec.addEntry("action", "addsplash");
            sec.addEntry("text", content);
            sec.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
            SplashTextCustomizationItem i = new SplashTextCustomizationItem(sec);
            this.addContent(new LayoutSplashText(i, this));
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.texttooshort.title", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.texttooshort.desc", (String[])new String[0]), "", "", "", "");
        }
    }

    protected void addWebText(String url) {
        String finalUrl = null;
        if (url != null) {
            url = WebUtils.filterURL((String)url);
            finalUrl = PlaceholderTextValueHelper.convertFromRaw(url);
        }
        if (WebUtils.isValidUrl(finalUrl)) {
            this.history.saveSnapshot(this.history.createSnapshot());
            PropertiesSection s = new PropertiesSection("customization");
            s.addEntry("action", "addwebtext");
            s.addEntry("url", url);
            s.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
            this.addContent(new LayoutWebString(new WebStringCustomizationItem(s), this));
        } else {
            LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.web.invalidurl", (String[])new String[0]), "", "", "", "", "", "");
        }
    }

    protected void addText(String text) {
        if (text == null) {
            return;
        }
        if (text.length() > 0) {
            this.history.saveSnapshot(this.history.createSnapshot());
            PropertiesSection s = new PropertiesSection("customization");
            s.addEntry("action", "addtext");
            s.addEntry("value", StringUtils.convertFormatCodes((String)text, (String)"&", (String)"\u00a7"));
            s.addEntry("y", "" + (int)((float)this.ui.bar.getHeight() * UIBase.getUIScale()));
            StringCustomizationItem i = new StringCustomizationItem(s);
            this.addContent(new LayoutString(i, this));
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.texttooshort.title", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.texttooshort.desc", (String[])new String[0]), "", "", "", "");
        }
    }

    protected void addCustomItem(CustomizationItemContainer container) {
        CustomizationItem i = container.createNew();
        if (i != null) {
            this.history.saveSnapshot(this.history.createSnapshot());
            this.addContent(new CustomizationItemLayoutElement(container, i, this));
        }
    }

    protected void deleteFocusedObjects() {
        ArrayList<LayoutElement> l = new ArrayList<LayoutElement>();
        l.addAll(this.focusedObjects);
        if (!l.isEmpty()) {
            if (l.size() == 1) {
                if (((LayoutElement)((Object)l.get(0))).isDestroyable()) {
                    ((LayoutElement)((Object)l.get(0))).destroyObject();
                } else {
                    LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.cannotdelete.title", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.cannotdelete.desc", (String[])new String[0]), "", "", "");
                }
            }
            if (l.size() > 1) {
                if (((Boolean)DrippyLoadingScreen.config.getOrDefault("editordeleteconfirmation", (Object)true)).booleanValue()) {
                    PopupHandler.displayPopup((Popup)new FHYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                        if (call.booleanValue()) {
                            this.deleteContentQueue.addAll(l);
                        }
                    }, "\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.messages.sure", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.deleteselectedobjects", (String[])new String[0]), "", "", "", "", ""));
                } else {
                    this.deleteContentQueue.addAll(l);
                }
            }
        }
    }

    public void setFocusChangeBlocked(String id, Boolean b) {
        this.focusChangeBlocker.put(id, b);
    }

    public boolean isFocusChangeBlocked() {
        return this.focusChangeBlocker.containsValue(true);
    }

    public LayoutElement getTopHoverObject() {
        return this.topObject;
    }

    public void saveLayout() {
        if (this instanceof PreloadedLayoutEditorScreen && ((PreloadedLayoutEditorScreen)this).single != null) {
            if (!CustomizationHandler.saveLayoutTo(this.getAllProperties(), ((PreloadedLayoutEditorScreen)this).single)) {
                this.saveLayoutAs();
            } else {
                EditHistory.Snapshot snap = this.history.createSnapshot();
                PreloadedLayoutEditorScreen neweditor = new PreloadedLayoutEditorScreen(snap.snapshot);
                neweditor.history = this.history;
                this.history.editor = neweditor;
                neweditor.single = ((PreloadedLayoutEditorScreen)this).single;
                class_310.method_1551().method_1507((class_437)neweditor);
            }
        } else {
            this.saveLayoutAs();
        }
    }

    public void saveLayoutAs() {
        PopupHandler.displayPopup((Popup)new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.saveas.entername", (String[])new String[0]), null, 240, call -> {
            try {
                if (call != null && call.length() > 0) {
                    String file = DrippyLoadingScreen.CUSTOMIZATION_DIR.getPath() + "/" + call + ".dllayout";
                    File f = new File(file);
                    if (!f.exists()) {
                        if (!CustomizationHandler.saveLayoutTo(this.getAllProperties(), file)) {
                            PopupHandler.displayPopup((Popup)new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.saveas.failed", (String[])new String[0])));
                        } else {
                            EditHistory.Snapshot snap = this.history.createSnapshot();
                            PreloadedLayoutEditorScreen neweditor = new PreloadedLayoutEditorScreen(snap.snapshot);
                            neweditor.history = this.history;
                            this.history.editor = neweditor;
                            neweditor.single = file;
                            class_310.method_1551().method_1507((class_437)neweditor);
                        }
                    } else {
                        PopupHandler.displayPopup((Popup)new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.saveas.failed", (String[])new String[0])));
                    }
                } else {
                    PopupHandler.displayPopup((Popup)new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.saveas.failed", (String[])new String[0])));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                PopupHandler.displayPopup((Popup)new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.layout.saveas.failed", (String[])new String[0])));
            }
        }));
    }

    public void copySelectedElements() {
        List<LayoutElement> l = this.getFocusedObjects();
        COPIED_ELEMENT_CACHE.clear();
        for (LayoutElement e : l) {
            if (e instanceof VanillaLayoutSplashElement) continue;
            COPIED_ELEMENT_CACHE.addAll(e.getProperties());
        }
    }

    public void pasteElements() {
        if (!COPIED_ELEMENT_CACHE.isEmpty()) {
            for (PropertiesSection propertiesSection : COPIED_ELEMENT_CACHE) {
                propertiesSection.removeEntry("actionid");
                propertiesSection.addEntry("actionid", CustomizationHandler.generateRandomActionId());
            }
            PropertiesSet set = new PropertiesSet("hud");
            for (PropertiesSection s : COPIED_ELEMENT_CACHE) {
                set.addProperties(s);
            }
            PreloadedLayoutEditorScreen preloadedLayoutEditorScreen = new PreloadedLayoutEditorScreen(set);
            final ArrayList<LayoutElement> l = new ArrayList<LayoutElement>();
            for (LayoutElement e : preloadedLayoutEditorScreen.content) {
                if (e instanceof VanillaLayoutSplashElement) continue;
                e.handler = this;
                ++e.object.posX;
                l.add(e);
            }
            this.history.saveSnapshot(this.history.createSnapshot());
            this.newContentPaste.addAll(l);
            this.postRenderTasks.add(new Runnable(){

                @Override
                public void run() {
                    LayoutEditorScreen.this.focusedObjects.clear();
                    LayoutEditorScreen.this.focusedObjectsCache.clear();
                    LayoutEditorScreen.this.focusedObjects.addAll(l);
                }
            });
        }
    }

    protected static void onShortcutPressed(KeyboardData d) {
        class_437 c = class_310.method_1551().field_1755;
        if (c instanceof LayoutEditorScreen) {
            if (d.keycode == 67 && KeyboardHandler.isCtrlPressed() && !PopupHandler.isPopupActive()) {
                ((LayoutEditorScreen)c).copySelectedElements();
            }
            if (d.keycode == 86 && KeyboardHandler.isCtrlPressed() && !PopupHandler.isPopupActive()) {
                ((LayoutEditorScreen)c).pasteElements();
            }
            if (d.keycode == 83 && KeyboardHandler.isCtrlPressed() && !PopupHandler.isPopupActive()) {
                ((LayoutEditorScreen)c).saveLayout();
            }
            if (d.keycode == 89 && KeyboardHandler.isCtrlPressed()) {
                ((LayoutEditorScreen)c).history.stepBack();
            }
            if (d.keycode == 90 && KeyboardHandler.isCtrlPressed()) {
                ((LayoutEditorScreen)c).history.stepForward();
            }
            if (((LayoutEditorScreen)c).isObjectFocused() && !PopupHandler.isPopupActive() && d.keycode == 261) {
                ((LayoutEditorScreen)c).deleteFocusedObjects();
            }
            if (d.keycode == 71 && KeyboardHandler.isCtrlPressed()) {
                try {
                    if (((Boolean)DrippyLoadingScreen.config.getOrDefault("showgrid", (Object)false)).booleanValue()) {
                        DrippyLoadingScreen.config.setValue("showgrid", Boolean.valueOf(false));
                    } else {
                        DrippyLoadingScreen.config.setValue("showgrid", Boolean.valueOf(true));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void onArrowKeysPressed(KeyboardData d) {
        class_437 c = class_310.method_1551().field_1755;
        if (c instanceof LayoutEditorScreen && ((LayoutEditorScreen)c).isObjectFocused() && !PopupHandler.isPopupActive()) {
            if (d.keycode != 263 && d.keycode != 262 && d.keycode != 265 && d.keycode != 264) {
                return;
            }
            EditHistory.Snapshot snap = ((LayoutEditorScreen)c).history.createSnapshot();
            boolean saveSnap = false;
            for (LayoutElement o : ((LayoutEditorScreen)c).focusedObjects) {
                if (d.keycode == 263) {
                    saveSnap = true;
                    o.setX(o.object.posX - 1);
                }
                if (d.keycode == 262) {
                    saveSnap = true;
                    o.setX(o.object.posX + 1);
                }
                if (d.keycode == 265) {
                    saveSnap = true;
                    o.setY(o.object.posY - 1);
                }
                if (d.keycode != 264) continue;
                saveSnap = true;
                o.setY(o.object.posY + 1);
            }
            if (saveSnap) {
                ((LayoutEditorScreen)c).history.saveSnapshot(snap);
            }
        }
    }

    public static void displayNotification(String ... strings) {
        PopupHandler.displayPopup((Popup)new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, strings));
    }

    public void rebuildEditor() {
        EditHistory.Snapshot snap = this.history.createSnapshot();
        PreloadedLayoutEditorScreen neweditor = new PreloadedLayoutEditorScreen(snap.snapshot);
        neweditor.history = this.history;
        String single = null;
        if (this instanceof PreloadedLayoutEditorScreen) {
            single = ((PreloadedLayoutEditorScreen)this).single;
        }
        neweditor.single = single;
        neweditor.history.editor = neweditor;
        class_310.method_1551().method_1507((class_437)neweditor);
    }
}

