/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor.elements;

import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.EditHistory;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.FHContextMenu;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHYesNoPopup;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.VanillaSplashCustomizationItemBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public abstract class LayoutElement
extends class_332 {
    public CustomizationItemBase object;
    public LayoutEditorScreen handler;
    protected boolean hovered = false;
    protected boolean dragging = false;
    protected boolean resizing = false;
    protected int activeGrabber = -1;
    protected int lastGrabber;
    protected int startDiffX;
    protected int startDiffY;
    protected int startX;
    protected int startY;
    protected int startWidth;
    protected int startHeight;
    protected int orientationDiffX = 0;
    protected int orientationDiffY = 0;
    protected boolean stretchable = false;
    protected boolean stretchX = false;
    protected boolean stretchY = false;
    protected boolean orderable = true;
    protected boolean copyable = true;
    protected boolean delayable = true;
    protected boolean fadeable = true;
    protected List<LayoutElement> hoveredLayers = new ArrayList<LayoutElement>();
    public FHContextMenu rightclickMenu;
    protected AdvancedButton stretchXButton;
    protected AdvancedButton stretchYButton;
    protected AdvancedButton o1;
    protected AdvancedButton o2;
    protected AdvancedButton o3;
    protected AdvancedButton o4;
    protected AdvancedButton o5;
    protected AdvancedButton o6;
    protected AdvancedButton o7;
    protected AdvancedButton o8;
    protected AdvancedButton o9;
    protected static boolean isShiftPressed = false;
    private static boolean shiftListener = false;
    private final boolean destroyable;
    public boolean resizable = true;
    public boolean enableVisibilityRequirements = true;
    public final String objectId = UUID.randomUUID().toString();
    private EditHistory.Snapshot cachedSnapshot;
    private boolean moving = false;
    protected static final long H_RESIZE_CURSOR = GLFW.glfwCreateStandardCursor((int)221189);
    protected static final long V_RESIZE_CURSOR = GLFW.glfwCreateStandardCursor((int)221190);
    protected static final long NORMAL_CURSOR = GLFW.glfwCreateStandardCursor((int)221185);

    public LayoutElement(@NotNull CustomizationItemBase object, boolean destroyable, @NotNull LayoutEditorScreen handler) {
        this.handler = handler;
        this.object = object;
        this.destroyable = destroyable;
        if (!shiftListener) {
            KeyboardHandler.addKeyPressedListener((Consumer)new Consumer<KeyboardData>(){

                @Override
                public void accept(KeyboardData t) {
                    if (t.keycode == 340 || t.keycode == 344) {
                        isShiftPressed = true;
                    }
                }
            });
            KeyboardHandler.addKeyReleasedListener((Consumer)new Consumer<KeyboardData>(){

                @Override
                public void accept(KeyboardData t) {
                    if (t.keycode == 340 || t.keycode == 344) {
                        isShiftPressed = false;
                    }
                }
            });
            shiftListener = true;
        }
        this.init();
    }

    public void init() {
        this.rightclickMenu = new FHContextMenu();
        this.rightclickMenu.setAlwaysOnTop(true);
        FHContextMenu layersMenu = new FHContextMenu();
        layersMenu.setAutoclose(true);
        this.rightclickMenu.addChild(layersMenu);
        AdvancedButton layersButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.items.chooselayer", (String[])new String[0]), true, press -> {
            layersMenu.getContent().clear();
            for (LayoutElement o : this.hoveredLayers) {
                Object label = o.object.value;
                if (label == null) {
                    label = "Element";
                } else if (class_310.method_1551().field_1772.method_1727((String)label) > 200) {
                    label = class_310.method_1551().field_1772.method_27523((String)label, 200) + "..";
                }
                AdvancedButton btn = new AdvancedButton(0, 0, 0, 0, (String)label, press2 -> {
                    this.handler.clearFocusedObjects();
                    this.handler.setObjectFocused(o, true, true);
                });
                layersMenu.addContent(btn);
            }
            layersMenu.setParentButton((AdvancedButton)press);
            layersMenu.openMenuAt(0, press.field_22761);
        });
        this.rightclickMenu.addContent(layersButton);
        this.rightclickMenu.addSeparator();
        FHContextMenu orientationMenu = new FHContextMenu();
        orientationMenu.setAutoclose(true);
        this.rightclickMenu.addChild(orientationMenu);
        this.o1 = new AdvancedButton(0, 0, 0, 16, "top-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-left");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o1);
        this.o2 = new AdvancedButton(0, 0, 0, 16, "mid-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-left");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o2);
        this.o3 = new AdvancedButton(0, 0, 0, 16, "bottom-left", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-left");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o3);
        this.o4 = new AdvancedButton(0, 0, 0, 16, "top-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-centered");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o4);
        this.o5 = new AdvancedButton(0, 0, 0, 16, "mid-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-centered");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o5);
        this.o6 = new AdvancedButton(0, 0, 0, 16, "bottom-centered", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-centered");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o6);
        this.o7 = new AdvancedButton(0, 0, 0, 16, "top-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("top-right");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o7);
        this.o8 = new AdvancedButton(0, 0, 0, 16, "mid-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("mid-right");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o8);
        this.o9 = new AdvancedButton(0, 0, 0, 16, "bottom-right", press -> {
            this.handler.setObjectFocused(this, false, true);
            this.setOrientation("bottom-right");
            orientationMenu.closeMenu();
        });
        orientationMenu.addContent(this.o9);
        AdvancedButton orientationButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.items.setorientation", (String[])new String[0]), true, press -> {
            orientationMenu.setParentButton((AdvancedButton)press);
            orientationMenu.openMenuAt(0, press.field_22761);
        });
        orientationButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.items.orientation.btndesc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(orientationButton);
        FHContextMenu stretchMenu = new FHContextMenu();
        stretchMenu.setAutoclose(true);
        this.rightclickMenu.addChild(stretchMenu);
        this.stretchXButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.x", (String[])new String[0]), true, press -> {
            if (this.stretchX) {
                this.setStretchedX(false, true);
            } else {
                this.setStretchedX(true, true);
            }
        });
        stretchMenu.addContent(this.stretchXButton);
        this.stretchYButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.y", (String[])new String[0]), true, press -> {
            if (this.stretchY) {
                this.setStretchedY(false, true);
            } else {
                this.setStretchedY(true, true);
            }
        });
        stretchMenu.addContent(this.stretchYButton);
        AdvancedButton stretchButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch", (String[])new String[0]), true, press -> {
            stretchMenu.setParentButton((AdvancedButton)press);
            stretchMenu.openMenuAt(0, press.field_22761);
        });
        if (this.stretchable) {
            this.rightclickMenu.addContent(stretchButton);
        }
        AdvancedButton moveUpButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.object.moveup", (String[])new String[0]), press -> {
            LayoutElement o = this.handler.moveUp(this);
            if (o != null) {
                ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.object.moveup.desc", (String[])new String[]{Locals.localize((String)"drippyloadingscreen.helper.creator.object.moveup.desc.subtext", (String[])new String[]{o.object.value})}), (String)"%n%"));
            }
        });
        moveUpButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.object.moveup.desc", (String[])new String[]{""}), (String)"%n%"));
        if (this.orderable) {
            this.rightclickMenu.addContent(moveUpButton);
        }
        AdvancedButton moveDownButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.object.movedown", (String[])new String[0]), press -> {
            LayoutElement o = this.handler.moveDown(this);
            if (o != null) {
                if (o.isVanillaElement()) {
                    ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.object.movedown.desc", (String[])new String[]{Locals.localize((String)"drippyloadingscreen.helper.creator.object.movedown.desc.subtext.vanillabutton", (String[])new String[0])}), (String)"%n%"));
                } else {
                    ((AdvancedButton)press).setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.object.movedown.desc", (String[])new String[]{Locals.localize((String)"drippyloadingscreen.helper.creator.object.movedown.desc.subtext", (String[])new String[]{o.object.value})}), (String)"%n%"));
                }
            }
        });
        moveDownButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.object.movedown.desc", (String[])new String[]{""}), (String)"%n%"));
        if (this.orderable) {
            this.rightclickMenu.addContent(moveDownButton);
        }
        AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.ui.edit.copy", (String[])new String[0]), press -> this.handler.copySelectedElements());
        if (this.copyable) {
            this.rightclickMenu.addContent(copyButton);
        }
        AdvancedButton destroyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.items.delete", (String[])new String[0]), true, press -> this.destroyObject());
        if (this.destroyable) {
            this.rightclickMenu.addContent(destroyButton);
        }
        this.rightclickMenu.addSeparator();
    }

    protected void setOrientation(String pos) {
        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        if (pos.startsWith("top-")) {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = (int)((float)this.handler.ui.bar.getHeight() * UIBase.getUIScale());
        } else {
            this.object.orientation = pos;
            this.object.posX = 0;
            this.object.posY = 0;
        }
    }

    protected int orientationMouseX(int mouseX) {
        if (this.object.orientation.endsWith("-centered")) {
            return mouseX - this.handler.field_22789 / 2;
        }
        if (this.object.orientation.endsWith("-right")) {
            return mouseX - this.handler.field_22789;
        }
        return mouseX;
    }

    protected int orientationMouseY(int mouseY) {
        if (this.object.orientation.startsWith("mid-")) {
            return mouseY - this.handler.field_22790 / 2;
        }
        if (this.object.orientation.startsWith("bottom-")) {
            return mouseY - this.handler.field_22790;
        }
        return mouseY;
    }

    public void setStretchedX(boolean b, boolean saveSnapshot) {
        if (this.isOrientationSupportedByStretchAction(b, this.stretchY)) {
            if (saveSnapshot) {
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
            }
            this.stretchX = b;
            Object stretchXLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.x", (String[])new String[0]);
            if (this.stretchX) {
                stretchXLabel = "\u00a7a" + (String)stretchXLabel;
            }
            if (this.stretchXButton != null) {
                this.stretchXButton.setMessage((String)stretchXLabel);
            }
        }
    }

    public void setStretchedY(boolean b, boolean saveSnapshot) {
        if (this.isOrientationSupportedByStretchAction(this.stretchX, b)) {
            if (saveSnapshot) {
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
            }
            this.stretchY = b;
            Object stretchYLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.y", (String[])new String[0]);
            if (this.stretchY) {
                stretchYLabel = "\u00a7a" + (String)stretchYLabel;
            }
            if (this.stretchYButton != null) {
                this.stretchYButton.setMessage((String)stretchYLabel);
            }
        }
    }

    private boolean isOrientationSupportedByStretchAction(boolean stX, boolean stY) {
        try {
            if (!(!stX || stY || this.object.orientation.equals("top-left") || this.object.orientation.equals("mid-left") || this.object.orientation.equals("bottom-left"))) {
                LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.unsupportedorientation", (String[])new String[]{"top-left, mid-left, bottom-left"}));
                return false;
            }
            if (!(!stY || stX || this.object.orientation.equals("top-left") || this.object.orientation.equals("top-centered") || this.object.orientation.equals("top-right"))) {
                LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.unsupportedorientation", (String[])new String[]{"top-left, top-centered, top-right"}));
                return false;
            }
            if (stX && stY && !this.object.orientation.equals("top-left")) {
                LayoutEditorScreen.displayNotification(Locals.localize((String)"drippyloadingscreen.helper.creator.object.stretch.unsupportedorientation", (String[])new String[]{"top-left"}));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void handleStretch() {
        try {
            if (this.stretchX) {
                this.object.posX = 0;
                this.object.width = class_310.method_1551().field_1755.field_22789;
            }
            if (this.stretchY) {
                this.object.posY = 0;
                this.object.height = class_310.method_1551().field_1755.field_22790;
            }
            if (this.stretchX && !this.stretchY) {
                this.o1.field_22763 = true;
                this.o2.field_22763 = true;
                this.o3.field_22763 = true;
                this.o4.field_22763 = false;
                this.o5.field_22763 = false;
                this.o6.field_22763 = false;
                this.o7.field_22763 = false;
                this.o8.field_22763 = false;
                this.o9.field_22763 = false;
            }
            if (this.stretchY && !this.stretchX) {
                this.o1.field_22763 = true;
                this.o2.field_22763 = false;
                this.o3.field_22763 = false;
                this.o4.field_22763 = true;
                this.o5.field_22763 = false;
                this.o6.field_22763 = false;
                this.o7.field_22763 = true;
                this.o8.field_22763 = false;
                this.o9.field_22763 = false;
            }
            if (this.stretchX && this.stretchY) {
                this.o1.field_22763 = true;
                this.o2.field_22763 = false;
                this.o3.field_22763 = false;
                this.o4.field_22763 = false;
                this.o5.field_22763 = false;
                this.o6.field_22763 = false;
                this.o7.field_22763 = false;
                this.o8.field_22763 = false;
                this.o9.field_22763 = false;
            }
            if (!this.stretchX && !this.stretchY) {
                this.o1.field_22763 = true;
                this.o2.field_22763 = true;
                this.o3.field_22763 = true;
                this.o4.field_22763 = true;
                this.o5.field_22763 = true;
                this.o6.field_22763 = true;
                this.o7.field_22763 = true;
                this.o8.field_22763 = true;
                this.o9.field_22763 = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(class_4587 matrix, int mouseX, int mouseY) {
        this.updateHovered(mouseX, mouseY);
        try {
            this.object.render(matrix);
            this.handleStretch();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.handler.isFocused(this)) {
            this.renderBorder(matrix, mouseX, mouseY);
        } else if (!(this.handler.getTopHoverObject() != this || this.handler.isObjectFocused() && (this.handler.isFocusedHovered() || this.handler.isFocusedDragged() || this.handler.isFocusedGettingResized() || this.handler.isFocusedGrabberPressed()))) {
            this.renderHighlightBorder(matrix);
        }
        if (this.activeGrabber == -1 && (!MouseInput.isLeftMouseDown() || PopupHandler.isPopupActive())) {
            GLFW.glfwSetCursor((long)class_310.method_1551().method_22683().method_4490(), (long)NORMAL_CURSOR);
        }
        if (this.isLeftClicked() && !this.resizing && !this.isGrabberPressed()) {
            this.dragging = true;
        } else if (!MouseInput.isLeftMouseDown()) {
            this.dragging = false;
        }
        if ((this.isGrabberPressed() || this.resizing) && !this.isDragged() && this.handler.isFocused(this) && this.handler.getFocusedObjects().size() == 1) {
            if (!this.resizing) {
                this.cachedSnapshot = this.handler.history.createSnapshot();
                this.lastGrabber = this.getActiveResizeGrabber();
            }
            this.resizing = true;
            this.handleResize(this.orientationMouseX(mouseX), this.orientationMouseY(mouseY));
        }
        if (this.isDragged() && this.handler.isFocused(this) && this.handler.getFocusedObjects().size() == 1) {
            if (!this.moving) {
                this.cachedSnapshot = this.handler.history.createSnapshot();
            }
            this.moving = true;
            if (mouseX >= 5 && mouseX <= this.handler.field_22789 - 5 && !this.stretchX) {
                this.object.posX = this.orientationMouseX(mouseX) - this.startDiffX;
            }
            if (mouseY >= 5 && mouseY <= this.handler.field_22790 - 5 && !this.stretchY) {
                this.object.posY = this.orientationMouseY(mouseY) - this.startDiffY;
            }
        }
        if (!this.isDragged()) {
            this.startDiffX = this.orientationMouseX(mouseX) - this.object.posX;
            this.startDiffY = this.orientationMouseY(mouseY) - this.object.posY;
            if ((this.startX != this.object.posX || this.startY != this.object.posY) && this.moving && this.cachedSnapshot != null) {
                this.handler.history.saveSnapshot(this.cachedSnapshot);
            }
            this.moving = false;
        }
        if (!MouseInput.isLeftMouseDown()) {
            if ((this.startWidth != this.object.width || this.startHeight != this.object.height) && this.resizing && this.cachedSnapshot != null) {
                this.handler.history.saveSnapshot(this.cachedSnapshot);
            }
            this.startX = this.object.posX;
            this.startY = this.object.posY;
            this.startWidth = this.object.width;
            this.startHeight = this.object.height;
            this.resizing = false;
        }
        if (this.rightclickMenu != null) {
            if (this.isRightClicked() && this.handler.isFocused(this) && this.handler.getFocusedObjects().size() == 1) {
                UIBase.openScaledContextMenuAtMouse(this.rightclickMenu);
                this.hoveredLayers.clear();
                for (LayoutElement o : this.handler.getContent()) {
                    if (!o.isHovered()) continue;
                    this.hoveredLayers.add(o);
                }
            }
            if (MouseInput.isLeftMouseDown() && !this.rightclickMenu.isHovered()) {
                this.rightclickMenu.closeMenu();
            }
            if (MouseInput.isRightMouseDown() && !this.isHovered() && !this.rightclickMenu.isHovered()) {
                this.rightclickMenu.closeMenu();
            }
            if (this.rightclickMenu.isOpen()) {
                this.handler.setFocusChangeBlocked(this.objectId, true);
            } else {
                this.handler.setFocusChangeBlocked(this.objectId, false);
            }
        }
    }

    protected void renderBorder(class_4587 matrix, int mouseX, int mouseY) {
        LayoutElement.method_25294((class_4587)matrix, (int)this.object.getPosX(), (int)this.object.getPosY(), (int)(this.object.getPosX() + this.object.width), (int)(this.object.getPosY() + 1), (int)Color.BLUE.getRGB());
        LayoutElement.method_25294((class_4587)matrix, (int)this.object.getPosX(), (int)(this.object.getPosY() + this.object.height - 1), (int)(this.object.getPosX() + this.object.width), (int)(this.object.getPosY() + this.object.height), (int)Color.BLUE.getRGB());
        LayoutElement.method_25294((class_4587)matrix, (int)this.object.getPosX(), (int)this.object.getPosY(), (int)(this.object.getPosX() + 1), (int)(this.object.getPosY() + this.object.height), (int)Color.BLUE.getRGB());
        LayoutElement.method_25294((class_4587)matrix, (int)(this.object.getPosX() + this.object.width - 1), (int)this.object.getPosY(), (int)(this.object.getPosX() + this.object.width), (int)(this.object.getPosY() + this.object.height), (int)Color.BLUE.getRGB());
        int w = 4;
        int h = 4;
        int yHorizontal = this.object.getPosY() + this.object.height / 2 - h / 2;
        int xHorizontalLeft = this.object.getPosX() - w / 2;
        int xHorizontalRight = this.object.getPosX() + this.object.width - w / 2;
        int xVertical = this.object.getPosX() + this.object.width / 2 - w / 2;
        int yVerticalTop = this.object.getPosY() - h / 2;
        int yVerticalBottom = this.object.getPosY() + this.object.height - h / 2;
        if (!this.stretchX && this.resizable) {
            LayoutElement.method_25294((class_4587)matrix, (int)xHorizontalLeft, (int)yHorizontal, (int)(xHorizontalLeft + w), (int)(yHorizontal + h), (int)Color.BLUE.getRGB());
            LayoutElement.method_25294((class_4587)matrix, (int)xHorizontalRight, (int)yHorizontal, (int)(xHorizontalRight + w), (int)(yHorizontal + h), (int)Color.BLUE.getRGB());
        }
        if (!this.stretchY && this.resizable) {
            LayoutElement.method_25294((class_4587)matrix, (int)xVertical, (int)yVerticalTop, (int)(xVertical + w), (int)(yVerticalTop + h), (int)Color.BLUE.getRGB());
            LayoutElement.method_25294((class_4587)matrix, (int)xVertical, (int)yVerticalBottom, (int)(xVertical + w), (int)(yVerticalBottom + h), (int)Color.BLUE.getRGB());
        }
        if (mouseX >= xHorizontalLeft && mouseX <= xHorizontalLeft + w && mouseY >= yHorizontal && mouseY <= yHorizontal + h) {
            if (!this.stretchX && this.resizable) {
                GLFW.glfwSetCursor((long)class_310.method_1551().method_22683().method_4490(), (long)H_RESIZE_CURSOR);
                this.activeGrabber = 0;
            } else {
                this.activeGrabber = -1;
            }
        } else if (mouseX >= xHorizontalRight && mouseX <= xHorizontalRight + w && mouseY >= yHorizontal && mouseY <= yHorizontal + h) {
            if (!this.stretchX && this.resizable) {
                GLFW.glfwSetCursor((long)class_310.method_1551().method_22683().method_4490(), (long)H_RESIZE_CURSOR);
                this.activeGrabber = 1;
            } else {
                this.activeGrabber = -1;
            }
        } else if (mouseX >= xVertical && mouseX <= xVertical + w && mouseY >= yVerticalTop && mouseY <= yVerticalTop + h) {
            if (!this.stretchY && this.resizable) {
                GLFW.glfwSetCursor((long)class_310.method_1551().method_22683().method_4490(), (long)V_RESIZE_CURSOR);
                this.activeGrabber = 2;
            } else {
                this.activeGrabber = -1;
            }
        } else if (mouseX >= xVertical && mouseX <= xVertical + w && mouseY >= yVerticalBottom && mouseY <= yVerticalBottom + h) {
            if (!this.stretchY && this.resizable) {
                GLFW.glfwSetCursor((long)class_310.method_1551().method_22683().method_4490(), (long)V_RESIZE_CURSOR);
                this.activeGrabber = 3;
            } else {
                this.activeGrabber = -1;
            }
        } else {
            this.activeGrabber = -1;
        }
        RenderUtils.setScale((class_4587)matrix, (float)0.5f);
        LayoutElement.method_25303((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)(Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.orientation", (String[])new String[0]) + ": " + this.object.orientation), (int)(this.object.getPosX() * 2), (int)(this.object.getPosY() * 2 - 26), (int)Color.WHITE.getRGB());
        LayoutElement.method_25303((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)(Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.posx", (String[])new String[0]) + ": " + this.object.getPosX()), (int)(this.object.getPosX() * 2), (int)(this.object.getPosY() * 2 - 17), (int)Color.WHITE.getRGB());
        LayoutElement.method_25303((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)(Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.width", (String[])new String[0]) + ": " + this.object.width), (int)(this.object.getPosX() * 2), (int)(this.object.getPosY() * 2 - 8), (int)Color.WHITE.getRGB());
        LayoutElement.method_25303((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)(Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.posy", (String[])new String[0]) + ": " + this.object.getPosY()), (int)((this.object.getPosX() + this.object.width) * 2 + 3), (int)((this.object.getPosY() + this.object.height) * 2 - 14), (int)Color.WHITE.getRGB());
        LayoutElement.method_25303((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)(Locals.localize((String)"drippyloadingscreen.helper.creator.items.border.height", (String[])new String[0]) + ": " + this.object.height), (int)((this.object.getPosX() + this.object.width) * 2 + 3), (int)((this.object.getPosY() + this.object.height) * 2 - 5), (int)Color.WHITE.getRGB());
        RenderUtils.postScale((class_4587)matrix);
    }

    protected void renderHighlightBorder(class_4587 matrix) {
        Color c = new Color(0, 200, 255, 255);
        LayoutElement.method_25294((class_4587)matrix, (int)this.object.getPosX(), (int)this.object.getPosY(), (int)(this.object.getPosX() + this.object.width), (int)(this.object.getPosY() + 1), (int)c.getRGB());
        LayoutElement.method_25294((class_4587)matrix, (int)this.object.getPosX(), (int)(this.object.getPosY() + this.object.height - 1), (int)(this.object.getPosX() + this.object.width), (int)(this.object.getPosY() + this.object.height), (int)c.getRGB());
        LayoutElement.method_25294((class_4587)matrix, (int)this.object.getPosX(), (int)this.object.getPosY(), (int)(this.object.getPosX() + 1), (int)(this.object.getPosY() + this.object.height), (int)c.getRGB());
        LayoutElement.method_25294((class_4587)matrix, (int)(this.object.getPosX() + this.object.width - 1), (int)this.object.getPosY(), (int)(this.object.getPosX() + this.object.width), (int)(this.object.getPosY() + this.object.height), (int)c.getRGB());
    }

    public int getActiveResizeGrabber() {
        return this.activeGrabber;
    }

    public boolean isGrabberPressed() {
        return this.getActiveResizeGrabber() != -1 && MouseInput.isLeftMouseDown();
    }

    protected int getAspectWidth(int startW, int startH, int height) {
        double ratio = (double)startW / (double)startH;
        return (int)((double)height * ratio);
    }

    protected int getAspectHeight(int startW, int startH, int width) {
        double ratio = (double)startW / (double)startH;
        return (int)((double)width / ratio);
    }

    protected void handleResize(int mouseX, int mouseY) {
        int dX;
        int dY;
        int g = this.lastGrabber;
        int sX = this.startX;
        int sY = this.startY;
        int newX = this.object.posX;
        int newY = this.object.posY;
        if (this.object.orientation.equals("top-left")) {
            // empty if block
        }
        if (this.object.orientation.equals("mid-left")) {
            if (g == 2) {
                sY = this.startY - this.startHeight / 2;
            }
            if (g == 3) {
                sY = this.startY - this.startHeight / 2;
            }
        }
        if (this.object.orientation.equals("bottom-left")) {
            if (g == 2) {
                sY = this.startY - this.startHeight;
            }
            if (g == 3) {
                sY = this.startY - this.startHeight;
            }
        }
        if (this.object.orientation.equals("top-centered")) {
            if (g == 0) {
                sX = this.startX - this.startWidth / 2;
            }
            if (g == 1) {
                sX = this.startX - this.startWidth / 2;
            }
        }
        if (this.object.orientation.equals("mid-centered")) {
            if (g == 0) {
                sX = this.startX - this.startWidth / 2;
            }
            if (g == 1) {
                sX = this.startX - this.startWidth / 2;
            }
            if (g == 2) {
                sY = this.startY - this.startHeight / 2;
            }
            if (g == 3) {
                sY = this.startY - this.startHeight / 2;
            }
        }
        if (this.object.orientation.equals("bottom-centered")) {
            if (g == 0) {
                sX = this.startX - this.startWidth / 2;
            }
            if (g == 1) {
                sX = this.startX - this.startWidth / 2;
            }
            if (g == 2) {
                sY = this.startY - this.startHeight;
            }
            if (g == 3) {
                sY = this.startY - this.startHeight;
            }
        }
        if (this.object.orientation.equals("top-right")) {
            if (g == 0) {
                sX = this.startX - this.startWidth;
            }
            if (g == 1) {
                sX = this.startX - this.startWidth;
            }
        }
        if (this.object.orientation.equals("mid-right")) {
            if (g == 0) {
                sX = this.startX - this.startWidth;
            }
            if (g == 1) {
                sX = this.startX - this.startWidth;
            }
            if (g == 2) {
                sY = this.startY - this.startHeight / 2;
            }
            if (g == 3) {
                sY = this.startY - this.startHeight / 2;
            }
        }
        if (this.object.orientation.equals("bottom-right")) {
            if (g == 0) {
                sX = this.startX - this.startWidth;
            }
            if (g == 1) {
                sX = this.startX - this.startWidth;
            }
            if (g == 2) {
                sY = this.startY - this.startHeight;
            }
            if (g == 3) {
                sY = this.startY - this.startHeight;
            }
        }
        int diffX = mouseX > sX ? Math.abs(mouseX - sX) : Math.negateExact(sX - mouseX);
        int diffY = mouseY > sY ? Math.abs(mouseY - sY) : Math.negateExact(sY - mouseY);
        if (this.object.orientation.equals("top-left")) {
            if (g == 0) {
                newX = sX + diffX;
            }
            if (g == 2) {
                newY = sY + diffY;
            }
        }
        if (this.object.orientation.equals("mid-left")) {
            if (g == 0) {
                newX = sX + diffX;
            }
            if (g == 2) {
                newY = sY + diffY;
                newY += (int)((double)this.startHeight / 2.0 - (double)diffY / 2.0);
            }
            if (g == 3) {
                dY = diffY - this.startHeight;
                newY = sY;
                newY += (int)((double)this.startHeight / 2.0 + (double)dY / 2.0);
            }
        }
        if (this.object.orientation.equals("bottom-left")) {
            if (g == 0) {
                newX = sX + diffX;
            }
            if (g == 3) {
                newY = sY + diffY;
            }
        }
        if (this.object.orientation.equals("top-centered")) {
            if (g == 0) {
                newX = sX + diffX;
                newX += (int)((double)this.startWidth / 2.0 - (double)diffX / 2.0);
            }
            if (g == 1) {
                dX = diffX - this.startWidth;
                newX = sX;
                newX += (int)((double)this.startWidth / 2.0 + (double)dX / 2.0);
            }
            if (g == 2) {
                newY = sY + diffY;
            }
        }
        if (this.object.orientation.equals("mid-centered")) {
            if (g == 0) {
                newX = sX + diffX;
                newX += (int)((double)this.startWidth / 2.0 - (double)diffX / 2.0);
            }
            if (g == 1) {
                dX = diffX - this.startWidth;
                newX = sX;
                newX += (int)((double)this.startWidth / 2.0 + (double)dX / 2.0);
            }
            if (g == 2) {
                newY = sY + diffY;
                newY += (int)((double)this.startHeight / 2.0 - (double)diffY / 2.0);
            }
            if (g == 3) {
                dY = diffY - this.startHeight;
                newY = sY;
                newY += (int)((double)this.startHeight / 2.0 + (double)dY / 2.0);
            }
        }
        if (this.object.orientation.equals("bottom-centered")) {
            if (g == 0) {
                newX = sX + diffX;
                newX += (int)((double)this.startWidth / 2.0 - (double)diffX / 2.0);
            }
            if (g == 1) {
                dX = diffX - this.startWidth;
                newX = sX;
                newX += (int)((double)this.startWidth / 2.0 + (double)dX / 2.0);
            }
            if (g == 3) {
                newY = sY + diffY;
            }
        }
        if (this.object.orientation.equals("top-right")) {
            if (g == 1) {
                newX = sX + diffX;
            }
            if (g == 2) {
                newY = sY + diffY;
            }
        }
        if (this.object.orientation.equals("mid-right")) {
            if (g == 1) {
                newX = sX + diffX;
            }
            if (g == 2) {
                newY = sY + diffY;
                newY += (int)((double)this.startHeight / 2.0 - (double)diffY / 2.0);
            }
            if (g == 3) {
                dY = diffY - this.startHeight;
                newY = sY;
                newY += (int)((double)this.startHeight / 2.0 + (double)dY / 2.0);
            }
        }
        if (this.object.orientation.equals("bottom-right")) {
            if (g == 1) {
                newX = sX + diffX;
            }
            if (g == 3) {
                newY = sY + diffY;
            }
        }
        if (!this.stretchX) {
            int h;
            int w;
            if (g == 0 && (w = this.startWidth + this.getOpponentInt(diffX)) >= 1) {
                this.object.posX = newX;
                this.object.width = w;
                if (isShiftPressed && (h = this.getAspectHeight(this.startWidth, this.startHeight, w)) >= 1) {
                    this.object.height = h;
                }
            }
            if (g == 1 && (w = this.object.width + (diffX - this.object.width)) >= 1) {
                this.object.posX = newX;
                this.object.width = w;
                if (isShiftPressed && (h = this.getAspectHeight(this.startWidth, this.startHeight, w)) >= 1) {
                    this.object.height = h;
                }
            }
        }
        if (!this.stretchY) {
            int w;
            int h;
            if (g == 2 && (h = this.startHeight + this.getOpponentInt(diffY)) >= 1) {
                this.object.posY = newY;
                this.object.height = h;
                if (isShiftPressed && (w = this.getAspectWidth(this.startWidth, this.startHeight, h)) >= 1) {
                    this.object.width = w;
                }
            }
            if (g == 3 && (h = this.object.height + (diffY - this.object.height)) >= 1) {
                this.object.posY = newY;
                this.object.height = h;
                if (isShiftPressed && (w = this.getAspectWidth(this.startWidth, this.startHeight, h)) >= 1) {
                    this.object.width = w;
                }
            }
        }
    }

    private int getOpponentInt(int i) {
        if (Math.abs(i) == i) {
            return Math.negateExact(i);
        }
        return Math.abs(i);
    }

    protected void updateHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.object.getPosX() && mouseX <= this.object.getPosX() + this.object.width && mouseY >= this.object.getPosY() && mouseY <= this.object.getPosY() + this.object.height;
    }

    public boolean isDragged() {
        return this.dragging;
    }

    public boolean isGettingResized() {
        return this.resizing;
    }

    public boolean isLeftClicked() {
        return this.isHovered() && MouseInput.isLeftMouseDown();
    }

    public boolean isRightClicked() {
        return this.isHovered() && MouseInput.isRightMouseDown();
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setX(int x) {
        this.object.posX = x;
    }

    public void setY(int y) {
        this.object.posY = y;
    }

    public int getX() {
        return this.object.getPosX();
    }

    public int getY() {
        return this.object.getPosY();
    }

    public void setWidth(int width) {
        this.object.width = width;
    }

    public void setHeight(int height) {
        this.object.height = height;
    }

    public int getWidth() {
        return this.object.width;
    }

    public int getHeight() {
        return this.object.height;
    }

    public boolean isDestroyable() {
        return this.destroyable;
    }

    public boolean isStretchable() {
        return this.stretchable;
    }

    public void destroyObject() {
        if (!this.destroyable) {
            return;
        }
        if (((Boolean)DrippyLoadingScreen.config.getOrDefault("editordeleteconfirmation", (Object)true)).booleanValue()) {
            PopupHandler.displayPopup((Popup)new FHYesNoPopup(300, new Color(0, 0, 0, 0), 240, call -> {
                if (call.booleanValue()) {
                    this.handler.deleteContentQueue.add(this);
                }
            }, "\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.messages.sure", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.deleteobject", (String[])new String[0]), "", "", "", "", ""));
        } else {
            this.handler.deleteContentQueue.add(this);
        }
    }

    public void resetObjectStates() {
        this.hovered = false;
        this.dragging = false;
        this.resizing = false;
        this.activeGrabber = -1;
        if (this.rightclickMenu != null) {
            this.rightclickMenu.closeMenu();
        }
        this.handler.setFocusChangeBlocked(this.objectId, false);
        this.handler.setObjectFocused(this, false, true);
    }

    public boolean isVanillaElement() {
        if (this.object != null) {
            return this.object instanceof VanillaSplashCustomizationItemBase;
        }
        return false;
    }

    public abstract List<PropertiesSection> getProperties();
}

