/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public abstract class CustomizationItemBase
extends class_332 {
    public String value;
    public String action;
    public int posX = 0;
    public int posY = 0;
    public String orientation = "top-left";
    public int width = -1;
    public int height = -1;
    public volatile boolean delayAppearance = false;
    public volatile boolean delayAppearanceEverytime = false;
    public volatile float delayAppearanceSec = 1.0f;
    public volatile boolean visible = true;
    public volatile boolean fadeIn = false;
    public volatile float fadeInSpeed = 1.0f;
    public volatile float opacity = 1.0f;
    protected String actionId;

    public CustomizationItemBase(PropertiesSection properties) {
        String h;
        String w;
        String o;
        String op;
        this.action = properties.getEntryValue("action");
        this.actionId = properties.getEntryValue("actionid");
        if (this.actionId == null) {
            this.actionId = CustomizationHandler.generateRandomActionId();
        }
        if ((op = properties.getEntryValue("opacity")) != null && MathUtils.isFloat((String)op)) {
            this.opacity = Float.parseFloat(op);
        }
        String x = properties.getEntryValue("x");
        String y = properties.getEntryValue("y");
        if (x != null && MathUtils.isInteger((String)x)) {
            this.posX = Integer.parseInt(x);
        }
        if (y != null && MathUtils.isInteger((String)y)) {
            this.posY = Integer.parseInt(y);
        }
        if ((o = properties.getEntryValue("orientation")) != null) {
            this.orientation = o;
        }
        if ((w = properties.getEntryValue("width")) != null) {
            if (MathUtils.isInteger((String)(w = PlaceholderTextValueHelper.convertFromRaw(w)))) {
                this.width = Integer.parseInt(w);
            }
            if (this.width < 0) {
                this.width = 0;
            }
        }
        if ((h = properties.getEntryValue("height")) != null) {
            if (MathUtils.isInteger((String)(h = PlaceholderTextValueHelper.convertFromRaw(h)))) {
                this.height = Integer.parseInt(h);
            }
            if (this.height < 0) {
                this.height = 0;
            }
        }
    }

    public abstract void render(class_4587 var1);

    public int getPosX() {
        int w = class_310.method_1551().method_22683().method_4486();
        int x = this.posX;
        if (this.orientation.equalsIgnoreCase("top-centered")) {
            x = x - this.width / 2 + w / 2;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            x = x - this.width / 2 + w / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            x = x - this.width / 2 + w / 2;
        }
        if (this.orientation.equalsIgnoreCase("top-right")) {
            x += w - this.width;
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            x += w - this.width;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            x += w - this.width;
        }
        return x;
    }

    public int getPosY() {
        int h = class_310.method_1551().method_22683().method_4502();
        int y = this.posY;
        if (this.orientation.equalsIgnoreCase("mid-left")) {
            y = y - this.height / 2 + h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-left")) {
            y += h - this.height;
        }
        if (this.orientation.equalsIgnoreCase("mid-centered")) {
            y = y - this.height / 2 + h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-centered")) {
            y += h - this.height;
        }
        if (this.orientation.equalsIgnoreCase("mid-right")) {
            y = y - this.height / 2 + h / 2;
        }
        if (this.orientation.equalsIgnoreCase("bottom-right")) {
            y += h - this.height;
        }
        return y;
    }

    public boolean shouldRender() {
        if (this.value == null) {
            return false;
        }
        return this.visible;
    }

    public String getActionId() {
        return this.actionId;
    }

    protected static boolean isEditorActive() {
        return class_310.method_1551().field_1755 instanceof LayoutEditorScreen;
    }

    public static enum Alignment {
        LEFT("left"),
        RIGHT("right"),
        CENTERED("centered");

        public final String key;

        private Alignment(String key) {
            this.key = key;
        }
    }
}

