/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.animation.ExternalGifAnimationRenderer;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class TextureCustomizationItem
extends CustomizationItemBase {
    public ExternalTextureResourceLocation texture;
    public ExternalGifAnimationRenderer gif;

    public TextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addtexture")) {
            this.value = item.getEntryValue("path");
            if (this.value != null) {
                this.value = this.value.replace("\\", "/");
                File f = new File(this.value);
                if (f.exists() && f.isFile() && (f.getName().endsWith(".png") || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg") || f.getName().endsWith(".gif"))) {
                    try {
                        int w = 0;
                        int h = 0;
                        if (f.getName().endsWith(".gif")) {
                            this.gif = TextureHandler.getGifResource((String)this.value);
                            if (this.gif != null) {
                                w = this.gif.getWidth();
                                h = this.gif.getHeight();
                            }
                        } else {
                            this.texture = TextureHandler.getResource((String)this.value);
                            if (this.texture != null) {
                                w = this.texture.getWidth();
                                h = this.texture.getHeight();
                            }
                        }
                        double ratio = (double)w / (double)h;
                        if (this.width < 0 && this.height >= 0) {
                            this.width = (int)((double)this.height * ratio);
                        }
                        if (this.height < 0 && this.width >= 0) {
                            this.height = (int)((double)this.width / ratio);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void render(class_4587 matrix) {
        if (this.shouldRender()) {
            int x = this.getPosX();
            int y = this.getPosY();
            if (this.gif != null) {
                int w = this.gif.getWidth();
                int h = this.gif.getHeight();
                int x2 = this.gif.getPosX();
                int y2 = this.gif.getPosY();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                this.gif.setPosX(x);
                this.gif.setPosY(y);
                this.gif.setWidth(this.width);
                this.gif.setHeight(this.height);
                this.gif.render(matrix);
                this.gif.setPosX(x2);
                this.gif.setPosY(y2);
                this.gif.setWidth(w);
                this.gif.setHeight(h);
                RenderSystem.disableBlend();
            } else if (this.texture != null) {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)this.texture.getResourceLocation());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                TextureCustomizationItem.method_25290((class_4587)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            }
        }
    }

    @Override
    public boolean shouldRender() {
        if (this.texture == null && this.gif == null) {
            return false;
        }
        if (this.width < 0 || this.height < 0) {
            return false;
        }
        return super.shouldRender();
    }
}

