/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class SimpleTextRenderer {
    private static final class_2960 DEFAULT_FONT = new class_2960("textures/font/ascii.png");
    private static final Map<Character, Integer> CHARACTER_X_OFFSET = new HashMap<Character, Integer>();
    private static final Map<Character, Integer> CHARACTER_HEIGHT_OFFSET = new HashMap<Character, Integer>();

    public static void init() {
        CHARACTER_X_OFFSET.clear();
        CHARACTER_X_OFFSET.put(Character.valueOf(" ".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("!".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf(".".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf(",".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf(":".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf(";".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf("*".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("'".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf("\u00b4".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf("`".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf("/".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("\\".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("}".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("{".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf(")".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("(".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("]".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("[".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("1".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("i".charAt(0)), -4);
        CHARACTER_X_OFFSET.put(Character.valueOf("I".charAt(0)), -2);
        CHARACTER_X_OFFSET.put(Character.valueOf("l".charAt(0)), -3);
        CHARACTER_X_OFFSET.put(Character.valueOf("t".charAt(0)), -2);
        CHARACTER_X_OFFSET.put(Character.valueOf("k".charAt(0)), -1);
        CHARACTER_HEIGHT_OFFSET.clear();
        CHARACTER_HEIGHT_OFFSET.put(Character.valueOf("p".charAt(0)), 1);
        CHARACTER_HEIGHT_OFFSET.put(Character.valueOf("q".charAt(0)), 1);
        CHARACTER_HEIGHT_OFFSET.put(Character.valueOf("y".charAt(0)), 1);
        CHARACTER_HEIGHT_OFFSET.put(Character.valueOf("j".charAt(0)), 1);
        CHARACTER_HEIGHT_OFFSET.put(Character.valueOf("g".charAt(0)), 1);
        CHARACTER_HEIGHT_OFFSET.put(Character.valueOf("@".charAt(0)), 1);
    }

    public static void drawString(class_4587 matrix, String text, int x, int y, int rgbColor, float alpha, float scale) {
        float[] color = SimpleTextRenderer.getColor(rgbColor);
        int xOffset = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c > '\u00ff') continue;
            int charX = (c & 0xF) * 8;
            int charY = (c >> 4 & 0xF) * 8;
            int heightOffset = 0;
            if (CHARACTER_HEIGHT_OFFSET.containsKey(Character.valueOf(c))) {
                heightOffset = CHARACTER_HEIGHT_OFFSET.get(Character.valueOf(c));
            }
            RenderUtils.bindTexture((class_2960)DEFAULT_FONT, (boolean)true);
            matrix.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)alpha);
            matrix.method_22904((double)((float)x + (float)(i * 6) * scale + (float)xOffset * scale), (double)y, 0.0);
            matrix.method_22905(scale, scale, 0.0f);
            class_332.method_25290((class_4587)matrix, (int)0, (int)0, (float)charX, (float)charY, (int)6, (int)(7 + heightOffset), (int)128, (int)128);
            if (CHARACTER_X_OFFSET.containsKey(Character.valueOf(c))) {
                xOffset += CHARACTER_X_OFFSET.get(Character.valueOf(c)).intValue();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrix.method_22909();
        }
    }

    public static void drawStringWithShadow(class_4587 matrix, String text, int x, int y, int rgbColor, float alpha, float scale) {
        SimpleTextRenderer.drawString(matrix, text, x + Math.max((int)(1.0f * scale), 1), y + Math.max((int)(1.0f * scale), 1), 0, alpha / 2.0f, scale);
        SimpleTextRenderer.drawString(matrix, text, x, y, rgbColor, alpha, scale);
    }

    public static int getStringWidth(String text) {
        int length = 0;
        for (char c : text.toCharArray()) {
            int i = 6;
            if (CHARACTER_X_OFFSET.containsKey(Character.valueOf(c))) {
                i += CHARACTER_X_OFFSET.get(Character.valueOf(c)).intValue();
            }
            length += i;
        }
        return length;
    }

    public static int getStringHeight() {
        return 7;
    }

    protected static float[] getColor(int rgb) {
        float[] color = new float[]{0.0f, 0.0f, 0.0f};
        color[2] = (float)(rgb & 0xFF) / 255.0f;
        color[1] = (float)(rgb >> 8 & 0xFF) / 255.0f;
        color[0] = (float)(rgb >> 16 & 0xFF) / 255.0f;
        return color;
    }
}

