/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.rendering.splash;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItem;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemContainer;
import de.keksuccino.drippyloadingscreen.api.item.CustomizationItemRegistry;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.CustomizationPropertiesHandler;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelperScreen;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.ShapeCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SlideshowCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.SplashTextCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.StringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.TextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebStringCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.WebTextureCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.custombars.CustomProgressBarCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.LogoSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.vanilla.ProgressBarSplashCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.LogoSplashElement;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.elements.ProgressBarSplashElement;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4011;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

public class SplashCustomizationLayer
extends class_332 {
    protected static SplashCustomizationLayer instance;
    private static final int backgroundColor;
    private static final int backgroundColor2;
    public final LogoSplashElement logoSplashElement = new LogoSplashElement(this);
    public final ProgressBarSplashElement progressBarSplashElement = new ProgressBarSplashElement(this);
    public String customBackgroundHex = null;
    protected String lastCustomBackgroundHex = null;
    public Color customBackgroundColor;
    public class_2960 backgroundImage = null;
    public String backgroundImagePath = null;
    public boolean scaled = false;
    public boolean fadeOut = true;
    public final boolean isEditor;
    public class_4011 reload;
    public Consumer<Optional<Throwable>> exceptionHandler;
    public boolean reloading;
    public float progress;
    public long reloadCompleteTime = -1L;
    public long reloadStartTime = -1L;
    protected List<CustomizationItemBase> backgroundElements = new ArrayList<CustomizationItemBase>();
    protected List<CustomizationItemBase> foregroundElements = new ArrayList<CustomizationItemBase>();
    protected class_310 mc = class_310.method_1551();

    public SplashCustomizationLayer(boolean isEditor) {
        this.isEditor = isEditor;
        this.updateCustomizations();
    }

    public void renderLayer() {
        if (this.customBackgroundHex != null && !this.customBackgroundHex.equals(this.lastCustomBackgroundHex)) {
            this.customBackgroundColor = RenderUtils.getColorFromHexString((String)this.customBackgroundHex);
        }
        this.lastCustomBackgroundHex = this.customBackgroundHex;
        if (class_310.method_1551() == null || class_310.method_1551().method_22683() == null) {
            return;
        }
        class_4587 matrix = new class_4587();
        float partial = class_310.method_1551().method_1488();
        int screenWidth = this.mc.method_22683().method_4486();
        int screenHeight = this.mc.method_22683().method_4502();
        float elementOpacity = 1.0f;
        if (!this.isEditor) {
            float f1;
            long time = System.currentTimeMillis();
            float f = this.reloadCompleteTime > -1L ? (float)(time - this.reloadCompleteTime) / 1000.0f : -1.0f;
            float f2 = f1 = this.reloadStartTime > -1L ? (float)(time - this.reloadStartTime) / 500.0f : -1.0f;
            if (SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded() || !this.fadeOut) {
                f = 1.0f;
            }
            if (f >= 1.0f) {
                int l = class_3532.method_15386((float)((1.0f - class_3532.method_15363((float)(f - 1.0f), (float)0.0f, (float)1.0f)) * 255.0f));
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.method_25294((class_4587)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(this.customBackgroundColor.getRGB(), l));
                } else {
                    SplashCustomizationLayer.method_25294((class_4587)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(backgroundColor2, l));
                }
                elementOpacity = 1.0f - class_3532.method_15363((float)(f - 1.0f), (float)0.0f, (float)1.0f);
            } else if (this.reloading) {
                int i2 = class_3532.method_15384((double)(class_3532.method_15350((double)f1, (double)0.15, (double)1.0) * 255.0));
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.method_25294((class_4587)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(this.customBackgroundColor.getRGB(), i2));
                } else {
                    SplashCustomizationLayer.method_25294((class_4587)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)SplashCustomizationLayer.withAlpha(backgroundColor2, i2));
                }
                elementOpacity = f1;
            } else {
                if (this.customBackgroundColor != null) {
                    SplashCustomizationLayer.method_25294((class_4587)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)this.customBackgroundColor.getRGB());
                } else {
                    SplashCustomizationLayer.method_25294((class_4587)matrix, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)backgroundColor);
                }
                elementOpacity = 1.0f;
            }
            if (elementOpacity > 1.0f) {
                elementOpacity = 1.0f;
            }
            if (elementOpacity < 0.0f) {
                elementOpacity = 0.0f;
            }
            if (this.backgroundImage != null) {
                RenderUtils.bindTexture((class_2960)this.backgroundImage);
                RenderSystem.enableBlend();
                if (!SplashCustomizationLayer.isCustomizationHelperScreen()) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)elementOpacity);
                } else {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                SplashCustomizationLayer.method_25290((class_4587)matrix, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)screenWidth, (int)screenHeight, (int)screenWidth, (int)screenHeight);
                RenderSystem.disableBlend();
            }
        }
        if (this.isEditor || SplashCustomizationLayer.isCustomizationHelperScreen() || DrippyLoadingScreen.isFancyMenuLoaded() || !this.fadeOut) {
            elementOpacity = 1.0f;
        }
        for (CustomizationItemBase i : this.backgroundElements) {
            i.opacity = elementOpacity;
        }
        for (CustomizationItemBase i : this.foregroundElements) {
            i.opacity = elementOpacity;
        }
        if (!this.isEditor) {
            for (CustomizationItemBase i : this.backgroundElements) {
                i.render(matrix);
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.logoSplashElement.render(matrix, screenWidth, screenHeight, partial);
        this.progressBarSplashElement.render(matrix, screenWidth, screenHeight, partial);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.isEditor) {
            for (CustomizationItemBase i : this.foregroundElements) {
                i.render(matrix);
            }
        }
    }

    public void updateCustomizations() {
        if (this.isEditor) {
            return;
        }
        try {
            this.logoSplashElement.onReloadCustomizations();
            this.progressBarSplashElement.onReloadCustomizations();
            this.customBackgroundHex = null;
            this.lastCustomBackgroundHex = null;
            this.customBackgroundColor = null;
            this.backgroundImage = null;
            this.backgroundImagePath = null;
            this.foregroundElements.clear();
            this.backgroundElements.clear();
            this.scaled = false;
            this.fadeOut = true;
            List<PropertiesSet> props = CustomizationPropertiesHandler.getProperties();
            boolean logoSet = false;
            boolean progressBarSet = false;
            for (PropertiesSet s : props) {
                File f;
                String backgroundImageString;
                String cusBackColorString;
                String fadeOutString;
                boolean renderInBackground = false;
                List metas = s.getPropertiesOfType("customization-meta");
                if (metas.isEmpty()) continue;
                String roString = ((PropertiesSection)metas.get(0)).getEntryValue("renderorder");
                if (roString != null && roString.equalsIgnoreCase("background")) {
                    renderInBackground = true;
                }
                class_1041 w = class_310.method_1551().method_22683();
                String scaleString = ((PropertiesSection)metas.get(0)).getEntryValue("scale");
                if (scaleString != null && (MathUtils.isInteger((String)scaleString.replace(" ", "")) || MathUtils.isDouble((String)scaleString.replace(" ", "")))) {
                    int newscale = (int)Double.parseDouble(scaleString.replace(" ", ""));
                    if (newscale <= 0) {
                        newscale = 1;
                    }
                    w.method_15997((double)newscale);
                    if (this.mc.field_1755 != null) {
                        this.mc.field_1755.field_22789 = w.method_4486();
                        this.mc.field_1755.field_22790 = w.method_4502();
                    }
                    this.scaled = true;
                }
                int autoScaleBaseWidth = 0;
                int autoScaleBaseHeight = 0;
                String baseWidth = ((PropertiesSection)metas.get(0)).getEntryValue("autoscale_basewidth");
                String baseHeight = ((PropertiesSection)metas.get(0)).getEntryValue("autoscale_baseheight");
                if (baseWidth != null && baseHeight != null && MathUtils.isInteger((String)baseWidth) && MathUtils.isInteger((String)baseHeight)) {
                    autoScaleBaseWidth = Integer.parseInt(baseWidth);
                    autoScaleBaseHeight = Integer.parseInt(baseHeight);
                }
                if (autoScaleBaseWidth != 0 && autoScaleBaseHeight != 0) {
                    double guiWidth = w.method_4480();
                    double guiHeight = w.method_4507();
                    double percentX = guiWidth / (double)autoScaleBaseWidth * 100.0;
                    double percentY = guiHeight / (double)autoScaleBaseHeight * 100.0;
                    double newScaleX = percentX / 100.0 * w.method_4495();
                    double newScaleY = percentY / 100.0 * w.method_4495();
                    double newScale = Math.min(newScaleX, newScaleY);
                    w.method_15997(newScale);
                    if (this.mc.field_1755 != null) {
                        this.mc.field_1755.field_22789 = w.method_4486();
                        this.mc.field_1755.field_22790 = w.method_4502();
                    }
                    this.scaled = true;
                }
                if ((fadeOutString = ((PropertiesSection)metas.get(0)).getEntryValue("fadeout")) != null && fadeOutString.equalsIgnoreCase("false")) {
                    this.fadeOut = false;
                }
                if ((cusBackColorString = ((PropertiesSection)metas.get(0)).getEntryValue("backgroundcolor")) != null) {
                    this.customBackgroundHex = cusBackColorString;
                }
                if ((backgroundImageString = ((PropertiesSection)metas.get(0)).getEntryValue("backgroundimage")) != null && (f = new File(backgroundImageString)).isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png"))) {
                    this.backgroundImagePath = backgroundImageString;
                    ExternalTextureResourceLocation tex = TextureHandler.getResource((String)backgroundImageString);
                    tex.loadTexture();
                    this.backgroundImage = tex.getResourceLocation();
                }
                for (PropertiesSection sec : s.getPropertiesOfType("customization")) {
                    String action = sec.getEntryValue("action");
                    if (action == null) continue;
                    if (!CustomizationHandler.isLightModeEnabled()) {
                        if (action.equalsIgnoreCase("editlogo")) {
                            this.backgroundElements.add(new LogoSplashCustomizationItem(this.logoSplashElement, sec, logoSet));
                            logoSet = true;
                        }
                        if (action.equalsIgnoreCase("editprogressbar")) {
                            this.backgroundElements.add(new ProgressBarSplashCustomizationItem(this.progressBarSplashElement, sec, progressBarSet));
                            progressBarSet = true;
                        }
                    }
                    if (action.equalsIgnoreCase("addtext")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new StringCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new StringCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addwebtext")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new WebStringCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new WebStringCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addtexture")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new TextureCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new TextureCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addwebtexture")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new WebTextureCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new WebTextureCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addshape")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new ShapeCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new ShapeCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addslideshow")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new SlideshowCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new SlideshowCustomizationItem(sec));
                        }
                    }
                    if (action.equalsIgnoreCase("addsplash")) {
                        String file = sec.getEntryValue("splashfilepath");
                        String text = sec.getEntryValue("text");
                        if (file != null || text != null) {
                            SplashTextCustomizationItem i = new SplashTextCustomizationItem(sec);
                            if (renderInBackground) {
                                this.backgroundElements.add(i);
                            } else {
                                this.foregroundElements.add(i);
                            }
                        }
                    }
                    if (action.equalsIgnoreCase("addcustomprogressbar")) {
                        if (renderInBackground) {
                            this.backgroundElements.add(new CustomProgressBarCustomizationItem(sec));
                        } else {
                            this.foregroundElements.add(new CustomProgressBarCustomizationItem(sec));
                        }
                    }
                    if (!action.startsWith("add_")) continue;
                    String id = action.split("[_]", 2)[1];
                    CustomizationItemContainer c = CustomizationItemRegistry.getInstance().getElement(id);
                    if (c == null) continue;
                    CustomizationItem i = c.constructWithProperties(sec);
                    if (renderInBackground) {
                        this.backgroundElements.add(i);
                        continue;
                    }
                    this.foregroundElements.add(i);
                }
            }
            PropertiesSection dummySec = new PropertiesSection("customization");
            if (!logoSet) {
                this.backgroundElements.add(new LogoSplashCustomizationItem(this.logoSplashElement, dummySec, false));
            }
            if (!progressBarSet) {
                this.backgroundElements.add(new ProgressBarSplashCustomizationItem(this.progressBarSplashElement, dummySec, false));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int withAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static boolean isCustomizationHelperScreen() {
        return class_310.method_1551().field_1755 instanceof CustomizationHelperScreen;
    }

    public static SplashCustomizationLayer getInstance() {
        if (instance == null) {
            instance = new SplashCustomizationLayer(false);
        }
        return instance;
    }

    static {
        backgroundColor = class_5253.class_5254.method_27764((int)255, (int)239, (int)50, (int)61);
        backgroundColor2 = backgroundColor & 0xFFFFFF;
    }
}

