/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.DurabilityViewer;

import de.guntram.mcmod.GBForgetools.DurabilityViewer.ModConfigurationHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConfigurationProvider {
    static ConfigurationProvider instance;
    private Map<String, ModConfigurationHandler> knownMods = new HashMap<String, ModConfigurationHandler>();

    private ConfigurationProvider() {
    }

    public static ConfigurationProvider getInstance() {
        if (instance == null) {
            instance = new ConfigurationProvider();
        }
        return instance;
    }

    public static void register(String modName, ModConfigurationHandler handler) {
        ConfigurationProvider.getInstance().knownMods.put(modName, handler);
    }

    public static boolean hasMod(String modName) {
        return ConfigurationProvider.getInstance().knownMods.containsKey(modName);
    }

    public static ModConfigurationHandler getHandler(String modName) {
        return ConfigurationProvider.getInstance().knownMods.get(modName);
    }

    public static File getSuggestedFile(String modid) {
        File dir = new File("config");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!dir.isDirectory()) {
            System.err.println("Can't make directory " + dir.getAbsolutePath() + ", config subsystem will not work");
        }
        File suggestion = new File(dir, modid + ".json");
        return suggestion;
    }

    public static Set<String> getRegisteredMods() {
        return ConfigurationProvider.getInstance().knownMods.keySet();
    }
}

