/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiElements;

import com.mojang.blaze3d.vertex.PoseStack;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiModOptions;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Types.ConfigurationMinecraftColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ColorSelector
extends AbstractWidget {
    private ColorButton[] buttons;
    private ConfigurationMinecraftColor currentColor;
    private String option;
    private AbstractWidget element;
    private GuiModOptions optionScreen;
    private int[] standardColors = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};

    public ColorSelector(GuiModOptions optionScreen, TextComponent message) {
        super(0, 0, 120, 120, (Component)message);
        this.buttons = new ColorButton[16];
        this.optionScreen = optionScreen;
    }

    public void init() {
        TextComponent buttonText = new TextComponent("");
        this.f_93620_ = (this.optionScreen.f_96543_ - this.f_93618_) / 2;
        this.f_93621_ = (this.optionScreen.f_96544_ - this.f_93619_) / 2;
        for (int i = 0; i < 16; ++i) {
            this.buttons[i] = new ColorButton(this, this.f_93620_ + i / 4 * 25, this.f_93621_ + i % 4 * 25, 20, 20, buttonText, i, this.standardColors[i]);
        }
        this.f_93624_ = false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93624_) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (!this.buttons[i].m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            for (int i = 0; i < 16; ++i) {
                this.buttons[i].m_6305_(stack, mouseX, mouseY, partialTicks);
            }
        }
    }

    public void setLink(String option, AbstractWidget element) {
        this.option = option;
        this.element = element;
    }

    public void setCurrentColor(ConfigurationMinecraftColor color) {
        this.currentColor = color;
    }

    public ConfigurationMinecraftColor getCurrentColor() {
        return this.currentColor;
    }

    public void onColorSelected(int color) {
        this.currentColor.colorIndex = color;
        this.optionScreen.onConfigChanging(this.option, this.currentColor);
        this.element.m_93666_(null);
        this.optionScreen.subscreenFinished();
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    private class ColorButton
    extends AbstractWidget {
        private final ColorSelector parent;
        private final int index;
        private final int color;

        public ColorButton(ColorSelector parent, int x, int y, int width, int height, TextComponent message, int index, int color) {
            super(x, y, width, height, (Component)message);
            this.index = index;
            this.color = color;
            this.parent = parent;
        }

        protected void m_7906_(PoseStack stack, Minecraft mc, int mouseX, int mouseY) {
            if (this.f_93624_) {
                super.m_7906_(stack, mc, mouseX, mouseY);
                int x1 = this.f_93620_ + 3;
                int x2 = this.f_93620_ + this.f_93618_ - 3;
                int y1 = this.f_93621_ + 3;
                int y2 = this.f_93621_ + this.f_93619_ - 3;
                if (this.index == this.parent.getCurrentColor().colorIndex) {
                    GuiComponent.m_93172_((PoseStack)stack, (int)x1, (int)y1, (int)x2, (int)y2, (int)-1);
                    ++x1;
                    ++y1;
                    --x2;
                    --y2;
                }
                GuiComponent.m_93172_((PoseStack)stack, (int)x1, (int)y1, (int)x2, (int)y2, (int)(this.color | 0xFF000000));
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.parent.onColorSelected(this.index);
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }
}

