/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiElements;

import com.mojang.blaze3d.vertex.PoseStack;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiElements.GuiSlider;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiModOptions;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Types.ConfigurationTrueColor;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Types.SliderValueConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ColorPicker
extends AbstractWidget
implements SliderValueConsumer {
    private ColorDisplayAreaButton colorDisplay;
    private GuiSlider redSlider;
    private GuiSlider greenSlider;
    private GuiSlider blueSlider;
    private String option;
    private AbstractWidget element;
    private GuiModOptions optionScreen;
    private int currentColor;

    public ColorPicker(GuiModOptions optionScreen, int initialRGB, Component message) {
        super(0, 0, 250, 100, message);
        this.currentColor = initialRGB;
        this.optionScreen = optionScreen;
    }

    public void init() {
        MutableComponent buttonITextComponent = Component.m_237113_((String)"");
        this.f_93620_ = (this.optionScreen.f_96543_ - this.f_93618_) / 2;
        this.f_93621_ = (this.optionScreen.f_96544_ - this.f_93619_) / 2;
        this.colorDisplay = new ColorDisplayAreaButton(this, this.f_93620_, this.f_93621_, 20, 100, (Component)buttonITextComponent, this.currentColor);
        this.redSlider = new GuiSlider(this, this.f_93620_ + 50, this.f_93621_, 200, 20, this.currentColor >> 16 & 0xFF, 0, 255, "red");
        this.greenSlider = new GuiSlider(this, this.f_93620_ + 50, this.f_93621_ + 40, 200, 20, this.currentColor >> 16 & 0xFF, 0, 255, "green");
        this.blueSlider = new GuiSlider(this, this.f_93620_ + 50, this.f_93621_ + 80, 200, 20, this.currentColor >> 16 & 0xFF, 0, 255, "blue");
        this.f_93624_ = false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.f_93624_ && (this.redSlider.m_6375_(mouseX, mouseY, button) || this.greenSlider.m_6375_(mouseX, mouseY, button) || this.blueSlider.m_6375_(mouseX, mouseY, button));
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            this.optionScreen.getFontRenderer().m_92883_(stack, "R", (float)(this.f_93620_ + 30), (float)(this.f_93621_ + 10), 0xFF0000);
            this.optionScreen.getFontRenderer().m_92883_(stack, "G", (float)(this.f_93620_ + 30), (float)(this.f_93621_ + 50), 65280);
            this.optionScreen.getFontRenderer().m_92883_(stack, "B", (float)(this.f_93620_ + 30), (float)(this.f_93621_ + 90), 255);
            this.colorDisplay.m_6305_(stack, mouseX, mouseY, partialTicks);
            this.redSlider.m_6305_(stack, mouseX, mouseY, this.f_93625_);
            this.greenSlider.m_6305_(stack, mouseX, mouseY, this.f_93625_);
            this.blueSlider.m_6305_(stack, mouseX, mouseY, this.f_93625_);
        }
    }

    public void setLink(String option, AbstractWidget element) {
        this.option = option;
        this.element = element;
    }

    public void setCurrentColor(ConfigurationTrueColor color) {
        this.currentColor = color.getInt();
        this.colorDisplay.setColor(this.currentColor);
        this.redSlider.reinitialize(color.red);
        this.greenSlider.reinitialize(color.green);
        this.blueSlider.reinitialize(color.blue);
    }

    public ConfigurationTrueColor getCurrentColor() {
        return new ConfigurationTrueColor(this.currentColor);
    }

    public void onDoneButton() {
        this.optionScreen.onConfigChanging(this.option, new ConfigurationTrueColor(this.currentColor));
        this.element.m_93666_(null);
        this.optionScreen.subscreenFinished();
    }

    @Override
    public void onConfigChanging(String color, Object value) {
        if (color.equals("red")) {
            this.currentColor = this.currentColor & 0xFFFF | (Integer)value << 16;
        } else if (color.equals("green")) {
            this.currentColor = this.currentColor & 0xFF00FF | (Integer)value << 8;
        } else if (color.equals("blue")) {
            this.currentColor = this.currentColor & 0xFFFF00 | (Integer)value;
        }
        this.colorDisplay.setColor(this.currentColor);
        this.optionScreen.onConfigChanging(this.option, new ConfigurationTrueColor(this.currentColor));
    }

    @Override
    public boolean wasMouseReleased() {
        return this.optionScreen.wasMouseReleased();
    }

    @Override
    public void setMouseReleased(boolean value) {
        this.optionScreen.setMouseReleased(value);
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    private class ColorDisplayAreaButton
    extends AbstractWidget {
        private final ColorPicker parent;
        private int rgb;

        public ColorDisplayAreaButton(ColorPicker parent, int x, int y, int width, int height, Component message, int rgb) {
            super(x, y, width, height, message);
            this.rgb = rgb;
            this.parent = parent;
        }

        public void setColor(int rgb) {
            this.rgb = rgb;
        }

        protected void m_7906_(PoseStack stack, Minecraft mc, int mouseX, int mouseY) {
            if (this.f_93624_) {
                GuiComponent.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)(this.rgb | 0xFF000000));
            }
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }
}

