/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiElements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.IConfiguration;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Types.SliderValueConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GuiSlider
extends AbstractWidget {
    Type type;
    boolean dragging;
    double sliderValue;
    double defaultValue;
    double min;
    double max;
    String configOption;
    SliderValueConsumer parent;

    public GuiSlider(SliderValueConsumer optionScreen, int x, int y, int width, int height, IConfiguration config, String option) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"?"));
        Object value = config.getValue(option);
        if (value instanceof Double) {
            this.m_93666_((Component)Component.m_237113_((String)Double.toString((Double)value)));
            this.min = (Double)config.getMin(option);
            this.max = (Double)config.getMax(option);
            this.defaultValue = (Double)config.getDefault(option);
            this.sliderValue = ((Double)value - this.min) / (this.max - this.min);
            this.type = Type.DOUBLE;
        } else if (value instanceof Float) {
            this.m_93666_((Component)Component.m_237113_((String)Float.toString(((Float)value).floatValue())));
            this.min = ((Float)config.getMin(option)).floatValue();
            this.max = ((Float)config.getMax(option)).floatValue();
            this.defaultValue = ((Float)config.getDefault(option)).floatValue();
            this.sliderValue = ((double)((Float)value).floatValue() - this.min) / (this.max - this.min);
            this.type = Type.FLOAT;
        } else {
            this.m_93666_((Component)Component.m_237113_((String)Integer.toString((Integer)value)));
            this.min = ((Integer)config.getMin(option)).intValue();
            this.max = ((Integer)config.getMax(option)).intValue();
            this.defaultValue = ((Integer)config.getDefault(option)).intValue();
            this.sliderValue = ((double)((Integer)value).intValue() - this.min) / (this.max - this.min);
            this.type = Type.INT;
        }
        this.configOption = option;
        this.parent = optionScreen;
        optionScreen.setMouseReleased(false);
    }

    public GuiSlider(SliderValueConsumer optionScreen, int x, int y, int width, int height, int val, int min, int max, String option) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.m_93666_((Component)Component.m_237113_((String)("" + val)));
        this.min = min;
        this.max = max;
        this.sliderValue = (val - min) / (max - min);
        this.type = Type.INT;
        this.configOption = option;
        this.parent = optionScreen;
    }

    public void reinitialize(double value) {
        this.sliderValue = (value - this.min) / (this.max - this.min);
        switch (this.type) {
            case DOUBLE: {
                this.m_93666_((Component)Component.m_237113_((String)Double.toString(value)));
                break;
            }
            case FLOAT: {
                this.m_93666_((Component)Component.m_237113_((String)Float.toString((float)value)));
                break;
            }
            case INT: {
                this.m_93666_((Component)Component.m_237113_((String)Integer.toString((int)value)));
            }
        }
    }

    private void updateValue(double value) {
        switch (this.type) {
            case DOUBLE: {
                double doubleVal = value * (this.max - this.min) + this.min;
                this.m_93666_((Component)Component.m_237113_((String)String.format("%.2f", doubleVal)));
                this.parent.onConfigChanging(this.configOption, doubleVal);
                break;
            }
            case FLOAT: {
                float floatVal = (float)(value * (this.max - this.min) + this.min);
                this.m_93666_((Component)Component.m_237113_((String)String.format("%.2f", Float.valueOf(floatVal))));
                this.parent.onConfigChanging(this.configOption, Float.valueOf(floatVal));
                break;
            }
            case INT: {
                int intVal = (int)(value * (this.max - this.min) + this.min + 0.5);
                this.m_93666_((Component)Component.m_237113_((String)String.format("%d", intVal)));
                this.parent.onConfigChanging(this.configOption, intVal);
            }
        }
    }

    protected void m_7906_(PoseStack stack, Minecraft mc, int mouseX, int mouseY) {
        if (this.f_93624_) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.f_93620_ + 4)) / (float)(this.f_93618_ - 8);
                this.sliderValue = Mth.m_14008_((double)this.sliderValue, (double)0.0, (double)1.0);
                this.updateValue(this.sliderValue);
                if (this.parent.wasMouseReleased()) {
                    this.dragging = false;
                }
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(stack, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)), this.f_93621_, 0, 66, 4, 20);
            this.m_93228_(stack, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)) + 4, this.f_93621_, 196, 66, 4, 20);
        }
    }

    public final void m_5716_(double mouseX, double mouseY) {
        this.sliderValue = (mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8);
        this.sliderValue = Mth.m_14008_((double)this.sliderValue, (double)0.0, (double)1.0);
        this.updateValue(this.sliderValue);
        this.dragging = true;
        this.parent.setMouseReleased(false);
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public void m_7207_(boolean b) {
        this.sliderValue = (this.defaultValue - this.min) / (this.max - this.min);
        this.updateValue(this.sliderValue);
        super.m_7207_(b);
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    private static enum Type {
        INT,
        FLOAT,
        DOUBLE;

    }
}

