/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools.DurabilityViewer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.ConfigChangedEvent;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiElements.ColorPicker;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiElements.ColorSelector;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.GuiElements.GuiSlider;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.ModConfigurationHandler;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Types.ConfigurationMinecraftColor;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Types.ConfigurationTrueColor;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Types.SliderValueConsumer;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiModOptions
extends Screen
implements Supplier<Screen>,
SliderValueConsumer {
    private final Screen parent;
    private final String modName;
    private final ModConfigurationHandler handler;
    private final List<String> options;
    private final Logger LOGGER;
    private String screenTitle;
    private static final int LINEHEIGHT = 25;
    private static final int BUTTONHEIGHT = 20;
    private static final int TOP_BAR_SIZE = 40;
    private static final int BOTTOM_BAR_SIZE = 35;
    private boolean isDraggingScrollbar = false;
    private boolean mouseReleased = false;
    private int buttonWidth;
    private int scrollAmount;
    private int maxScroll;
    private static final MutableComponent trueText = Component.m_237115_((String)"de.guntram.mcmod.fabrictools.true").m_130940_(ChatFormatting.GREEN);
    private static final MutableComponent falseText = Component.m_237115_((String)"de.guntram.mcmod.fabrictools.false").m_130940_(ChatFormatting.RED);
    private ColorSelector colorSelector;
    private ColorPicker colorPicker;

    public GuiModOptions(Screen parent, String modName, ModConfigurationHandler confHandler) {
        super((Component)Component.m_237113_((String)modName));
        this.parent = parent;
        this.modName = modName;
        this.handler = confHandler;
        this.screenTitle = modName + " Configuration";
        this.options = this.handler.getIConfig().getKeys();
        this.LOGGER = LogManager.getLogger();
        this.colorSelector = new ColorSelector(this, Component.m_237113_((String)"Minecraft Color"));
        this.colorPicker = new ColorPicker(this, 0xFFFFFF, (Component)Component.m_237113_((String)"RGB Color"));
    }

    protected void m_7856_() {
        this.buttonWidth = this.f_96543_ / 2 - 50;
        if (this.buttonWidth > 200) {
            this.buttonWidth = 200;
        }
        this.m_142416_((GuiEventListener)new AbstractWidget(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20, (Component)Component.m_237115_((String)"gui.done")){

            public void m_5716_(double x, double y) {
                if (GuiModOptions.this.colorSelector.f_93624_) {
                    GuiModOptions.this.subscreenFinished();
                    return;
                }
                if (GuiModOptions.this.colorPicker.f_93624_) {
                    GuiModOptions.this.colorPicker.onDoneButton();
                    return;
                }
                for (GuiEventListener button : GuiModOptions.this.m_6702_()) {
                    if (!(button instanceof EditBox) || !((EditBox)button).m_93696_()) continue;
                    button.m_5755_(false);
                }
                GuiModOptions.this.handler.onConfigChanged(new ConfigChangedEvent.OnConfigChangedEvent(GuiModOptions.this.modName));
                GuiModOptions.this.f_96541_.m_91152_(GuiModOptions.this.parent);
            }

            public void m_142291_(NarrationElementOutput p_169152_) {
            }
        });
        int y = 25;
        for (final String option : this.options) {
            AbstractWidget element;
            y += 25;
            Object value = this.handler.getIConfig().getValue(option);
            if (value == null) {
                LogManager.getLogger().warn("value null, adding nothing");
                continue;
            }
            if (this.handler.getIConfig().isSelectList(option)) {
                final String[] options = this.handler.getIConfig().getListOptions(option);
                element = (AbstractWidget)this.m_142416_((GuiEventListener)new AbstractWidget(this.f_96543_ / 2 + 10, y, this.buttonWidth, 20, (Component)Component.m_237115_((String)options[(Integer)value])){

                    public void m_5716_(double x, double y) {
                        int cur = (Integer)GuiModOptions.this.handler.getIConfig().getValue(option);
                        if (++cur == options.length) {
                            cur = 0;
                        }
                        GuiModOptions.this.onConfigChanging(option, cur);
                        this.m_5755_(true);
                    }

                    public void m_7207_(boolean b) {
                        int cur = (Integer)GuiModOptions.this.handler.getIConfig().getValue(option);
                        this.m_93666_((Component)Component.m_237115_((String)options[cur]));
                        super.m_7207_(b);
                    }

                    public void m_142291_(NarrationElementOutput p_169152_) {
                    }
                });
            } else if (value instanceof Boolean) {
                element = (AbstractWidget)this.m_142416_((GuiEventListener)new AbstractWidget(this.f_96543_ / 2 + 10, y, this.buttonWidth, 20, (Component)((Boolean)value == true ? trueText : falseText)){

                    public void m_5716_(double x, double y) {
                        if (((Boolean)GuiModOptions.this.handler.getIConfig().getValue(option)).booleanValue()) {
                            GuiModOptions.this.onConfigChanging(option, false);
                        } else {
                            GuiModOptions.this.onConfigChanging(option, true);
                        }
                        this.m_5755_(true);
                    }

                    public void m_7207_(boolean b) {
                        this.m_93666_((Component)((Boolean)GuiModOptions.this.handler.getIConfig().getValue(option) == true ? trueText : falseText));
                        super.m_7207_(b);
                    }

                    public void m_142291_(NarrationElementOutput p_169152_) {
                    }
                });
            } else if (value instanceof String) {
                element = (AbstractWidget)this.m_142416_((GuiEventListener)new EditBox(this.getFontRenderer(), this.f_96543_ / 2 + 10, y, this.buttonWidth, 20, (Component)Component.m_237113_((String)((String)value))){

                    public void m_7207_(boolean b) {
                        if (b) {
                            GuiModOptions.this.LOGGER.debug("value to textfield");
                            this.m_94144_((String)GuiModOptions.this.handler.getIConfig().getValue(option));
                        } else {
                            GuiModOptions.this.LOGGER.debug("textfield to value");
                            GuiModOptions.this.handler.getIConfig().setValue(option, this.m_94155_());
                        }
                        super.m_7207_(b);
                    }

                    public boolean m_5534_(char chr, int keyCode) {
                        boolean result = super.m_5534_(chr, keyCode);
                        GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, option, this.m_94155_()));
                        return result;
                    }

                    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                        boolean result = super.m_7933_(keyCode, scanCode, modifiers);
                        GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, option, this.m_94155_()));
                        return result;
                    }

                    public void m_142291_(NarrationElementOutput p_169152_) {
                    }
                });
                ((EditBox)element).m_94199_(120);
                element.m_5755_(false);
            } else if (value instanceof ConfigurationMinecraftColor || value instanceof Integer && (Integer)this.handler.getIConfig().getMin(option) == 0 && (Integer)this.handler.getIConfig().getMax(option) == 15) {
                if (value instanceof Integer) {
                    this.handler.getIConfig().setValue(option, new ConfigurationMinecraftColor((Integer)value));
                }
                element = (AbstractWidget)this.m_142416_((GuiEventListener)new AbstractWidget(this.f_96543_ / 2 + 10, y, this.buttonWidth, 20, (Component)Component.m_237119_()){

                    public void m_5716_(double x, double y) {
                        GuiModOptions.this.enableColorSelector(option, this);
                    }

                    public void m_93666_(Component ignored) {
                        Object o = GuiModOptions.this.handler.getIConfig().getValue(option);
                        int newIndex = ((ConfigurationMinecraftColor)o).colorIndex;
                        super.m_93666_((Component)Component.m_237115_((String)"de.guntram.mcmod.fabrictools.color").m_130940_(ChatFormatting.m_126647_((int)newIndex)));
                    }

                    public boolean m_5755_(boolean ignored) {
                        this.m_93666_(null);
                        return ignored;
                    }

                    public void m_142291_(NarrationElementOutput p_169152_) {
                    }
                });
                element.m_93666_((Component)Component.m_237119_());
            } else if (value instanceof ConfigurationTrueColor || value instanceof Integer && (Integer)this.handler.getIConfig().getMin(option) == 0 && (Integer)this.handler.getIConfig().getMax(option) == 0xFFFFFF) {
                if (value instanceof Integer) {
                    this.handler.getIConfig().setValue(option, new ConfigurationTrueColor((Integer)value));
                }
                element = (AbstractWidget)this.m_142416_((GuiEventListener)new AbstractWidget(this.f_96543_ / 2 + 10, y, this.buttonWidth, 20, (Component)Component.m_237119_()){

                    public void m_5716_(double x, double y) {
                        GuiModOptions.this.enableColorPicker(option, this);
                    }

                    public void m_93666_(Component ignored) {
                        Object o = GuiModOptions.this.handler.getIConfig().getValue(option);
                        int rgb = ((ConfigurationTrueColor)o).getInt();
                        super.m_93666_((Component)Component.m_237115_((String)"de.guntram.mcmod.fabrictools.color").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb))));
                    }

                    public boolean m_5755_(boolean ignored) {
                        this.m_93666_(null);
                        return ignored;
                    }

                    public void m_142291_(NarrationElementOutput p_169152_) {
                    }
                });
                element.m_93666_((Component)Component.m_237119_());
            } else if (value instanceof Integer || value instanceof Float || value instanceof Double) {
                element = (AbstractWidget)this.m_142416_((GuiEventListener)new GuiSlider(this, this.f_96543_ / 2 + 10, y, this.buttonWidth, 20, this.handler.getIConfig(), option));
            } else {
                LogManager.getLogger().warn(this.modName + " has option " + option + " with data type " + value.getClass().getName());
                continue;
            }
            this.m_142416_((GuiEventListener)new AbstractWidget(this.f_96543_ / 2 + 10 + this.buttonWidth + 10, y, 20, 20, (Component)Component.m_237119_()){

                public void m_5716_(double x, double y) {
                    Object value = GuiModOptions.this.handler.getIConfig().getValue(option);
                    Object defValue = GuiModOptions.this.handler.getIConfig().getDefault(option);
                    if (value instanceof ConfigurationMinecraftColor) {
                        defValue = new ConfigurationMinecraftColor((Integer)defValue);
                    } else if (value instanceof ConfigurationTrueColor) {
                        defValue = new ConfigurationTrueColor((Integer)defValue);
                    }
                    GuiModOptions.this.onConfigChanging(option, defValue);
                    element.m_5755_(false);
                }

                public void m_142291_(NarrationElementOutput p_169152_) {
                }
            });
        }
        this.maxScroll = this.options.size() * 25 - (this.f_96544_ - 40 - 35) + 25;
        if (this.maxScroll < 0) {
            this.maxScroll = 0;
        }
        this.colorSelector.init();
        this.colorPicker.init();
        this.m_142416_((GuiEventListener)this.colorSelector);
        this.m_142416_((GuiEventListener)this.colorPicker);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.scrollAmount -= (int)(amount * 20.0 / 2.0);
        if (this.scrollAmount < 0) {
            this.scrollAmount = 0;
        }
        if (this.scrollAmount > this.maxScroll) {
            this.scrollAmount = this.maxScroll;
        }
        return true;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        if (this.colorSelector.f_93624_) {
            this.colorSelector.m_6305_(stack, mouseX, mouseY, partialTicks);
        } else if (this.colorPicker.f_93624_) {
            this.colorPicker.m_6305_(stack, mouseX, mouseY, partialTicks);
        } else {
            int y = 52 - this.scrollAmount;
            for (int i = 0; i < this.options.size(); ++i) {
                if (y > 28 && y < this.f_96544_ - 35) {
                    this.f_96547_.m_92883_(stack, Component.m_237115_((String)this.options.get(i)).getString(), (float)(this.f_96543_ / 2 - 155), (float)(y + 4), 0xFFFFFF);
                    ((AbstractWidget)this.m_6702_().get((int)(i * 2 + 1))).f_93621_ = y;
                    ((AbstractWidget)this.m_6702_().get(i * 2 + 1)).m_6305_(stack, mouseX, mouseY, partialTicks);
                    ((AbstractWidget)this.m_6702_().get((int)(i * 2 + 2))).f_93621_ = y;
                    ((AbstractWidget)this.m_6702_().get(i * 2 + 2)).m_6305_(stack, mouseX, mouseY, partialTicks);
                }
                y += 25;
            }
            y = 52 - this.scrollAmount;
            for (String text : this.options) {
                if (y > 28 && y < this.f_96544_ - 35 && mouseX > this.f_96543_ / 2 - 155 && mouseX < this.f_96543_ / 2 && mouseY > y && mouseY < y + 20) {
                    String ttText = this.handler.getIConfig().getTooltip(text);
                    if (ttText == null || ttText.isEmpty()) {
                        y += 25;
                        continue;
                    }
                    MutableComponent tooltip = Component.m_237115_((String)this.handler.getIConfig().getTooltip(text));
                    int width = this.f_96547_.m_92852_((FormattedText)tooltip);
                    if (width != 0) {
                        if (width <= 250) {
                            this.m_96602_(stack, (Component)tooltip, 0, mouseY);
                        } else {
                            List lines = this.f_96547_.m_92923_((FormattedText)tooltip, 250);
                            this.m_96617_(stack, lines, 0, mouseY);
                        }
                    }
                }
                y += 25;
            }
            if (this.maxScroll > 0) {
                int pos = (int)((float)(this.f_96544_ - 40 - 35 - 20) * ((float)this.scrollAmount / (float)this.maxScroll));
                RenderSystem.m_157456_((int)0, (ResourceLocation)AbstractWidget.f_93617_);
                this.m_93228_(stack, this.f_96543_ - 5, pos + 40, 0, 66, 4, 20);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_69465_();
        this.m_93228_(stack, 0, 0, 0, 0, this.f_96543_, 40);
        this.m_93228_(stack, 0, this.f_96544_ - 35, 0, 0, this.f_96543_, 35);
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        GuiModOptions.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.screenTitle, (int)n, (int)((40 - 9) / 2), (int)0xFFFFFF);
        ((AbstractWidget)this.m_6702_().get(0)).m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    @Override
    public Screen get() {
        return this;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        if (button == 0) {
            this.mouseReleased = true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.maxScroll > 0 && mouseX > (double)(this.f_96543_ - 5)) {
            this.isDraggingScrollbar = true;
            this.scrollAmount = (int)((mouseY - 40.0) / (double)(this.f_96544_ - 35 - 40) * (double)this.maxScroll);
            this.scrollAmount = Mth.m_14045_((int)this.scrollAmount, (int)0, (int)this.maxScroll);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            this.scrollAmount = (int)((mouseY - 40.0) / (double)(this.f_96544_ - 35 - 40) * (double)this.maxScroll);
            this.scrollAmount = Mth.m_14045_((int)this.scrollAmount, (int)0, (int)this.maxScroll);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void enableColorSelector(String option, AbstractWidget element) {
        for (int i = 1; i < this.m_6702_().size(); ++i) {
            ((AbstractWidget)this.m_6702_().get((int)i)).f_93624_ = false;
        }
        this.colorSelector.setCurrentColor((ConfigurationMinecraftColor)this.handler.getIConfig().getValue(option));
        this.colorSelector.f_93624_ = true;
        this.colorSelector.setLink(option, element);
    }

    private void enableColorPicker(String option, AbstractWidget element) {
        for (int i = 1; i < this.m_6702_().size(); ++i) {
            ((AbstractWidget)this.m_6702_().get((int)i)).f_93624_ = false;
        }
        this.colorPicker.setCurrentColor((ConfigurationTrueColor)this.handler.getIConfig().getValue(option));
        this.colorPicker.f_93624_ = true;
        this.colorPicker.setLink(option, element);
    }

    public void subscreenFinished() {
        for (int i = 1; i < this.m_6702_().size(); ++i) {
            ((AbstractWidget)this.m_6702_().get((int)i)).f_93624_ = true;
        }
        this.colorSelector.f_93624_ = false;
        this.colorPicker.f_93624_ = false;
    }

    @Override
    public boolean wasMouseReleased() {
        boolean result = this.mouseReleased;
        this.mouseReleased = false;
        return result;
    }

    @Override
    public void setMouseReleased(boolean value) {
        this.mouseReleased = value;
    }

    @Override
    public void onConfigChanging(String option, Object value) {
        this.handler.getIConfig().setValue(option, value);
        if (value instanceof ConfigurationMinecraftColor) {
            value = ((ConfigurationMinecraftColor)value).colorIndex;
        } else if (value instanceof ConfigurationTrueColor) {
            value = ((ConfigurationTrueColor)value).getInt();
        }
        this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(this.modName, option, value));
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }
}

