/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.handler;

import de.guntram.mcmod.GBForgetools.DurabilityViewer.ConfigChangedEvent;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.Configuration;
import de.guntram.mcmod.GBForgetools.DurabilityViewer.ModConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.client.gui.Corner;
import java.io.File;
import net.minecraft.ChatFormatting;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static final String[] warnModes = new String[]{"durabilityviewer.config.warnmode.none", "durabilityviewer.config.warnmode.sound", "durabilityviewer.config.warnmode.visual", "durabilityviewer.config.warnmode.both"};
    private static ConfigurationHandler instance;
    private Configuration config;
    private ChatFormatting tooltipColor;
    private String configFileName;
    private int corner = 0;
    private int color = 5;
    private boolean effectDuration;
    private int minPercent = 10;
    private int minDurability = 100;
    private boolean showPlayerServerName;
    private int showDamageOverPercent;
    private boolean armorAroundHotbar;
    private boolean showChestIcon;
    private boolean showPercentValues;
    private int warnMode;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    @Override
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("durabilityviewer")) {
            this.loadConfig();
        }
    }

    @Override
    public void onConfigChanging(ConfigChangedEvent.OnConfigChangingEvent event) {
        if (event.getModID().equals("durabilityviewer")) {
            switch (event.getItem()) {
                case "durabilityviewer.config.corner": {
                    this.corner = (Integer)event.getNewValue();
                    break;
                }
                case "durabilityviewer.config.armorhotbar": {
                    this.armorAroundHotbar = (Boolean)event.getNewValue();
                    break;
                }
                case "durabilityviewer.config.showfreeslots": {
                    this.showChestIcon = (Boolean)event.getNewValue();
                }
            }
        }
    }

    private void loadConfig() {
        this.config.migrate("HUD Corner", "durabilityviewer.config.corner");
        this.config.migrate("Effect Duration", "durabilityviewer.config.effectduration");
        this.config.migrate("Percent to show damage", "durabilityviewer.config.showdamagepercent");
        this.config.migrate("Tooltip Color", "durabilityviewer.config.tooltipcolor");
        this.config.migrate("Minimum Percent", "durabilityviewer.config.minpercent");
        this.config.migrate("Minimum Durability", "durabilityviewer.config.mindurability");
        this.config.migrate("Set window title", "durabilityviewer.config.setwindowtitle");
        this.config.migrate("Show all trinkets", "durabilityviewer.config.showalltrinkets");
        this.config.migrate("Armor around hotbar", "durabilityviewer.config.armorhotbar");
        this.config.migrate("Show chest icon", "durabilityviewer.config.showfreeslots");
        this.corner = this.config.getSelection("durabilityviewer.config.corner", 0, this.corner, new String[]{"durabilityviewer.config.bottom_right", "durabilityviewer.config.bottom_left", "durabilityviewer.config.top_right", "durabilityviewer.config.top_left"}, "durabilityviewer.config.tt.corner");
        this.armorAroundHotbar = this.config.getBoolean("durabilityviewer.config.armorhotbar", 0, this.armorAroundHotbar, "durabilityviewer.config.tt.armorhotbar");
        this.color = this.config.getInt("durabilityviewer.config.tooltipcolor", 0, this.color, 0, 15, "durabilityviewer.config.tt.tooltipcolor");
        this.effectDuration = this.config.getBoolean("durabilityviewer.config.effectduration", 0, true, "durabilityviewer.config.tt.effectduration");
        this.minPercent = this.config.getInt("durabilityviewer.config.minpercent", 0, this.minPercent, 1, 100, "durabilityviewer.config.tt.minpercent");
        this.minDurability = this.config.getInt("durabilityviewer.config.mindurability", 0, this.minDurability, 1, 1500, "durabilityviewer.config.tt.mindurability");
        this.showPlayerServerName = this.config.getBoolean("durabilityviewer.config.setwindowtitle", 0, true, "durabilityviewer.config.tt.setwindowtitle");
        this.showDamageOverPercent = this.config.getInt("durabilityviewer.config.showdamagepercent", 0, 80, 0, 100, "durabilityviewer.config.tt.showdamagepercent");
        this.showChestIcon = this.config.getBoolean("durabilityviewer.config.showfreeslots", 0, true, "durabilityviewer.config.tt.showfreeslots");
        this.showPercentValues = this.config.getBoolean("durabilityviewer.config.percentvalues", 0, false, "durabilityviewer.config.tt.percentvalues");
        this.warnMode = this.config.getSelection("durabilityviewer.config.warnmode", 0, 1, warnModes, "durabilityviewer.config.tt.warnmode");
        this.tooltipColor = ChatFormatting.m_126647_((int)this.color);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public static ChatFormatting getTooltipColor() {
        return ConfigurationHandler.getInstance().tooltipColor;
    }

    public static Corner getCorner() {
        return Corner.values()[ConfigurationHandler.getInstance().corner];
    }

    @Override
    public Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static boolean showEffectDuration() {
        return ConfigurationHandler.getInstance().effectDuration;
    }

    public static int getMinPercent() {
        return ConfigurationHandler.getInstance().minPercent;
    }

    public static int getMinDurability() {
        return ConfigurationHandler.getInstance().minDurability;
    }

    public static boolean showPlayerServerName() {
        return ConfigurationHandler.getInstance().showPlayerServerName;
    }

    public static int showDamageOverPercent() {
        return ConfigurationHandler.getInstance().showDamageOverPercent;
    }

    public static boolean getArmorAroundHotbar() {
        return ConfigurationHandler.getInstance().armorAroundHotbar;
    }

    public static boolean getShowChestIcon() {
        return ConfigurationHandler.getInstance().showChestIcon;
    }

    public static boolean getShowPercentValues() {
        return ConfigurationHandler.getInstance().showPercentValues;
    }

    public static int getWarnMode() {
        return ConfigurationHandler.getInstance().warnMode;
    }
}

