/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.tools;

import io.github.kosmx.emotes.api.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class MathHelper {
    public static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static int colorHelper(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static float clampToRadian(float f) {
        double a = Math.PI * 2;
        double b = ((double)f + Math.PI) % (Math.PI * 2);
        if (b < 0.0) {
            b += Math.PI * 2;
        }
        return (float)(b - Math.PI);
    }

    public static ByteBuffer readFromIStream(InputStream stream) throws IOException {
        int estimatedSize;
        byte[] bytes;
        int n;
        LinkedList<Pair<Integer, byte[]>> listOfBites = new LinkedList<Pair<Integer, byte[]>>();
        int totalSize = 0;
        while ((n = stream.read(bytes = new byte[Math.max(1, estimatedSize = stream.available())])) >= 1) {
            totalSize += n;
            listOfBites.add(new Pair<Integer, byte[]>(n, bytes));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(totalSize);
        for (Pair pair : listOfBites) {
            byteBuffer.put((byte[])pair.getRight(), 0, (Integer)pair.getLeft());
        }
        ((Buffer)byteBuffer).position(0);
        return byteBuffer;
    }
}

