/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric;

import io.github.kosmx.bendylib.IModelPart;
import io.github.kosmx.bendylib.MutableModelPart;
import io.github.kosmx.bendylib.impl.BendableCuboid;
import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.common.tools.SetableSupplier;
import io.github.kosmx.emotes.executor.emotePlayer.IUpperPartHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_4587;
import net.minecraft.class_630;

public class BendableModelPart
extends MutableModelPart {
    @Nullable
    protected SetableSupplier<EmotePlayImpl> emote;
    protected float axis = 0.0f;
    protected float angl = 0.0f;
    protected boolean isUpperPart = false;

    public BendableModelPart(class_630 modelPart, boolean isUpperPart, @Nullable SetableSupplier<EmotePlayImpl> emote) {
        super(modelPart);
        this.emote = emote;
        this.isUpperPart = isUpperPart;
        ((IModelPart)modelPart).mutate((MutableModelPart)this);
        ((IUpperPartHelper)modelPart).setUpperPart(isUpperPart);
    }

    public BendableModelPart(class_630 modelPart, @Nullable SetableSupplier<EmotePlayImpl> emote) {
        this(modelPart, false, emote);
    }

    public BendableModelPart(class_630 modelPart) {
        this(modelPart, null);
    }

    public BendableModelPart(class_630 modelPart, boolean isUpperPart) {
        this(modelPart, isUpperPart, null);
    }

    public String modId() {
        return "Emotecraft";
    }

    public int getPriority() {
        return 4;
    }

    public class_1159 getMatrix4f() {
        return ((BendableCuboid)this.iCuboids.get(0)).getLastPosMatrix();
    }

    public BendableCuboid getCuboid() {
        return (BendableCuboid)this.iCuboids.get(0);
    }

    public boolean isActive() {
        return this.emote != null && EmotePlayImpl.isRunningEmote(this.emote.get()) && this.angl != 0.0f;
    }

    public void setEmote(@Nullable SetableSupplier<EmotePlayImpl> emote) {
        this.emote = emote;
    }

    @Nullable
    public SetableSupplier<EmotePlayImpl> getEmote() {
        return this.emote;
    }

    public void bend(float a, float b) {
        this.axis = a;
        this.angl = b;
        ((BendableCuboid)this.iCuboids.get(0)).applyBend(a, b);
    }

    public void bend(Pair<Float, Float> pair) {
        this.bend(pair.getLeft().floatValue(), pair.getRight().floatValue());
    }

    public void copyBend(@Nonnull BendableModelPart mutableModelPart) {
        this.bend(mutableModelPart.axis, mutableModelPart.angl);
    }

    public boolean isUpperPart() {
        return this.isUpperPart;
    }

    public static void roteteMatrixStack(class_4587 matrices, Pair<Float, Float> pair) {
        float offset = 0.375f;
        matrices.method_22904(0.0, (double)offset, 0.0);
        float bend = pair.getRight().floatValue();
        float axisf = -pair.getLeft().floatValue();
        class_1160 axis = new class_1160((float)Math.cos(axisf), 0.0f, (float)Math.sin(axisf));
        matrices.method_22907(axis.method_23626(bend));
        matrices.method_22904(0.0, (double)(-offset), 0.0);
    }
}

