/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylibForge.impl;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.kosmx.bendylibForge.impl.IBendable;
import io.github.kosmx.bendylibForge.impl.ICuboid;
import io.github.kosmx.bendylibForge.impl.IPosWithOrigin;
import io.github.kosmx.bendylibForge.impl.IVertex;
import io.github.kosmx.bendylibForge.impl.IterableRePos;
import io.github.kosmx.bendylibForge.impl.RememberingPos;
import io.github.kosmx.bendylibForge.impl.RepositionableVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public class BendableCuboid
implements ICuboid,
IBendable,
IterableRePos {
    protected final Quad[] sides;
    protected final RememberingPos[] positions;
    protected Matrix4f lastPosMatrix;
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;
    protected Vector3f moveVec;
    protected final float fixX;
    protected final float fixY;
    protected final float fixZ;
    protected final Direction direction;
    protected final IBendable.Plane basePlane;
    protected final IBendable.Plane otherPlane;
    protected final float fullSize;

    protected BendableCuboid(Quad[] sides, RememberingPos[] positions, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float fixX, float fixY, float fixZ, Direction direction, IBendable.Plane basePlane, IBendable.Plane otherPlane, float fullSize) {
        this.sides = sides;
        this.positions = positions;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.fixX = fixX;
        this.fixY = fixY;
        this.fixZ = fixZ;
        this.direction = direction;
        this.basePlane = basePlane;
        this.otherPlane = otherPlane;
        this.fullSize = fullSize;
        this.applyBend(0.0f, 0.0f);
    }

    @Deprecated
    public static BendableCuboid newBendableCuboid(int textureOffsetU, int textureOffsetV, int x, int y, int z, int sizeX, int sizeY, int sizeZ, boolean mirror, int textureWidth, int textureHeight, Direction direction, float extraX, float extraY, float extraZ) {
        Builder builder = new Builder();
        builder.v = textureOffsetV;
        builder.u = textureOffsetU;
        builder.x = x;
        builder.y = y;
        builder.z = z;
        builder.sizeX = sizeX;
        builder.sizeY = sizeY;
        builder.sizeZ = sizeZ;
        builder.mirror = mirror;
        builder.textureWidth = textureWidth;
        builder.textureHeight = textureHeight;
        builder.direction = direction;
        builder.extraX = extraX;
        builder.extraY = extraY;
        builder.extraZ = extraZ;
        return builder.build();
    }

    public Matrix4f applyBend(float bendAxis, float bendValue) {
        return this.applyBend(bendAxis, bendValue, this);
    }

    @Override
    public Direction getBendDirection() {
        return this.direction;
    }

    @Override
    public float getBendX() {
        return this.fixX;
    }

    @Override
    public float getBendY() {
        return this.fixY;
    }

    @Override
    public float getBendZ() {
        return this.fixZ;
    }

    @Override
    public IBendable.Plane getBasePlane() {
        return this.basePlane;
    }

    @Override
    public IBendable.Plane getOtherSidePlane() {
        return this.otherPlane;
    }

    @Override
    public float bendHeight() {
        return this.fullSize;
    }

    @Override
    public void iteratePositions(Consumer<IPosWithOrigin> consumer) {
        for (RememberingPos pos : this.positions) {
            consumer.accept(pos);
        }
    }

    @Deprecated
    public Matrix4f setRotationRad(float axisf, float value) {
        return this.applyBend(axisf, value);
    }

    public Matrix4f setRotationDeg(float axis, float val) {
        return this.setRotationRad(axis * 0.0174533f, val * 0.0174533f);
    }

    @Override
    public void render(MatrixStack.Entry matrices, IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha, int light, int overlay) {
        for (Quad quad : this.sides) {
            quad.render(matrices, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    public Matrix4f getLastPosMatrix() {
        return this.lastPosMatrix.func_226601_d_();
    }

    public static class Quad {
        public final IVertex[] vertices;

        public Quad(RememberingPos[] vertices, float u1, float v1, float u2, float v2, float squishU, float squishV, boolean flip) {
            float f = 0.0f / squishU;
            float g = 0.0f / squishV;
            this.vertices = new IVertex[4];
            this.vertices[0] = new RepositionableVertex(u2 / squishU - f, v1 / squishV + g, vertices[0]);
            this.vertices[1] = new RepositionableVertex(u1 / squishU + f, v1 / squishV + g, vertices[1]);
            this.vertices[2] = new RepositionableVertex(u1 / squishU + f, v2 / squishV - g, vertices[2]);
            this.vertices[3] = new RepositionableVertex(u2 / squishU - f, v2 / squishV - g, vertices[3]);
            if (flip) {
                int i = vertices.length;
                for (int j = 0; j < i / 2; ++j) {
                    IVertex vertex = this.vertices[j];
                    this.vertices[j] = this.vertices[i - 1 - j];
                    this.vertices[i - 1 - j] = vertex;
                }
            }
        }

        public void render(MatrixStack.Entry matrices, IVertexBuilder vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
            Vector3f direction = this.getDirection();
            direction.func_229188_a_(matrices.func_227872_b_());
            for (int i = 0; i != 4; ++i) {
                IVertex vertex = this.vertices[i];
                Vector3f vertexPos = vertex.getPos();
                Vector4f pos = new Vector4f(vertexPos.func_195899_a() / 16.0f, vertexPos.func_195900_b() / 16.0f, vertexPos.func_195902_c() / 16.0f, 1.0f);
                pos.func_229372_a_(matrices.func_227870_a_());
                vertexConsumer.func_225588_a_(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), red, green, blue, alpha, vertex.getU(), vertex.getV(), overlay, light, direction.func_195899_a(), direction.func_195900_b(), direction.func_195902_c());
            }
        }

        private Vector3f getDirection() {
            Vector3f buf = this.vertices[3].getPos().func_229195_e_();
            buf.func_195898_a(-1.0f);
            Vector3f vecB = this.vertices[1].getPos().func_229195_e_();
            vecB.func_229189_a_(buf);
            buf = this.vertices[2].getPos().func_229195_e_();
            buf.func_195898_a(-1.0f);
            Vector3f vecA = this.vertices[0].getPos().func_229195_e_();
            vecA.func_229189_a_(buf);
            vecA.func_195896_c(vecB);
            return vecA.func_229194_d_() ? vecA : Direction.NORTH.func_229386_k_();
        }
    }

    public static class Builder {
        public int x;
        public int y;
        public int z;
        public int sizeX;
        public int sizeY;
        public int sizeZ;
        public float extraX;
        public float extraY;
        public float extraZ;
        public int u;
        public int v;
        public boolean mirror = false;
        public int textureWidth;
        public int textureHeight;
        public Direction direction;

        public BendableCuboid build() {
            ArrayList<Quad> planes = new ArrayList<Quad>();
            HashMap<Vector3f, RememberingPos> positions = new HashMap<Vector3f, RememberingPos>();
            float minX = this.x;
            float minY = this.y;
            float minZ = this.z;
            float maxX = this.x + this.sizeX;
            float maxY = this.y + this.sizeY;
            float maxZ = this.z + this.sizeZ;
            float pminX = (float)this.x - this.extraX;
            float pminY = (float)this.y - this.extraY;
            float pminZ = (float)this.z - this.extraZ;
            float pmaxX = maxX + this.extraX;
            float pmaxY = maxY + this.extraY;
            float pmaxZ = maxZ + this.extraZ;
            if (this.mirror) {
                float tmp = pminX;
                pminX = pmaxX;
                pmaxX = tmp;
            }
            Vector3f vertex1 = new Vector3f(pminX, pminY, pminZ);
            Vector3f vertex2 = new Vector3f(pmaxX, pminY, pminZ);
            Vector3f vertex3 = new Vector3f(pmaxX, pmaxY, pminZ);
            Vector3f vertex4 = new Vector3f(pminX, pmaxY, pminZ);
            Vector3f vertex5 = new Vector3f(pminX, pminY, pmaxZ);
            Vector3f vertex6 = new Vector3f(pmaxX, pminY, pmaxZ);
            Vector3f vertex7 = new Vector3f(pmaxX, pmaxY, pmaxZ);
            Vector3f vertex8 = new Vector3f(pminX, pmaxY, pmaxZ);
            int j = this.u;
            int k = this.u + this.sizeZ;
            int l = this.u + this.sizeZ + this.sizeX;
            int m = this.u + this.sizeZ + this.sizeX + this.sizeX;
            int n = this.u + this.sizeZ + this.sizeX + this.sizeZ;
            int o = this.u + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX;
            int p = this.v;
            int q = this.v + this.sizeZ;
            int r = this.v + this.sizeZ + this.sizeY;
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex6, vertex5, vertex2}, k, p, l, q, this.textureWidth, this.textureHeight, this.mirror);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex3, vertex4, vertex7}, l, q, m, p, this.textureWidth, this.textureHeight, this.mirror);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex1, vertex5, vertex4}, j, q, k, r, this.textureWidth, this.textureHeight, this.mirror);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex2, vertex1, vertex3}, k, q, l, r, this.textureWidth, this.textureHeight, this.mirror);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex6, vertex2, vertex7}, l, q, n, r, this.textureWidth, this.textureHeight, this.mirror);
            this.createAndAddQuads(planes, positions, new Vector3f[]{vertex5, vertex6, vertex8}, n, q, o, r, this.textureWidth, this.textureHeight, this.mirror);
            IBendable.Plane aPlane = new IBendable.Plane(this.direction.func_229386_k_(), vertex7);
            IBendable.Plane bPlane = new IBendable.Plane(this.direction.func_229386_k_(), vertex1);
            boolean bl = this.direction == Direction.UP || this.direction == Direction.SOUTH || this.direction == Direction.EAST;
            float fullSize = -this.direction.func_229386_k_().func_195903_b(vertex1) + this.direction.func_229386_k_().func_195903_b(vertex7);
            float bendX = ((float)this.sizeX + (float)this.x + (float)this.x) / 2.0f;
            float bendY = ((float)this.sizeY + (float)this.y + (float)this.y) / 2.0f;
            float bendZ = ((float)this.sizeZ + (float)this.z + (float)this.z) / 2.0f;
            return new BendableCuboid(planes.toArray(new Quad[0]), positions.values().toArray(new RememberingPos[0]), minX, minY, minZ, maxX, maxY, maxZ, bendX, bendY, bendZ, this.direction, bl ? aPlane : bPlane, bl ? bPlane : aPlane, fullSize);
        }

        private void createAndAddQuads(Collection<Quad> quads, HashMap<Vector3f, RememberingPos> positions, Vector3f[] edges, int u1, int v1, int u2, int v2, float squishU, float squishV, boolean flip) {
            int du = u2 < u1 ? 1 : -1;
            int dv = v1 < v2 ? 1 : -1;
            for (int localU = u2; localU != u1; localU += du) {
                for (int localV = v1; localV != v2; localV += dv) {
                    int localU2 = localU + du;
                    int localV2 = localV + dv;
                    RememberingPos rp0 = this.getOrCreate(positions, this.transformVector(edges[0].func_229195_e_(), edges[1].func_229195_e_(), edges[2].func_229195_e_(), u2, v1, u1, v2, localU2, localV));
                    RememberingPos rp1 = this.getOrCreate(positions, this.transformVector(edges[0].func_229195_e_(), edges[1].func_229195_e_(), edges[2].func_229195_e_(), u2, v1, u1, v2, localU2, localV2));
                    RememberingPos rp2 = this.getOrCreate(positions, this.transformVector(edges[0].func_229195_e_(), edges[1].func_229195_e_(), edges[2].func_229195_e_(), u2, v1, u1, v2, localU, localV2));
                    RememberingPos rp3 = this.getOrCreate(positions, this.transformVector(edges[0].func_229195_e_(), edges[1].func_229195_e_(), edges[2].func_229195_e_(), u2, v1, u1, v2, localU, localV));
                    quads.add(new Quad(new RememberingPos[]{rp3, rp0, rp1, rp2}, localU2, localV, localU, localV2, this.textureWidth, this.textureHeight, this.mirror));
                }
            }
        }

        Vector3f transformVector(Vector3f pos, Vector3f vectorU, Vector3f vectorV, int u1, int v1, int u2, int v2, int u, int v) {
            vectorU.func_195897_a(pos);
            vectorU.func_195898_a(((float)u - (float)u1) / (float)(u2 - u1));
            vectorV.func_195897_a(pos);
            vectorV.func_195898_a(((float)v - (float)v1) / (float)(v2 - v1));
            pos.func_229189_a_(vectorU);
            pos.func_229189_a_(vectorV);
            return pos;
        }

        RememberingPos getOrCreate(HashMap<Vector3f, RememberingPos> positions, Vector3f pos) {
            if (!positions.containsKey(pos)) {
                positions.put(pos, new RememberingPos(pos));
            }
            return positions.get(pos);
        }
    }
}

