/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylibForge.impl;

import io.github.kosmx.bendylibForge.impl.IterableRePos;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public interface IBendable {
    default public Matrix4f applyBend(float bendAxis, float bendValue, IterableRePos posSupplier) {
        Vector3f axis = new Vector3f((float)Math.cos(bendAxis), 0.0f, (float)Math.sin(bendAxis));
        Matrix3f matrix3f = new Matrix3f(this.getBendDirection().func_229384_a_());
        axis.func_229188_a_(matrix3f);
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.func_226591_a_();
        transformMatrix.func_226595_a_(Matrix4f.func_226599_b_((float)this.getBendX(), (float)this.getBendY(), (float)this.getBendZ()));
        transformMatrix.func_226596_a_(axis.func_229193_c_(bendValue));
        transformMatrix.func_226595_a_(Matrix4f.func_226599_b_((float)(-this.getBendX()), (float)(-this.getBendY()), (float)(-this.getBendZ())));
        Plane basePlane = this.getBasePlane();
        Plane otherPlane = this.getOtherSidePlane();
        Vector3f directionUnit = this.getBendDirection().func_229386_k_();
        directionUnit.func_195896_c(axis);
        Plane bendPlane = new Plane(directionUnit, new Vector3f(this.getBendX(), this.getBendY(), this.getBendZ()));
        float halfSize = this.bendHeight() / 2.0f;
        boolean bl = this.getBendDirection() == Direction.UP || this.getBendDirection() == Direction.SOUTH || this.getBendDirection() == Direction.EAST;
        posSupplier.iteratePositions(iPosWithOrigin -> {
            Vector3f newPos = iPosWithOrigin.getOriginalPos();
            float distFromBend = bl ? -bendPlane.distanceTo(newPos) : bendPlane.distanceTo(newPos);
            float distFromBase = basePlane.distanceTo(newPos);
            float distFromOther = otherPlane.distanceTo(newPos);
            double s = Math.tan(bendValue / 2.0f) * (double)distFromBend;
            Vector3f x = this.getBendDirection().func_229386_k_();
            if (Math.abs(distFromBase) < Math.abs(distFromOther)) {
                x.func_195898_a((float)((double)(-distFromBase / halfSize) * s));
                newPos.func_229189_a_(x);
                Vector4f reposVector = new Vector4f(newPos);
                reposVector.func_229372_a_(transformMatrix);
                newPos = new Vector3f(reposVector.func_195910_a(), reposVector.func_195913_b(), reposVector.func_195914_c());
            } else {
                x.func_195898_a((float)((double)(-distFromOther / halfSize) * s));
                newPos.func_229189_a_(x);
            }
            iPosWithOrigin.setPos(newPos);
        });
        return transformMatrix;
    }

    public Direction getBendDirection();

    public float getBendX();

    public float getBendY();

    public float getBendZ();

    public Plane getBasePlane();

    public Plane getOtherSidePlane();

    default public float bendHeight() {
        return this.getBasePlane().distanceTo(this.getOtherSidePlane());
    }

    public static class Plane {
        final Vector3f normal;
        final float normDistance;

        public Plane(Vector3f normal, Vector3f position) {
            this.normal = normal.func_229195_e_();
            this.normal.func_229194_d_();
            this.normDistance = -normal.func_195903_b(position);
        }

        public float distanceTo(Vector3f pos) {
            return this.normal.func_195903_b(pos) + this.normDistance;
        }

        public float distanceTo(Plane otherPlane) {
            Vector3f tmp = this.normal.func_229195_e_();
            tmp.func_195896_c(otherPlane.normal);
            if ((double)tmp.func_195903_b(tmp) < 0.01) {
                return this.normDistance + this.normal.func_195903_b(otherPlane.normal) * otherPlane.normDistance;
            }
            return 0.0f;
        }
    }
}

