/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.kosmx.emotes.arch.gui.screen.IDrawableImpl;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.screen.widget.IEmoteListWidgetHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;

public abstract class AbstractEmoteListWidget<E extends AbstractEmoteEntry<E>>
extends ExtendedList<E>
implements IEmoteListWidgetHelper<MatrixStack, IGuiEventListener>,
IDrawableImpl {
    protected List<E> emotes = new ArrayList();
    private final Screen screen;

    @Override
    public IEmoteListWidgetHelper.IEmoteEntry getSelectedEntry() {
        return (IEmoteListWidgetHelper.IEmoteEntry)this.func_230958_g_();
    }

    public AbstractEmoteListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m, Screen screen) {
        super(minecraftClient, i, j, k, l, m);
        this.field_230676_m_ = false;
        this.screen = screen;
    }

    public int func_230949_c_() {
        return this.field_230670_d_ - 5;
    }

    protected abstract E newEmoteEntry(Minecraft var1, EmoteHolder var2);

    @Override
    public void emotesSetLeftPos(int left) {
        this.func_230959_g_(left);
    }

    @Override
    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        this.emotes = new ArrayList();
        for (EmoteHolder emoteHolder : list) {
            this.emotes.add(this.newEmoteEntry(Minecraft.func_71410_x(), emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.emotes.add(this.newEmoteEntry(Minecraft.func_71410_x(), emoteHolder));
            }
        }
        this.emotes.sort(Comparator.comparing(o -> o.emote.name.getString().toLowerCase()));
        this.filter(() -> "");
    }

    @Override
    public void filter(Supplier<String> string) {
        this.func_230963_j_();
        for (AbstractEmoteEntry emote : this.emotes) {
            if (!emote.emote.name.getString().toLowerCase().contains(string.get()) && !emote.emote.description.getString().toLowerCase().contains(string.get()) && !emote.emote.author.getString().toLowerCase().equals(string.get())) continue;
            this.func_230513_b_((AbstractList.AbstractListEntry)emote);
        }
        this.func_230932_a_(0.0);
    }

    @Override
    public void renderThis(MatrixStack matrices, int mouseX, int mouseY, float tickDelta) {
        this.func_230430_a_(matrices, mouseX, mouseY, tickDelta);
    }

    protected int func_230952_d_() {
        return this.field_230674_k_ - 6;
    }

    protected boolean func_230971_aw__() {
        return this.screen.func_241217_q_() == this;
    }

    @Override
    public AbstractEmoteListWidget<E> get() {
        return this;
    }

    public static abstract class AbstractEmoteEntry<T extends AbstractEmoteEntry<T>>
    extends ExtendedList.AbstractListEntry<T>
    implements IEmoteListWidgetHelper.IEmoteEntry<MatrixStack>,
    IDrawableImpl {
        protected final Minecraft client;
        public final EmoteHolder emote;

        public AbstractEmoteEntry(Minecraft client, EmoteHolder emote) {
            this.client = client;
            this.emote = emote;
        }

        public void func_230432_a_(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderThis(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        @Override
        public EmoteHolder getEmote() {
            return this.emote;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        protected abstract void onPressed();
    }
}

