/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.kosmx.bendylibForge.IModelPart;
import io.github.kosmx.bendylibForge.MutableModelPart;
import io.github.kosmx.bendylibForge.impl.BendableCuboid;
import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.common.tools.SetableSupplier;
import io.github.kosmx.emotes.executor.emotePlayer.IUpperPartHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class BendableModelPart
extends MutableModelPart {
    @Nullable
    protected SetableSupplier<EmotePlayImpl> emote;
    protected float axis = 0.0f;
    protected float angl = 0.0f;
    protected boolean isUpperPart = false;

    public BendableModelPart(ModelRenderer modelPart, boolean isUpperPart, @Nullable SetableSupplier<EmotePlayImpl> emote) {
        super(modelPart);
        this.emote = emote;
        this.isUpperPart = isUpperPart;
        ((IModelPart)modelPart).mutate(this);
        ((IUpperPartHelper)modelPart).setUpperPart(isUpperPart);
    }

    public BendableModelPart(ModelRenderer modelPart, @Nullable SetableSupplier<EmotePlayImpl> emote) {
        this(modelPart, false, emote);
    }

    public BendableModelPart(ModelRenderer modelPart) {
        this(modelPart, null);
    }

    public BendableModelPart(ModelRenderer modelPart, boolean isUpperPart) {
        this(modelPart, isUpperPart, null);
    }

    @Override
    public String modId() {
        return "Emotecraft";
    }

    @Override
    public int getPriority() {
        return 4;
    }

    public Matrix4f getMatrix4f() {
        return ((BendableCuboid)this.iCuboids.get(0)).getLastPosMatrix();
    }

    public BendableCuboid getCuboid() {
        return (BendableCuboid)this.iCuboids.get(0);
    }

    @Override
    public boolean isActive() {
        return this.emote != null && EmotePlayImpl.isRunningEmote(this.emote.get()) && this.angl != 0.0f;
    }

    public void setEmote(@Nullable SetableSupplier<EmotePlayImpl> emote) {
        this.emote = emote;
    }

    @Nullable
    public SetableSupplier<EmotePlayImpl> getEmote() {
        return this.emote;
    }

    public void bend(float a, float b) {
        this.axis = a;
        this.angl = b;
        ((BendableCuboid)this.iCuboids.get(0)).applyBend(a, b);
    }

    public void bend(Pair<Float, Float> pair) {
        this.bend(pair.getLeft().floatValue(), pair.getRight().floatValue());
    }

    public void copyBend(@Nonnull BendableModelPart mutableModelPart) {
        this.bend(mutableModelPart.axis, mutableModelPart.angl);
    }

    public boolean isUpperPart() {
        return this.isUpperPart;
    }

    public static void roteteMatrixStack(MatrixStack matrices, Pair<Float, Float> pair) {
        float offset = 0.375f;
        matrices.func_227861_a_(0.0, (double)offset, 0.0);
        float bend = pair.getRight().floatValue();
        float axisf = -pair.getLeft().floatValue();
        Vector3f axis = new Vector3f((float)Math.cos(axisf), 0.0f, (float)Math.sin(axisf));
        matrices.func_227863_a_(axis.func_229193_c_(bend));
        matrices.func_227861_a_(0.0, (double)(-offset), 0.0);
    }
}

