/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge;

import io.github.kosmx.emotes.arch.gui.EmoteMenuImpl;
import io.github.kosmx.emotes.arch.gui.screen.ingame.FastChosseScreen;
import io.github.kosmx.emotes.forge.executor.ForgeClientMethods;
import io.github.kosmx.emotes.forge.network.ClientNetworkInstance;
import io.github.kosmx.emotes.main.MainClientInit;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientInit {
    static KeyBinding openMenuKey;
    static KeyBinding stopEmote;
    static KeyBinding debugKey;
    static Consumer<Minecraft> keyBindingFunction;

    static void initClient() {
        ClientInit.initKeyBinding();
        ClientNetworkInstance.networkInstance.init();
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (minecraft, screen) -> new EmoteMenuImpl((Screen)screen));
    }

    @SubscribeEvent
    public static void endClientTick(TickEvent.ClientTickEvent event) {
        ++ForgeClientMethods.tick;
    }

    @SubscribeEvent
    public static void keyListenerEvent(InputEvent.KeyInputEvent event) {
        keyBindingFunction.accept(null);
    }

    private static void initKeyBinding() {
        openMenuKey = new KeyBinding("key.emotecraft.fastchoose", InputMappings.Type.KEYSYM, 66, "category.emotecraft.keybinding");
        ClientRegistry.registerKeyBinding((KeyBinding)openMenuKey);
        stopEmote = new KeyBinding("key.emotecraft.stop", InputMappings.Type.KEYSYM, -1, "category.emotecraft.keybinding");
        ClientRegistry.registerKeyBinding((KeyBinding)stopEmote);
        if (FMLLoader.getGamePath().resolve("emote.json").toFile().isFile()) {
            debugKey = new KeyBinding("key.emotecraft.debug", InputMappings.Type.KEYSYM, 79, "category.emotecraft.keybinding");
            ClientRegistry.registerKeyBinding((KeyBinding)debugKey);
        }
        keyBindingFunction = client -> {
            if (openMenuKey.func_151468_f() && Minecraft.func_71410_x().field_71439_g == Minecraft.func_71410_x().func_175606_aa()) {
                Minecraft.func_71410_x().func_147108_a((Screen)new FastChosseScreen(null));
            }
            if (stopEmote.func_151468_f()) {
                ClientEmotePlay.clientStopLocalEmote();
            }
            if (debugKey != null && debugKey.func_151468_f()) {
                MainClientInit.playDebugEmote();
            }
        };
    }
}

