/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.kosmx.bendylibForge.IModelPart;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.common.tools.SetableSupplier;
import io.github.kosmx.emotes.executor.emotePlayer.IMutatedBipedModel;
import io.github.kosmx.emotes.executor.emotePlayer.IUpperPartHelper;
import io.github.kosmx.emotes.forge.BendableModelPart;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BipedModel.class})
public abstract class BipedEntityModelMixin<T extends LivingEntity>
extends AgeableModel<T>
implements IMutatedBipedModel<BendableModelPart, EmotePlayImpl> {
    @Shadow
    public ModelRenderer field_178721_j;
    @Shadow
    public ModelRenderer field_178723_h;
    @Shadow
    public ModelRenderer field_178722_k;
    @Shadow
    public ModelRenderer field_178724_i;
    protected BendableModelPart mutatedTorso;
    protected BendableModelPart mutatedRightArm;
    protected BendableModelPart mutatedLeftArm;
    protected BendableModelPart mutatedLeftLeg;
    protected BendableModelPart mutatedRightLeg;
    protected SetableSupplier<EmotePlayImpl> emote;
    @Shadow
    public ModelRenderer field_78116_c;
    @Shadow
    public ModelRenderer field_78115_e;
    @Shadow
    public ModelRenderer field_178720_f;

    @Inject(method={"<init>(Ljava/util/function/Function;FFII)V"}, at={@At(value="RETURN")})
    private void InitInject(Function<ResourceLocation, RenderType> texturedLayerFactory, float scale, float pivotY, int textureWidth, int textureHeight, CallbackInfo ci) {
        this.mutatedLeftArm = new BendableModelPart(this.field_178724_i, true);
        this.mutatedLeftLeg = new BendableModelPart(this.field_178722_k, false);
        this.mutatedRightArm = new BendableModelPart(this.field_178723_h, true);
        this.mutatedRightLeg = new BendableModelPart(this.field_178721_j, false);
        this.mutatedTorso = new BendableModelPart(this.field_78115_e, false);
        ((IUpperPartHelper)this.field_78116_c).setUpperPart(true);
        ((IUpperPartHelper)this.field_178720_f).setUpperPart(true);
        this.mutatedTorso.addCuboid(-4, 0, -2, 8, 12, 4, scale, Direction.DOWN);
        this.mutatedRightLeg.addCuboid(-2, 0, -2, 4, 12, 4, scale, Direction.UP);
        this.mutatedLeftLeg.addCuboid(-2, 0, -2, 4, 12, 4, scale, Direction.UP);
        this.mutatedLeftArm.addCuboid(-1, -2, -2, 4, 12, 4, scale, Direction.UP);
        this.mutatedRightArm.addCuboid(-3, -2, -2, 4, 12, 4, scale, Direction.UP);
    }

    @Override
    public void setEmoteSupplier(SetableSupplier<EmotePlayImpl> emoteSupplier) {
        this.mutatedLeftLeg.setEmote(emoteSupplier);
        this.mutatedRightLeg.setEmote(emoteSupplier);
        this.mutatedLeftArm.setEmote(emoteSupplier);
        this.mutatedRightArm.setEmote(emoteSupplier);
        this.mutatedTorso.setEmote(emoteSupplier);
        this.emote = emoteSupplier;
    }

    @Inject(method={"copyPropertiesTo"}, at={@At(value="RETURN")})
    private void copyMutatedAttributes(BipedModel<T> bipedEntityModel, CallbackInfo ci) {
        if (this.emote != null) {
            if (((IMutatedBipedModel)bipedEntityModel).getEmoteSupplier() != this.emote) {
                ((IMutatedBipedModel)bipedEntityModel).setEmoteSupplier(this.emote);
            }
            if (EmotePlayImpl.isRunningEmote(this.emote.get())) {
                IMutatedBipedModel thisWithMixin = (IMutatedBipedModel)bipedEntityModel;
                EmotePlayImpl playedEmote = this.emote.get();
                ((BendableModelPart)((Object)thisWithMixin.getTorso())).bend(playedEmote.torso.getBend());
                ((BendableModelPart)((Object)thisWithMixin.getLeftArm())).bend(playedEmote.leftArm.getBend());
                ((BendableModelPart)((Object)thisWithMixin.getLeftLeg())).bend(playedEmote.leftLeg.getBend());
                ((BendableModelPart)((Object)thisWithMixin.getRightArm())).bend(playedEmote.rightArm.getBend());
                ((BendableModelPart)((Object)thisWithMixin.getRightLeg())).bend(playedEmote.rightLeg.getBend());
            }
        }
    }

    public void func_225598_a_(MatrixStack matrices, IVertexBuilder vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (((IModelPart)this.field_78115_e).getActiveMutatedPart() == this.mutatedTorso && this.mutatedTorso.getEmote() != null && EmotePlayImpl.isRunningEmote(this.mutatedTorso.getEmote().get())) {
            this.func_225602_a_().forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.func_228309_a_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            this.func_225600_b_().forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.func_228309_a_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            SetableSupplier<EmotePlayImpl> emoteSupplier = this.mutatedTorso.getEmote();
            matrices.func_227860_a_();
            BendableModelPart.roteteMatrixStack(matrices, emoteSupplier.get().torso.getBend());
            this.func_225602_a_().forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.func_228309_a_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            this.func_225600_b_().forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.func_228309_a_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            matrices.func_227865_b_();
        } else {
            super.func_225598_a_(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }

    @Override
    public BendableModelPart getTorso() {
        return this.mutatedTorso;
    }

    @Override
    public BendableModelPart getRightArm() {
        return this.mutatedRightArm;
    }

    @Override
    public BendableModelPart getLeftArm() {
        return this.mutatedLeftArm;
    }

    @Override
    public BendableModelPart getRightLeg() {
        return this.mutatedRightLeg;
    }

    @Override
    public BendableModelPart getLeftLeg() {
        return this.mutatedLeftLeg;
    }

    @Override
    public void setTorso(BendableModelPart part) {
        this.mutatedTorso = part;
    }

    @Override
    public void setRightArm(BendableModelPart part) {
        this.mutatedRightArm = part;
    }

    @Override
    public void setLeftArm(BendableModelPart part) {
        this.mutatedLeftArm = part;
    }

    @Override
    public void setRightLeg(BendableModelPart part) {
        this.mutatedRightLeg = part;
    }

    @Override
    public void setLeftLeg(BendableModelPart part) {
        this.mutatedLeftLeg = part;
    }

    @Override
    public SetableSupplier<EmotePlayImpl> getEmoteSupplier() {
        return this.emote;
    }
}

