/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge.mixin;

import com.mojang.authlib.GameProfile;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.opennbs.format.Layer;
import io.github.kosmx.emotes.common.tools.Vec3d;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AbstractClientPlayerEntity.class})
public abstract class EmotePlayerMixin
extends PlayerEntity
implements IPlayerEntity<ModelRenderer> {
    int emotes_age = 0;
    @Shadow
    @Final
    public ClientWorld field_213837_d;
    @Nullable
    EmotePlayer<ModelRenderer> emote;

    public EmotePlayerMixin(World world, BlockPos pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Override
    public void playEmote(EmoteData emote, int t) {
        this.emote = new EmotePlayImpl(emote, this::noteConsumer, t);
        this.initEmotePerspective(this.emote);
    }

    private void noteConsumer(Layer.Note note) {
        this.field_213837_d.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), EmotePlayerMixin.getInstrumentFromCode(note.instrument).func_208088_a(), SoundCategory.PLAYERS, note.getVolume(), note.getPitch(), true);
    }

    private static NoteBlockInstrument getInstrumentFromCode(byte b) {
        NoteBlockInstrument[] instruments = new NoteBlockInstrument[]{NoteBlockInstrument.HARP, NoteBlockInstrument.BASS, NoteBlockInstrument.BASEDRUM, NoteBlockInstrument.SNARE, NoteBlockInstrument.HAT, NoteBlockInstrument.GUITAR, NoteBlockInstrument.FLUTE, NoteBlockInstrument.BELL, NoteBlockInstrument.CHIME, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.IRON_XYLOPHONE, NoteBlockInstrument.COW_BELL, NoteBlockInstrument.DIDGERIDOO, NoteBlockInstrument.BIT, NoteBlockInstrument.BANJO, NoteBlockInstrument.PLING};
        if (b >= 0 && b < instruments.length) {
            return instruments[b];
        }
        return NoteBlockInstrument.HARP;
    }

    @Override
    public int emotes_getAge() {
        return this.emotes_age;
    }

    @Override
    public int emotes_getAndIncreaseAge() {
        return this.emotes_age++;
    }

    @Override
    public void voidEmote() {
        this.emote = null;
    }

    @Override
    @Nullable
    public EmotePlayer<ModelRenderer> getEmote() {
        return this.emote;
    }

    @Override
    public UUID emotes_getUUID() {
        return this.func_110124_au();
    }

    @Override
    public boolean isNotStanding() {
        return this.func_213283_Z() != Pose.STANDING;
    }

    @Override
    public Vec3d emotesGetPos() {
        return new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    @Override
    public Vec3d getPrevPos() {
        return new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s);
    }

    @Override
    public float getBodyYaw() {
        return this.field_70761_aq;
    }

    @Override
    public float getViewYaw() {
        return this.field_70177_z;
    }

    @Override
    public void setBodyYaw(float newYaw) {
        this.field_70761_aq = newYaw;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.emoteTick();
    }
}

