/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge.network;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.forge.network.ServerNetwork;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ClientNetworkInstance
extends AbstractNetworkInstance {
    boolean isRemotePresent = false;
    private int remoteVersion = 0;
    public static ClientNetworkInstance networkInstance = new ClientNetworkInstance();
    private boolean disableNBS = false;

    public void init() {
        ServerNetwork.channel.addListener(this::receiveJunk);
        ServerNetwork.channel.addListener(this::registerServerSide);
        MinecraftForge.EVENT_BUS.addListener(this::connectServerCallback);
        MinecraftForge.EVENT_BUS.addListener(this::disconnectEvent);
    }

    private void connectServerCallback(ClientPlayerNetworkEvent.LoggedInEvent event) {
        this.isRemotePresent = false;
    }

    private void disconnectEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.disconnect();
    }

    private void receiveJunk(NetworkEvent.ServerCustomPayloadEvent event) {
        this.receiveMessage(event.getPayload());
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    private void registerServerSide(NetworkEvent.ChannelRegistrationChangeEvent event) {
        this.isRemotePresent = event.getRegistrationChangeType() == NetworkEvent.RegistrationChangeType.REGISTER;
        this.sendConfigCallback();
    }

    void receiveMessage(PacketBuffer buf) {
        if (buf.isDirect()) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            this.receiveMessage(bytes);
        } else {
            this.receiveMessage(buf.array());
        }
    }

    @Override
    public HashMap<Byte, Byte> getVersions() {
        if (this.disableNBS) {
            HashMap<Byte, Byte> map = new HashMap<Byte, Byte>();
            map.put((byte)3, (byte)0);
            return map;
        }
        return null;
    }

    @Override
    public void setVersions(HashMap<Byte, Byte> map) {
        if (map.containsKey((byte)3)) {
            boolean bl = this.disableNBS = map.get((byte)3) == 0;
        }
        if (map.containsKey((byte)8)) {
            this.remoteVersion = map.get((byte)8).byteValue();
        }
    }

    @Override
    public int getRemoteVersion() {
        return this.remoteVersion;
    }

    @Override
    public boolean sendPlayerID() {
        return false;
    }

    @Override
    public boolean isActive() {
        return Minecraft.func_71410_x().func_147114_u() != null && ServerNetwork.channel.isRemotePresent(Minecraft.func_71410_x().func_147114_u().func_147298_b()) || this.isRemotePresent;
    }

    public static CCustomPayloadPacket newC2SEmotePacket(NetData data) throws IOException {
        CCustomPayloadPacket packet = new CCustomPayloadPacket();
        packet.setName(ServerNetwork.channelID);
        packet.setData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])new EmotePacket.Builder(data).build().write().array())));
        return packet;
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        if (Minecraft.func_71410_x().func_147114_u() != null) {
            Minecraft.func_71410_x().func_147114_u().func_147297_a((IPacket)ClientNetworkInstance.newC2SEmotePacket(builder.copyAndGetData()));
        }
    }
}

