/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.forge.mixin.ChunkMapAccessor;
import io.github.kosmx.emotes.forge.mixin.TrackedEntityAccessor;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.event.EventNetworkChannel;

public class ServerNetwork
extends AbstractServerEmotePlay<PlayerEntity> {
    public static final ResourceLocation channelID = new ResourceLocation("emotecraft", "emote");
    public static final ResourceLocation geyserChannelID = new ResourceLocation("geyser", "emote");
    public static final EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)channelID, () -> "8", s -> true, s -> true);
    public static final EventNetworkChannel geyserChannel = NetworkRegistry.newEventChannel((ResourceLocation)geyserChannelID, () -> "0", s -> true, s -> true);
    public static ServerNetwork instance = new ServerNetwork();

    public void init() {
        channel.addListener(this::receiveByteBuf);
        geyserChannel.addListener(this::receiveGeyserEvent);
    }

    public void receiveByteBuf(NetworkEvent.ClientCustomPayloadEvent event) {
        instance.receiveMessage(((NetworkEvent.Context)event.getSource().get()).getSender(), ((NetworkEvent.Context)event.getSource().get()).getSender().field_71135_a, event.getPayload());
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    public void receiveGeyserEvent(NetworkEvent.ClientCustomPayloadEvent networkEvent) {
        this.receiveGeyserMessage(((NetworkEvent.Context)networkEvent.getSource().get()).getSender(), this.toBytes(networkEvent.getPayload()));
        ((NetworkEvent.Context)networkEvent.getSource().get()).setPacketHandled(true);
    }

    void receiveMessage(ServerPlayerEntity player, ServerPlayNetHandler handler, PacketBuffer buf) {
        try {
            this.receiveMessage(this.toBytes(buf), player, (INetworkInstance)handler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    byte[] toBytes(PacketBuffer buf) {
        if (buf.isDirect()) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            return bytes;
        }
        return buf.array();
    }

    @Override
    protected UUID getUUIDFromPlayer(PlayerEntity player) {
        return player.func_110124_au();
    }

    @Override
    protected long getRuntimePlayerID(PlayerEntity player) {
        return player.func_145782_y();
    }

    @Override
    protected void sendForEveryoneElse(GeyserEmotePacket packet, PlayerEntity player) {
        try {
            this.sendConsumer(player, serverPlayer -> {
                try {
                    if (geyserChannel.isRemotePresent(serverPlayer.field_71135_a.func_147298_b())) {
                        PacketDistributor.PLAYER.with(() -> serverPlayer).send(ServerNetwork.newS2CEmotesPacket(geyserChannelID, packet.write()));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void sendForEveryoneElse(NetData data, @Nullable GeyserEmotePacket emotePacket, PlayerEntity player) {
        data.player = player.func_110124_au();
        try {
            this.sendConsumer(player, serverPlayer -> {
                try {
                    PacketDistributor.PLAYER.with(() -> serverPlayer).send(ServerNetwork.newS2CEmotesPacket(data));
                    if (emotePacket != null && geyserChannel.isRemotePresent(serverPlayer.field_71135_a.func_147298_b())) {
                        PacketDistributor.PLAYER.with(() -> serverPlayer).send(ServerNetwork.newS2CEmotesPacket(geyserChannelID, emotePacket.write()));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static IPacket newS2CEmotesPacket(NetData data) throws IOException {
        SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket();
        packet.setName(channelID);
        packet.setData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])new EmotePacket.Builder(data).build().write().array())));
        return packet;
    }

    public static IPacket newS2CEmotesPacket(ResourceLocation channelID, byte[] data) throws IOException {
        SCustomPayloadPlayPacket packet = new SCustomPayloadPlayPacket();
        packet.setName(channelID);
        packet.setData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])data)));
        return packet;
    }

    @Override
    protected void sendForPlayerInRange(NetData data, PlayerEntity player, UUID target) {
        if (Objects.requireNonNull(player.func_130014_f_().func_217371_b(target)).func_70685_l((Entity)player)) {
            this.sendForPlayer(data, player, target);
        }
    }

    @Override
    protected void sendForPlayer(NetData data, PlayerEntity player, UUID target) {
        try {
            PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player.func_130014_f_().func_217371_b(target)).send(ServerNetwork.newS2CEmotesPacket(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendConsumer(PlayerEntity player, Consumer<ServerPlayerEntity> consumer) {
        TrackedEntityAccessor tracker = (TrackedEntityAccessor)((ChunkMapAccessor)((ServerChunkProvider)player.func_130014_f_().func_72863_F()).field_217237_a).getTrackedEntity().get(player.func_145782_y());
        tracker.getPlayersTracking().stream().forEach(consumer);
    }
}

