/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.screen.widget;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.dataTypes.InputKey;
import io.github.kosmx.emotes.executor.dataTypes.other.EmotesTextFormatting;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.screen.IRenderHelper;
import io.github.kosmx.emotes.main.screen.widget.IWidgetLogic;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Supplier;

public interface IEmoteListWidgetHelper<MATRIX, WIDGET>
extends IWidgetLogic<MATRIX, WIDGET> {
    public void filter(Supplier<String> var1);

    public void emotesSetLeftPos(int var1);

    public IEmoteEntry getSelectedEntry();

    public void renderThis(MATRIX var1, int var2, int var3, float var4);

    public void setEmotes(Iterable<EmoteHolder> var1, boolean var2);

    default public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, InputKey> pair : ((ClientConfig)EmoteInstance.config).emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.getLeft())) continue;
            empties.add(new EmoteHolder.Empty(pair.getLeft()));
        }
        return empties;
    }

    public static interface IEmoteEntry<MATRIX>
    extends IRenderHelper<MATRIX> {
        public EmoteHolder getEmote();

        default public void renderThis(MATRIX matrices, int index, int y, int x, int entryWidth, int entryHeitht, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (hovered) {
                this.renderSystemBlendColor(1.0f, 1.0f, 1.0f, 1.0f);
                this.drawableHelperFill(matrices, x - 1, y - 1, x + entryWidth - 9, y + entryHeitht + 1, MathHelper.colorHelper(66, 66, 66, 128));
            }
            this.textDrawWithShadow(matrices, this.getEmote().name, x + 38, y + 1, 0xFFFFFF);
            this.textDrawWithShadow(matrices, this.getEmote().description, x + 38, y + 12, 0x808080);
            if (!this.getEmote().author.getString().equals("")) {
                this.textDrawWithShadow(matrices, EmoteInstance.instance.getDefaults().newTranslationText("emotecraft.emote.author").formatted(EmotesTextFormatting.GOLD).append(this.getEmote().author), x + 38, y + 23, 0x808080);
            }
            if (this.getEmote().getIconIdentifier() != null) {
                this.renderSystemBlendColor(1.0f, 1.0f, 1.0f, 1.0f);
                this.renderBindTexture(this.getEmote().getIconIdentifier());
                this.renderEnableBend();
                this.drawableDrawTexture(matrices, x, y, 32, 32, 0.0f, 0.0f, 256, 256, 256, 256);
                this.renderDisableBend();
            }
        }
    }
}

