/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main;

import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.emote.EmoteFormat;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.common.tools.UUIDMap;
import io.github.kosmx.emotes.common.tools.Vec3d;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.dataTypes.IIdentifier;
import io.github.kosmx.emotes.executor.dataTypes.INativeImageBacketTexture;
import io.github.kosmx.emotes.executor.dataTypes.InputKey;
import io.github.kosmx.emotes.executor.dataTypes.Text;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayer;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmoteHolder
implements Supplier<UUID> {
    public final EmoteData emote;
    public final Text name;
    public final Text description;
    public final Text author;
    public AtomicInteger hash = null;
    public static UUIDMap<EmoteHolder> list = new UUIDMap();
    @Nullable
    public INativeImageBacketTexture nativeIcon = null;
    @Nullable
    private IIdentifier iconIdentifier = null;
    @Nullable
    public INetworkInstance fromInstance = null;

    public EmoteHolder(EmoteData emote) {
        this.emote = emote;
        this.name = EmoteInstance.instance.getDefaults().fromJson(emote.name);
        this.description = EmoteInstance.instance.getDefaults().fromJson(emote.description);
        this.author = EmoteInstance.instance.getDefaults().fromJson(emote.author);
    }

    @Deprecated
    public EmoteHolder(EmoteData emote, Text name, Text description, Text author, int hash) {
        this.emote = emote;
        this.name = name;
        this.author = author;
        this.description = description;
    }

    public static void clearEmotes() {
        list.removeIf(new Predicate<EmoteHolder>(){

            @Override
            public boolean test(EmoteHolder emoteHolder) {
                if (emoteHolder.fromInstance != null) {
                    return false;
                }
                if (emoteHolder.iconIdentifier != null) {
                    EmoteInstance.instance.getClientMethods().destroyTexture(emoteHolder.iconIdentifier);
                    assert (emoteHolder.nativeIcon != null);
                    emoteHolder.nativeIcon.close();
                }
                return true;
            }
        });
    }

    public IIdentifier getIconIdentifier() {
        block3: {
            if (this.iconIdentifier == null && this.emote.iconData != null) {
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(Objects.requireNonNull(AbstractNetworkInstance.safeGetBytesFromBuffer(this.emote.iconData)));
                    this.assignIcon(stream);
                    ((InputStream)stream).close();
                }
                catch (IOException | NullPointerException e) {
                    e.printStackTrace();
                    if (((ClientConfig)EmoteInstance.config).neverRemoveBadIcon.get().booleanValue()) break block3;
                    this.emote.iconData = null;
                }
            }
        }
        return this.iconIdentifier;
    }

    public void assignIcon(InputStream inputStream) {
        try {
            INativeImageBacketTexture nativeImageBackedTexture = EmoteInstance.instance.getClientMethods().readNativeImage(inputStream);
            this.iconIdentifier = EmoteInstance.instance.getDefaults().newIdentifier("icon" + this.hashCode());
            EmoteInstance.instance.getClientMethods().registerTexture(this.iconIdentifier, nativeImageBackedTexture);
            this.nativeIcon = nativeImageBackedTexture;
        }
        catch (Throwable var) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, "Can't open emote icon: " + var);
            this.iconIdentifier = null;
            this.nativeIcon = null;
        }
    }

    public EmoteData getEmote() {
        return this.emote;
    }

    public static EmoteHolder getEmoteFromUuid(UUID uuid) {
        return (EmoteHolder)list.get(uuid);
    }

    public static void addEmoteToList(Iterable<EmoteData> emotes) {
        for (EmoteData emote : emotes) {
            list.add(new EmoteHolder(emote));
        }
    }

    public static EmoteHolder addEmoteToList(EmoteData emote) {
        EmoteHolder newEmote = new EmoteHolder(emote);
        EmoteHolder old = newEmote.findIfPresent();
        if (old == null) {
            list.add(newEmote);
            return newEmote;
        }
        return old;
    }

    EmoteHolder findIfPresent() {
        if (list.contains(this)) {
            for (EmoteHolder obj : list) {
                if (!obj.equals(this)) continue;
                return obj;
            }
        }
        return null;
    }

    @Deprecated
    public static void addEmoteToList(EmoteHolder hold) {
        list.add(hold);
    }

    public static boolean playEmote(EmoteData emote, IEmotePlayerEntity player) {
        return EmoteHolder.playEmote(emote, player, null);
    }

    public static boolean playEmote(EmoteData emote, IEmotePlayerEntity player, @Nullable EmoteHolder emoteHolder) {
        if (EmoteHolder.canPlayEmote(player)) {
            return ClientEmotePlay.clientStartLocalEmote(emote);
        }
        return false;
    }

    private static boolean canPlayEmote(IEmotePlayerEntity entity) {
        if (!EmoteHolder.canRunEmote(entity)) {
            return false;
        }
        if (!entity.isMainPlayer()) {
            return false;
        }
        return !IEmotePlayer.isRunningEmote(entity.getEmote()) || entity.getEmote().isLoopStarted();
    }

    public static boolean canRunEmote(IEmotePlayerEntity player) {
        if (!EmoteInstance.instance.getClientMethods().isAbstractClientEntity(player)) {
            return false;
        }
        if (player.isNotStanding()) {
            return false;
        }
        Vec3d prevPos = player.getPrevPos();
        return !(player.emotesGetPos().distanceTo(new Vec3d((Double)prevPos.getX(), MathHelper.lerp((double)((ClientConfig)EmoteInstance.config).yRatio.get().floatValue(), (Double)prevPos.getY(), (Double)player.emotesGetPos().getY()), (Double)prevPos.getZ())) > (double)((ClientConfig)EmoteInstance.config).stopThreshold.get().floatValue());
    }

    public boolean playEmote(IEmotePlayerEntity playerEntity) {
        return EmoteHolder.playEmote(this.emote, playerEntity, this);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = new AtomicInteger(this.emote.hashCode());
        }
        return this.hash.get();
    }

    public UUID getUuid() {
        return this.emote.getUuid();
    }

    public boolean equals(Object o) {
        if (o instanceof EmoteHolder) {
            return this.emote.equals(((EmoteHolder)o).emote);
        }
        return false;
    }

    @Override
    public UUID get() {
        return this.emote.get();
    }

    public static void handleKeyPress(InputKey key) {
        EmoteHolder emoteHolder;
        UUID uuid;
        if (EmoteHolder.canRunEmote(EmoteInstance.instance.getClientMethods().getMainPlayer()) && (uuid = ((ClientConfig)EmoteInstance.config).emoteKeyMap.getL(key)) != null && (emoteHolder = (EmoteHolder)list.get(uuid)) != null) {
            ClientEmotePlay.clientStartLocalEmote(emoteHolder);
        }
    }

    public static EmoteHolder getNonNull(@Nonnull UUID emote) {
        EmoteHolder emoteHolder = (EmoteHolder)list.get(emote);
        if (emoteHolder == null) {
            return new Empty(emote);
        }
        return emoteHolder;
    }

    public static class Empty
    extends EmoteHolder {
        public Empty(UUID uuid) {
            super(new EmoteData.EmoteBuilder(EmoteFormat.UNKNOWN).setName("{\"color\":\"red\",\"text\":\"INVALID\"}").setUuid(uuid).build());
        }
    }
}

