/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.MathHelper;

public abstract class AITargetGoal
extends Goal {
    public final MobEntity goalOwner;
    public final boolean shouldCheckSight;
    public final boolean nearbyOnly;
    public int targetSearchStatus;
    public int targetSearchDelay;
    public int targetUnseenTicks;
    public LivingEntity target;
    public int unseenMemoryTicks = 60;

    public AITargetGoal(MobEntity mobIn, boolean checkSight) {
        this(mobIn, checkSight, false);
    }

    public AITargetGoal(MobEntity mobIn, boolean checkSight, boolean nearbyOnlyIn) {
        this.goalOwner = mobIn;
        this.shouldCheckSight = checkSight;
        this.nearbyOnly = nearbyOnlyIn;
    }

    public boolean func_75253_b() {
        LivingEntity livingentity = this.goalOwner.func_70638_az();
        if (livingentity == null) {
            livingentity = this.target;
        }
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        Team team = this.goalOwner.func_96124_cp();
        Team team1 = livingentity.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getTargetDistance();
        if (this.goalOwner.func_70068_e((Entity)livingentity) > d0 * d0) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.goalOwner.func_70635_at().func_75522_a((Entity)livingentity)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) {
                return false;
            }
        }
        if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
            return false;
        }
        this.goalOwner.func_70624_b(livingentity);
        return true;
    }

    protected double getTargetDistance() {
        return this.goalOwner.func_233637_b_(Attributes.field_233819_b_);
    }

    public void func_75249_e() {
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.targetUnseenTicks = 0;
    }

    public void func_75251_c() {
        this.goalOwner.func_70624_b((LivingEntity)null);
        this.target = null;
    }

    protected boolean isSuitableTarget(@Nullable LivingEntity potentialTarget, EntityPredicate targetPredicate) {
        if (potentialTarget == null) {
            return false;
        }
        if (!targetPredicate.func_221015_a((LivingEntity)this.goalOwner, potentialTarget)) {
            return false;
        }
        if (!this.goalOwner.func_213389_a(potentialTarget.func_233580_cy_())) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.canEasilyReach(potentialTarget) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canEasilyReach(LivingEntity target) {
        int j;
        this.targetSearchDelay = 10 + this.goalOwner.func_70681_au().nextInt(5);
        Path path = this.goalOwner.func_70661_as().func_75494_a((Entity)target, 0);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)target.func_226277_ct_());
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)target.func_226281_cx_())) * j) <= 2.25;
    }

    public AITargetGoal setUnseenMemoryTicks(int unseenMemoryTicksIn) {
        this.unseenMemoryTicks = unseenMemoryTicksIn;
        return this;
    }
}

