/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper.feature;

import insane96mcp.enhancedai.modules.creeper.ai.AICreeperLaunchGoal;
import insane96mcp.enhancedai.modules.creeper.ai.AICreeperSwellGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.ModSounds;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import java.util.ArrayList;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Creeper Swell", description="Various changes to Creepers exploding. Ignoring Walls, Walking Fuse and smarter exploding based off explosion size")
public class CreeperSwellFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> cenaChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> walkingFuseConfig;
    private final ForgeConfigSpec.ConfigValue<Double> ignoreWallsConfig;
    private final ForgeConfigSpec.ConfigValue<Double> breachConfig;
    private final ForgeConfigSpec.ConfigValue<Double> launchConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> tntLikeConfig;
    public double cenaChance = 0.02;
    public double walkingFuseChance = 0.1;
    public double ignoreWalls = 0.1;
    public double breach = 0.075;
    public double launch = 0.05;
    public boolean tntLike = false;

    public CreeperSwellFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.cenaChanceConfig = Config.builder.comment("AND HIS NAME IS ...").defineInRange("Cena Chance", this.cenaChance, 0.0, 1.0);
        this.walkingFuseConfig = Config.builder.comment("Percentage chance for a Creeper to not stand still while exploding.").defineInRange("Walking Fuse Chance", this.walkingFuseChance, 0.0, 1.0);
        this.ignoreWallsConfig = Config.builder.comment("Percentage chance for a Creeper to ignore walls while targeting a player. This means that a creeper will be able to explode if it's in the correct range from a player even if there's a wall between.").defineInRange("Ignore Walls Chance", this.ignoreWalls, 0.0, 1.0);
        this.breachConfig = Config.builder.comment("Breaching creepers will try to open an hole in the wall to let mobs in.").defineInRange("Breach Chance", this.breach, 0.0, 1.0);
        this.launchConfig = Config.builder.comment("Launching creepers will try ignite and throw themselves at the player.").defineInRange("Launch Chance", this.launch, 0.0, 1.0);
        this.tntLikeConfig = Config.builder.comment("If true creepers will ignite if damaged by an explosion.").define("TNT Like", this.tntLike);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.cenaChance = (Double)this.cenaChanceConfig.get();
        this.walkingFuseChance = (Double)this.walkingFuseConfig.get();
        this.ignoreWalls = (Double)this.ignoreWallsConfig.get();
        this.breach = (Double)this.breachConfig.get();
        this.launch = (Double)this.launchConfig.get();
        this.tntLike = (Boolean)this.tntLikeConfig.get();
    }

    @SubscribeEvent
    public void explosionStartEvent(ExplosionEvent.Detonate event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion e = event.getExplosion();
        if (!(e.getExploder() instanceof CreeperEntity)) {
            return;
        }
        CreeperEntity creeper = (CreeperEntity)e.getExploder();
        if (creeper.getPersistentData().func_74767_n("enhancedai:john_cena")) {
            creeper.func_184185_a((SoundEvent)ModSounds.CREEPER_CENA_EXPLODE.get(), 4.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion explosion = event.getExplosion();
        if (!(explosion.getExploder() instanceof CreeperEntity)) {
            return;
        }
        CreeperEntity creeper = (CreeperEntity)explosion.getExploder();
        CompoundNBT compoundNBT = creeper.getPersistentData();
        if (compoundNBT.func_74767_n("enhancedai:explosion_causes_fire")) {
            explosion.field_77286_a = true;
        }
    }

    @SubscribeEvent
    public void eventEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof CreeperEntity)) {
            return;
        }
        CreeperEntity creeper = (CreeperEntity)event.getEntity();
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        creeper.field_70714_bg.field_220892_d.forEach(prioritizedGoal -> {
            if (prioritizedGoal.func_220772_j() instanceof CreeperSwellGoal) {
                goalsToRemove.add(prioritizedGoal.func_220772_j());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)creeper.field_70714_bg).func_85156_a(arg_0));
        AICreeperSwellGoal swellGoal = new AICreeperSwellGoal(creeper, creeper.field_70170_p.field_73012_v.nextDouble() < this.walkingFuseChance);
        if (creeper.field_70170_p.field_73012_v.nextDouble() < this.cenaChance) {
            creeper.func_200203_b((ITextComponent)new StringTextComponent("Creeper Cena"));
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74777_a("Fuse", (short)34);
            compoundNBT.func_74774_a("ExplosionRadius", (byte)6);
            compoundNBT.func_74757_a("powered", creeper.func_225509_J__());
            creeper.func_70037_a(compoundNBT);
            creeper.getPersistentData().func_74757_a("enhancedai:explosion_causes_fire", true);
            creeper.getPersistentData().func_74757_a("enhancedai:john_cena", true);
        }
        swellGoal.setIgnoreWalls(creeper.field_70170_p.field_73012_v.nextDouble() < this.ignoreWalls);
        swellGoal.setBreaching(creeper.field_70170_p.field_73012_v.nextDouble() < this.breach);
        creeper.field_70714_bg.func_75776_a(2, (Goal)swellGoal);
        if (creeper.field_70170_p.field_73012_v.nextDouble() < this.launch) {
            creeper.field_70714_bg.func_75776_a(1, (Goal)new AICreeperLaunchGoal(creeper));
            creeper.getPersistentData().func_74757_a("enhancedai:launch", true);
        }
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        if (!this.tntLike) {
            return;
        }
        if (!event.getSource().func_94541_c()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof CreeperEntity)) {
            return;
        }
        CreeperEntity creeper = (CreeperEntity)event.getEntityLiving();
        creeper.func_146079_cb();
    }
}

