/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.feature;

import insane96mcp.enhancedai.modules.base.ai.AIAvoidEntityGoal;
import insane96mcp.enhancedai.modules.skeleton.ai.AIRangedBowAttackGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;

@Label(name="Skeleton Shoot", description="Skeletons are more precise when shooting and strafing is removed, can hit a target from 64 blocks and try to stay away from the target.")
public class SkeletonAIFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> avoidPlayerChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> arrowInaccuracyConfig;
    public double avoidPlayerChance = 1.0;
    public double arrowInaccuracy = 0.0;

    public SkeletonAIFeature(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.avoidPlayerChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn with the ability to avoid the player").defineInRange("Avoid Player chance", this.avoidPlayerChance, 0.0, 1.0);
        this.arrowInaccuracyConfig = Config.builder.comment("How much inaccuracy does the arrow fired by skeletons have. Vanilla skeletons have 10/6/2 inaccuracy in easy/normal/hard difficulty.").defineInRange("Arrow Inaccuracy", this.arrowInaccuracy, 0.0, 30.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.avoidPlayerChance = (Double)this.avoidPlayerChanceConfig.get();
        this.arrowInaccuracy = (Double)this.arrowInaccuracyConfig.get();
    }

    public void setCombatTask(AbstractSkeletonEntity skeleton) {
        boolean hasAIArrowAttack = false;
        for (PrioritizedGoal prioritizedGoal : skeleton.field_70714_bg.field_220892_d) {
            if (!prioritizedGoal.func_220772_j().equals(skeleton.field_85037_d)) continue;
            hasAIArrowAttack = true;
        }
        List<Goal> avoidEntityGoals = skeleton.field_70714_bg.field_220892_d.stream().map(PrioritizedGoal::func_220772_j).filter(g -> g instanceof AIAvoidEntityGoal).collect(Collectors.toList());
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.field_70714_bg).func_85156_a(arg_0));
        if (hasAIArrowAttack) {
            AIRangedBowAttackGoal<AbstractSkeletonEntity> rangedBowAttackGoal = new AIRangedBowAttackGoal<AbstractSkeletonEntity>(skeleton, 1.0, 20, 64.0f);
            skeleton.field_70714_bg.func_75776_a(2, rangedBowAttackGoal);
            if (skeleton.field_70170_p.field_73012_v.nextDouble() < this.avoidPlayerChance) {
                AIAvoidEntityGoal<PlayerEntity> avoidEntityGoal = new AIAvoidEntityGoal<PlayerEntity>((CreatureEntity)skeleton, PlayerEntity.class, 12.0f, 1.6, 1.3);
                skeleton.field_70714_bg.func_75776_a(1, avoidEntityGoal);
            }
        }
    }
}

