/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.ai;

import insane96mcp.enhancedai.modules.Modules;
import insane96mcp.insanelib.utils.IdTagMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class AIZombieDigger
extends Goal {
    private final ZombieEntity digger;
    private PlayerEntity targetPlayer;
    private final double reachDistance;
    private final List<BlockPos> targetBlocks = new ArrayList<BlockPos>();
    private int tickToBreak = 0;
    private int breakingTick = 0;
    private BlockState blockState = null;
    private int prevBreakProgress = 0;
    private final boolean toolOnly;
    private final boolean properToolOnly;
    private int ticksWithNoPath = 0;

    public AIZombieDigger(ZombieEntity digger, boolean toolOnly, boolean properToolOnly) {
        this.digger = digger;
        this.reachDistance = 4.0;
        this.toolOnly = toolOnly;
        this.properToolOnly = properToolOnly;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.toolOnly && !(this.digger.func_184592_cb().func_77973_b() instanceof ToolItem)) {
            return false;
        }
        LivingEntity target = this.digger.func_70638_az();
        if (!(target instanceof PlayerEntity)) {
            return false;
        }
        if (this.digger.func_70661_as().func_75500_f() || this.digger.func_70661_as().func_244428_t()) {
            ++this.ticksWithNoPath;
        } else if (this.ticksWithNoPath > 0) {
            --this.ticksWithNoPath;
        }
        return this.ticksWithNoPath >= 20 && this.digger.func_70068_e((Entity)target) > 1.5;
    }

    public boolean func_75253_b() {
        if (this.properToolOnly && this.blockState != null && !this.canHarvestBlock()) {
            return false;
        }
        return !this.targetBlocks.isEmpty() && this.targetPlayer != null && this.targetPlayer.func_70089_S() && this.targetBlocks.get(0).func_177951_i((Vector3i)this.digger.func_233580_cy_()) < this.reachDistance * this.reachDistance && this.digger.func_70661_as().func_75500_f() && !this.digger.field_70170_p.func_180495_p(this.targetBlocks.get(0)).func_196958_f();
    }

    public void func_75249_e() {
        this.targetPlayer = (PlayerEntity)this.digger.func_70638_az();
        this.fillTargetBlocks();
        if (!this.targetBlocks.isEmpty()) {
            this.initBlockBreak();
        }
    }

    public void func_75251_c() {
        this.targetPlayer = null;
        if (!this.targetBlocks.isEmpty()) {
            this.digger.field_70170_p.func_175715_c(this.digger.func_145782_y(), this.targetBlocks.get(0), -1);
            this.targetBlocks.clear();
        }
        this.tickToBreak = 0;
        this.breakingTick = 0;
        this.blockState = null;
        this.prevBreakProgress = 0;
        this.ticksWithNoPath = 0;
    }

    public void func_75246_d() {
        if (this.targetBlocks.isEmpty()) {
            return;
        }
        if (this.properToolOnly && this.blockState != null && !this.canHarvestBlock()) {
            return;
        }
        ++this.breakingTick;
        this.digger.func_70671_ap().func_220679_a((double)this.targetBlocks.get(0).func_177958_n() + 0.5, (double)this.targetBlocks.get(0).func_177956_o() + 0.5, (double)this.targetBlocks.get(0).func_177952_p() + 0.5);
        if (this.prevBreakProgress != (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f)) {
            this.digger.field_70170_p.func_175715_c(this.digger.func_145782_y(), this.targetBlocks.get(0), this.prevBreakProgress);
            this.prevBreakProgress = (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f);
        }
        if (this.breakingTick % 6 == 0) {
            this.digger.func_184609_a(Hand.MAIN_HAND);
        }
        if (this.breakingTick % 4 == 0) {
            SoundType soundType = this.blockState.getSoundType((IWorldReader)this.digger.field_70170_p, this.targetBlocks.get(0), (Entity)this.digger);
            this.digger.field_70170_p.func_184133_a(null, this.targetBlocks.get(0), soundType.func_185846_f(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        }
        if (this.breakingTick >= this.tickToBreak) {
            this.digger.field_70170_p.func_225521_a_(this.targetBlocks.get(0), true, (Entity)this.digger);
            this.digger.field_70170_p.func_175715_c(this.digger.func_145782_y(), this.targetBlocks.get(0), -1);
            this.targetBlocks.remove(0);
            if (!this.targetBlocks.isEmpty()) {
                this.initBlockBreak();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.digger.field_70170_p.func_180495_p(this.targetBlocks.get(0));
        this.tickToBreak = this.computeTickToBreak();
        this.breakingTick = 0;
    }

    private int computeTickToBreak() {
        int canHarvestBlock = this.canHarvestBlock() ? 30 : 100;
        double diggingSpeed = this.getDigSpeed() / this.blockState.func_185887_b((IBlockReader)this.digger.field_70170_p, this.targetBlocks.get(0)) / (float)canHarvestBlock;
        return MathHelper.func_76143_f((double)(1.0 / diggingSpeed * Modules.zombie.diggerZombie.miningSpeedMultiplier));
    }

    private float getDigSpeed() {
        float digSpeed = this.digger.func_184592_cb().func_150997_a(this.blockState);
        if (digSpeed > 1.0f) {
            int efficiencyLevel = EnchantmentHelper.func_185293_e((LivingEntity)this.digger);
            ItemStack itemstack = this.digger.func_184592_cb();
            if (efficiencyLevel > 0 && !itemstack.func_190926_b()) {
                digSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
            }
        }
        if (EffectUtils.func_205135_a((LivingEntity)this.digger)) {
            digSpeed *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)this.digger) + 1) * 0.2f;
        }
        if (this.digger.func_70644_a(Effects.field_76419_f)) {
            float miningFatigueAmplifier;
            switch (this.digger.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    miningFatigueAmplifier = 0.3f;
                    break;
                }
                case 1: {
                    miningFatigueAmplifier = 0.09f;
                    break;
                }
                case 2: {
                    miningFatigueAmplifier = 0.0027f;
                    break;
                }
                default: {
                    miningFatigueAmplifier = 8.1E-4f;
                }
            }
            digSpeed *= miningFatigueAmplifier;
        }
        if (this.digger.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)this.digger)) {
            digSpeed /= 5.0f;
        }
        if (!this.digger.func_233570_aj_()) {
            digSpeed /= 5.0f;
        }
        return digSpeed;
    }

    private boolean canHarvestBlock() {
        if (!this.blockState.func_235783_q_()) {
            return true;
        }
        ItemStack stack = this.digger.func_184592_cb();
        ToolType tool = this.blockState.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return false;
        }
        int toolLevel = stack.getHarvestLevel(tool, null, this.blockState);
        if (toolLevel < 0) {
            return false;
        }
        return toolLevel >= this.blockState.getHarvestLevel();
    }

    private void fillTargetBlocks() {
        int mobHeight = MathHelper.func_76123_f((float)this.digger.func_213302_cg());
        for (int i = 0; i < mobHeight; ++i) {
            BlockState state;
            double distance;
            BlockRayTraceResult rayTraceResult = this.digger.field_70170_p.func_217299_a(new RayTraceContext(this.digger.func_213303_ch().func_72441_c(0.0, (double)i, 0.0), this.targetPlayer.func_174824_e(1.0f).func_72441_c(0.0, (double)i, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.digger));
            if (rayTraceResult.func_216346_c() == RayTraceResult.Type.MISS || this.targetBlocks.contains(rayTraceResult.func_216350_a()) || (distance = this.digger.func_195048_a(rayTraceResult.func_216347_e())) > this.reachDistance * this.reachDistance || (state = this.digger.field_70170_p.func_180495_p(rayTraceResult.func_216350_a())).hasTileEntity()) continue;
            boolean isInWhitelist = false;
            boolean isInBlacklist = false;
            for (IdTagMatcher blacklistEntry : Modules.zombie.diggerZombie.blockBlacklist) {
                if (!Modules.zombie.diggerZombie.blockBlacklistAsWhitelist) {
                    if (!blacklistEntry.matchesBlock(state.func_177230_c())) continue;
                    isInBlacklist = true;
                    break;
                }
                if (!blacklistEntry.matchesBlock(state.func_177230_c())) continue;
                isInWhitelist = true;
                break;
            }
            if (isInBlacklist || !isInWhitelist && Modules.zombie.diggerZombie.blockBlacklistAsWhitelist) continue;
            this.targetBlocks.add(rayTraceResult.func_216350_a());
        }
        Collections.reverse(this.targetBlocks);
    }
}

