/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal.feature;

import insane96mcp.enhancedai.modules.base.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.IdTagMatcher;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Animals", description="Make animals fight back or group flee when attacked")
@LoadFeature(module="enhancedai:animal")
public class Animals
extends Feature {
    public static final String CAN_ATTACK_BACK = "enhancedai:can_attack_back";
    public static final String PLAYER_SCARED = "enhancedai:player_scared";
    public static final String NOT_TEMPTED = "enhancedai:not_tempted";
    @Config
    @Label(name="Group Flee", description="If true, when an animal is attacked, all the animals around will flee.")
    public static Boolean groupFlee = true;
    @Config
    @Label(name="Flee Range", description="If Group Flee is enabled, this is the range where the animals will flee.")
    public static Integer groupFleeRange = 16;
    @Config
    @Label(name="Fight back chance", description="Animals have this percentage chance to be able to fight back instead of fleeing. Animals have a slightly bigger range to attack. Attack damage can't be changed via config due to limitation so use mods like Mobs Properties Randomness to change the damage. Base damage is 3.")
    public static Double fightBackChance = 0.3;
    @Config
    @Label(name="Players Scared chance", description="Animals have this percentage chance to be scared by players and run away. Fight back chance has priority over this.")
    public static Double playersScaredChance = 0.4;
    @Config
    @Label(name="Not tempted chance", description="Animals have this percentage chance to not be temped by food.")
    public static Double notTemptedChance = 0.5;
    @Config(min=0.0, max=4.0)
    @Label(name="Movement Speed Multiplier", description="Movement speed multiplier when aggroed.")
    public static Double speedMultiplier = 1.3;
    @Config(min=0.0, max=128.0)
    @Label(name="Knockback", description="Animals' knockback attribute will be set to this value.")
    public static Double knockback = 1.5;
    @Config
    @Label(name="Entity Blacklist", description="Entities that shouldn't be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(List.of(new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:llama"), new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:trader_llama"), new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:bee"), new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:wolf"), new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:bear"), new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:panda"), new IdTagMatcher(IdTagMatcher.Type.ID, "minecraft:axolotl")), false);
    private static final double BASE_ATTACK_DAMAGE = 3.0;

    public Animals(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, Attributes.f_22281_)) continue;
            event.add(entityType, Attributes.f_22281_, 3.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Animal animal;
        Entity entity;
        if (!this.isEnabled() || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(animal = (Animal)entity))) {
            return;
        }
        CompoundTag persistentData = animal.getPersistentData();
        double movementSpeedMultiplier = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:speed_multiplier_when_aggroed", speedMultiplier);
        boolean canAttackBack = NBTUtils.getBooleanOrPutDefault(persistentData, CAN_ATTACK_BACK, animal.m_217043_().m_188500_() < fightBackChance);
        boolean playerScared = NBTUtils.getBooleanOrPutDefault(persistentData, PLAYER_SCARED, animal.m_217043_().m_188500_() < playersScaredChance);
        boolean notTempted = NBTUtils.getBooleanOrPutDefault(persistentData, NOT_TEMPTED, animal.m_217043_().m_188500_() < notTemptedChance);
        if (canAttackBack && !animal.m_6162_()) {
            AttributeInstance kbAttribute;
            animal.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)animal, new Class[0]).m_26044_(new Class[0]));
            animal.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)animal, movementSpeedMultiplier, true));
            animal.f_21345_.f_25345_.removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof PanicGoal);
            if (knockback > 0.0 && (kbAttribute = animal.m_21051_(Attributes.f_22282_)) != null) {
                kbAttribute.m_22125_(new AttributeModifier("Animal knockback", knockback.doubleValue(), AttributeModifier.Operation.ADDITION));
            }
        } else if (playerScared) {
            EAAvoidEntityGoal<Player> avoidEntityGoal = new EAAvoidEntityGoal<Player>((PathfinderMob)animal, Player.class, 16.0f, 8.0f, 1.25, 1.1);
            animal.f_21345_.m_25352_(1, avoidEntityGoal);
        }
        if (notTempted) {
            animal.f_21345_.m_148105_().removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof TemptGoal);
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingDamageEvent event) {
        Animal animal;
        LivingEntity livingEntity;
        if (!(this.isEnabled() && groupFlee.booleanValue() && (livingEntity = event.getEntity()) instanceof Animal && !entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(animal = (Animal)livingEntity)) && (livingEntity = event.getSource().m_7639_()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = livingEntity;
        animal.f_19853_.m_45971_(Animal.class, TargetingConditions.m_148353_().m_148355_(), (LivingEntity)animal, animal.m_20191_().m_82400_((double)groupFleeRange.intValue())).stream().filter(otherAnimal -> otherAnimal.m_6095_().equals(animal.m_6095_())).forEach(nearbyAnimal -> nearbyAnimal.m_6703_(attacker));
    }
}

