/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.ClimbLaddersGoal;
import insane96mcp.enhancedai.modules.base.ai.FindLaddersGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Movement", description="Makes mobs be able to move in more ways, like climbing or swim.")
@LoadFeature(module="enhancedai:base")
public class Movement
extends Feature {
    final UUID UUID_SWIM_SPEED_MULTIPLIER = UUID.fromString("6d2cb27e-e5e3-41b9-8108-f74131a90cce");
    @Config
    @Label(name="Allow Climbing", description="If true, mobs will be able to climb (up and down)")
    public static Boolean allowClimbing = false;
    @Config
    @Label(name="Target Ladders", description="If true, mobs try to find climbable blocks to reach the target")
    public static Boolean targetLadders = false;
    @Config(min=0.0, max=4.0)
    @Label(name="Swim Speed Multiplier", description="How faster mobs can swim. Setting to 0 will leave the swim speed as vanilla. I recommend using mods like Mobs Properties Randomness to have more control over the attribute.")
    public static Double swimSpeedMultiplier = 2.5;

    public Movement(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (allowClimbing.booleanValue()) {
            mob.f_21345_.m_25352_(3, (Goal)new ClimbLaddersGoal(mob));
        }
        if (targetLadders.booleanValue()) {
            mob.f_21346_.m_25352_(0, (Goal)new FindLaddersGoal(mob));
        }
        if (swimSpeedMultiplier != 0.0) {
            MCUtils.applyModifier((LivingEntity)mob, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)this.UUID_SWIM_SPEED_MULTIPLIER, (String)"Enhanced AI Swim Speed Multiplier", (double)swimSpeedMultiplier, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
    }
}

