/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.drowned.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Drowned Swimming", description="Makes drowned swim speed based off swim speed attribute instead of movement speed.")
@LoadFeature(module="enhancedai:drowned")
public class DrownedSwimming
extends Feature {
    final UUID UUID_SWIM_SPEED_MULTIPLIER = UUID.fromString("ba2adf05-2438-4d1f-8165-89173f0a1eae");
    @Config(min=0.0, max=4.0)
    @Label(name="Swim Speed Multiplier", description="Multiplier for the swim speed of Drowneds. Note that the swim speed is also affected by the Movement Feature. Set to 0 to disable the multiplier.")
    public static Double swimSpeedMultiplier = 0.3;
    @Config
    @Label(name="Entity Blacklist", description="Entities that shouldn't get the Swim Control from drowneds")
    public static Blacklist entityBlacklist = new Blacklist(List.of(), false);

    public DrownedSwimming(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        Drowned drowned;
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Drowned) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(drowned = (Drowned)entity))) {
            return;
        }
        drowned.f_21342_ = new EADrownedMoveControl(drowned);
        if (swimSpeedMultiplier > 0.0) {
            MCUtils.applyModifier((LivingEntity)drowned, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)this.UUID_SWIM_SPEED_MULTIPLIER, (String)"Enhanced AI Drowneds Swim Speed Multiplier", (double)(swimSpeedMultiplier - 1.0), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    static class EADrownedMoveControl
    extends MoveControl {
        private final Drowned drowned;

        public EADrownedMoveControl(Drowned p_32433_) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            if (this.drowned.m_32392_() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.f_32342_) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * this.drowned.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get()));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
                this.drowned.m_20124_(Pose.SWIMMING);
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                this.drowned.m_20124_(Pose.STANDING);
                super.m_8126_();
            }
        }
    }
}

