/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.Collections;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Wither Skeletons", description="Wither skeletons can spawn with a bow and shoot Wither arrows.")
@LoadFeature(module="enhancedai:skeleton")
public class WitherSkeletons
extends Feature {
    private static final String ON_SPAWN_PROCESSED = "enhancedai:wither_skeletons_on_spawn_processed";
    @Config(min=0.0, max=1.0)
    @Label(name="Ranged chance", description="Chance for Wither Skeletons to spawn with a bow")
    public static Double rangedChance = 0.2;
    @Config
    @Label(name="Wither instead of Fire", description="Wither skeletons shoot Withered arrows instead of arrows on fire")
    public static Boolean witherInsteadOfFire = true;
    @Config
    @Label(name="Entity Blacklist", description="Entities that will not get affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(Collections.emptyList(), false);

    public WitherSkeletons(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        WitherSkeleton witherSkeleton;
        Entity entity;
        if (!this.isEnabled() || rangedChance == 0.0 || !((entity = event.getEntity()) instanceof WitherSkeleton) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(witherSkeleton = (WitherSkeleton)entity)) || witherSkeleton.getPersistentData().m_128441_(ON_SPAWN_PROCESSED) || witherSkeleton.m_217043_().m_188500_() >= rangedChance) {
            return;
        }
        RandomSource randomSource = witherSkeleton.m_217043_();
        float specialMultiplier = witherSkeleton.f_19853_.m_6436_(witherSkeleton.m_20183_()).m_19057_();
        witherSkeleton.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
        if (randomSource.m_188501_() < 0.25f * specialMultiplier) {
            witherSkeleton.m_8061_(EquipmentSlot.MAINHAND, EnchantmentHelper.m_220292_((RandomSource)randomSource, (ItemStack)witherSkeleton.m_21205_(), (int)((int)(5.0f + specialMultiplier * (float)randomSource.m_188503_(18))), (boolean)false));
        }
        witherSkeleton.getPersistentData().m_128379_(ON_SPAWN_PROCESSED, true);
    }

    public static boolean witherInsteadOfFire() {
        return Feature.isEnabled(WitherSkeletons.class) && witherInsteadOfFire != false;
    }
}

