/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.ai;

import insane96mcp.enhancedai.modules.witch.feature.WitchPotionThrowing;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class WitchThrowPotionGoal
extends Goal {
    private final Witch witch;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadiusSqr;
    private final double lingeringChance;
    private final double anotherThrowChance;
    private LivingEntity target;
    private int attackTime;
    private final boolean apprentice;
    private boolean randomPotion = false;

    public WitchThrowPotionGoal(Witch witch, int attackIntervalMin, int attackIntervalMax, float attackRadius, double lingeringChance, double anotherThrowChance, boolean apprentice) {
        this.witch = witch;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.attackTime = Mth.m_14143_((float)Mth.m_216271_((RandomSource)witch.m_217043_(), (int)this.attackIntervalMin, (int)this.attackIntervalMax)) / 2;
        this.lingeringChance = lingeringChance;
        this.anotherThrowChance = anotherThrowChance;
        this.apprentice = apprentice;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.witch.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
    }

    public void m_8041_() {
        this.target = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double distanceToTarget = this.witch.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean canSee = this.witch.m_21574_().m_148306_((Entity)this.target);
        if (distanceToTarget > (double)this.attackRadiusSqr && !canSee) {
            this.witch.m_21573_().m_5624_((Entity)this.target, 1.0);
            return;
        }
        this.witch.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime <= 0) {
            if (!canSee) {
                return;
            }
            this.witch.m_21573_().m_26573_();
            this.attackTime = Mth.m_14143_((float)Mth.m_216271_((RandomSource)this.witch.m_217043_(), (int)this.attackIntervalMin, (int)this.attackIntervalMax));
            this.throwPotionAtTarget();
        }
    }

    private void throwPotionAtTarget() {
        ArrayList<MobEffectInstance> listToLoop;
        if (this.witch.m_34161_()) {
            return;
        }
        ArrayList<MobEffectInstance> mobEffectInstances = new ArrayList<MobEffectInstance>();
        if (!this.apprentice) {
            listToLoop = this.target instanceof Raider ? WitchPotionThrowing.goodPotionsList : WitchPotionThrowing.badPotionsList;
        } else {
            ArrayList<MobEffectInstance> arrayList = listToLoop = this.witch.m_217043_().m_188499_() ? WitchPotionThrowing.goodPotionsList : WitchPotionThrowing.badPotionsList;
        }
        if (this.randomPotion) {
            mobEffectInstances.add((MobEffectInstance)listToLoop.get(this.witch.m_217043_().m_188503_(listToLoop.size())));
        } else if (this.apprentice) {
            mobEffectInstances.add((MobEffectInstance)listToLoop.get(this.witch.m_217043_().m_188503_(listToLoop.size())));
        } else {
            for (MobEffectInstance mobEffectInstance : listToLoop) {
                if (this.target.m_21023_(mobEffectInstance.m_19544_())) continue;
                mobEffectInstances.add(new MobEffectInstance(mobEffectInstance));
                break;
            }
        }
        this.randomPotion = false;
        ThrownPotion thrownpotion = new ThrownPotion(this.witch.f_19853_, (LivingEntity)this.witch);
        Item potionType = this.witch.m_217043_().m_188500_() < this.lingeringChance ? Items.f_42739_ : Items.f_42736_;
        thrownpotion.m_37446_(MCUtils.setCustomEffects((ItemStack)new ItemStack((ItemLike)potionType), mobEffectInstances));
        thrownpotion.m_146926_(thrownpotion.m_146909_() + 20.0f);
        double distance = this.witch.m_20270_((Entity)this.target);
        double dirX = this.target.m_20185_() - this.witch.m_20185_();
        double distanceY = this.target.m_20186_() - this.witch.m_20186_();
        double dirZ = this.target.m_20189_() - this.witch.m_20189_();
        double distanceXZ = Math.sqrt(dirX * dirX + dirZ * dirZ);
        double yPos = this.target.m_20227_(0.0);
        double dirY = (yPos += (double)this.target.m_20192_() * 0.1 + distanceY / distanceXZ) - thrownpotion.m_20186_();
        thrownpotion.m_6686_(dirX, dirY + distanceXZ * 0.18, dirZ, 1.1f + (float)distance / 32.0f + (float)Math.max(distanceY / 48.0, 0.0), 1.0f);
        if (!this.witch.m_20067_()) {
            this.witch.f_19853_.m_6263_(null, this.witch.m_20185_(), this.witch.m_20186_(), this.witch.m_20189_(), SoundEvents.f_12553_, this.witch.m_5720_(), 1.0f, 0.8f + this.witch.m_217043_().m_188501_() * 0.4f);
        }
        this.witch.f_19853_.m_7967_((Entity)thrownpotion);
        if (this.witch.m_217043_().m_188500_() < this.anotherThrowChance) {
            this.attackTime = 8;
            this.randomPotion = true;
        }
    }
}

