/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper.feature;

import insane96mcp.enhancedai.modules.creeper.ai.AICreeperLaunchGoal;
import insane96mcp.enhancedai.modules.creeper.ai.AICreeperSwellGoal;
import insane96mcp.enhancedai.setup.EASounds;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.network.MessageCreeperDataSync;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Creeper Swell", description="Various changes to Creepers exploding. Ignoring Walls, Walking Fuse and smarter exploding based off explosion size")
@LoadFeature(module="enhancedai:creeper")
public class CreeperSwell
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Walking Fuse Chance", description="Percentage chance for a Creeper to keep walking while exploding.")
    public static Double walkingFuseChance = 0.1;
    @Config
    @Label(name="Walking Fuse Speed Modifier", description="Speed modifier when a walking fuse creeper is swelling.")
    public static Double walkingFuseSpeedModifier = -0.5;
    @Config(min=0.0, max=1.0)
    @Label(name="Ignore Walls Chance", description="Percentage chance for a Creeper to ignore walls while targeting a player. This means that a creeper will be able to explode if it's in the correct range from a player even if there's a wall between.")
    public static Double ignoreWallsChance = 0.65;
    @Config(min=0.0, max=1.0)
    @Label(name="Launch.Chance", description="Launching creepers will try ignite and throw themselves at the player.")
    public static Double launchChance = 0.05;
    @Config
    @Label(name="Launch.Particles", description="If true, Launching Creepers emit particles")
    public static Boolean launchParticles = true;
    @Config
    @Label(name="Launch.inaccuracy", description="The inaccuracy of the launching creeper in Normal difficulty, easy is increased, hard is decreased.")
    public static Double launchInaccuracy = 0.5;
    @Config
    @Label(name="Launch.Explosion Radius", description="The explosion radius of launching creepers. (Overwrites Cena creepers explosion radius)")
    public static Integer launchExplosionRadius = 2;
    @Config(min=0.0, max=1.0)
    @Label(name="Breach Chance", description="Breaching creepers will try to open an hole in the wall to let mobs in.")
    public static Double breachChance = 0.075;
    @Config
    @Label(name="Disable falling swelling", description="Disables the creeper feature that makes them start swelling when falling.")
    public static Boolean disableFallingSwelling = true;
    @Config
    @Label(name="TNT Like", description="If true creepers will ignite if damaged by an explosion.")
    public static Boolean tntLike = false;
    @Config(min=0.0, max=1.0)
    @Label(name="Cena.Chance", description="AND HIS NAME IS ...")
    public static Double cenaChance = 0.02;
    @Config
    @Label(name="Cena.Particles", description="If true, Creeper Cena emits particles")
    public static Boolean cenaParticles = true;
    @Config
    @Label(name="Cena.Name", description="If true, Creeper Cena will have a name")
    public static Boolean cenaName = true;
    @Config
    @Label(name="Cena.Force Explosion", description="When ignited, Cena creepers will not stop swelling")
    public static Boolean cenaForceExplosion = true;
    @Config
    @Label(name="Cena.Generates fire", description="If true, Creeper Cena explosion will generate fire")
    public static Boolean cenaFire = false;
    @Config(min=0.0, max=12.0)
    @Label(name="Cena.Explosion power", description="Explosion power of Creeper Cena")
    public static Double cenaExplosionPower = 4.0;
    @Config
    @Label(name="Cena.Survival Reimagined Integration", description="If Survival Reimagined is installed and Explosion Overhaul is enabled, creeper cena will deal more knockback and break more blocks")
    public static Boolean survivalReimaginedIntegration = true;

    public CreeperSwell(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void explosionStartEvent(ExplosionEvent.Detonate event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion e = event.getExplosion();
        Entity entity = e.getExploder();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        if (creeper.getPersistentData().m_128471_("enhancedai:cena")) {
            creeper.m_5496_((SoundEvent)EASounds.CREEPER_CENA_EXPLODE.get(), 4.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        creeper.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof SwellGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)creeper.f_21345_).m_25363_(arg_0));
        CompoundTag persistentData = creeper.getPersistentData();
        boolean walkingFuse = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:walking_fuse", creeper.m_217043_().m_188500_() < walkingFuseChance);
        boolean ignoreWalls = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:ignore_walls", creeper.m_217043_().m_188500_() < ignoreWallsChance);
        boolean breach = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:breach", creeper.m_217043_().m_188500_() < breachChance);
        boolean launch = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:launch", creeper.m_217043_().m_188500_() < launchChance);
        boolean cena = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:cena", creeper.m_217043_().m_188500_() < cenaChance);
        CompoundTag compoundNBT = new CompoundTag();
        creeper.m_7380_(compoundNBT);
        if (cena) {
            compoundNBT.m_128376_("Fuse", (short)36);
            compoundNBT.m_128344_("ExplosionRadius", cenaExplosionPower.byteValue());
            MessageCreeperDataSync.syncCreeperToPlayers((Creeper)creeper);
            if (cenaName.booleanValue()) {
                creeper.m_6593_((Component)Component.m_237113_((String)"Creeper Cena"));
            }
            if (cenaFire.booleanValue()) {
                persistentData.m_128379_("insanelib:explosion_causes_fire", true);
            }
            if (survivalReimaginedIntegration.booleanValue()) {
                persistentData.m_128350_("survivalreimagined:explosion_knockback_multiplier", 2.0f);
                persistentData.m_128350_("survivalreimagined:explosion_ray_strength_multiplier", 0.02f);
            }
        }
        AICreeperSwellGoal swellGoal = new AICreeperSwellGoal(creeper).setWalkingFuse(walkingFuse).setIgnoreWalls(ignoreWalls).setBreaching(breach);
        if (cena) {
            swellGoal.setForceExplode(cenaForceExplosion);
        }
        creeper.f_21345_.m_25352_(2, (Goal)swellGoal);
        if (launch) {
            creeper.f_21345_.m_25352_(1, (Goal)new AICreeperLaunchGoal(creeper));
            compoundNBT.m_128344_("ExplosionRadius", launchExplosionRadius.byteValue());
        }
        creeper.m_7378_(compoundNBT);
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!(this.isEnabled() && tntLike.booleanValue() && event.getSource().m_269533_(DamageTypeTags.f_268415_) && (livingEntity = event.getEntity()) instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)livingEntity;
        creeper.m_32312_();
    }

    @SubscribeEvent
    public void onCreeperTick(LivingEvent.LivingTickEvent event) {
        Creeper creeper;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Creeper)) break block2;
                creeper = (Creeper)livingEntity;
                if (!creeper.m_9236_().f_46443_) break block3;
            }
            return;
        }
        this.onLaunchCreeperTick(creeper);
        this.onCenaCreeperTick(creeper);
    }

    public void onLaunchCreeperTick(Creeper creeper) {
        if (creeper.f_19797_ % 20 != 0 || !launchParticles.booleanValue()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)creeper.m_9236_();
        if (creeper.getPersistentData().m_128471_("enhancedai:launch")) {
            for (int j = 0; j < serverLevel.m_6907_().size(); ++j) {
                ServerPlayer serverplayer = (ServerPlayer)serverLevel.m_6907_().get(j);
                serverLevel.m_8624_(serverplayer, (ParticleOptions)ParticleTypes.f_123796_, true, creeper.m_20185_(), creeper.m_20186_() + 0.25, creeper.m_20189_(), 8, 0.05, 0.05, 0.05, 0.025);
            }
        }
    }

    public void onCenaCreeperTick(Creeper creeper) {
        if (creeper.f_19797_ % 40 != 5 || !cenaParticles.booleanValue()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)creeper.m_9236_();
        if (creeper.getPersistentData().m_128471_("enhancedai:cena")) {
            for (int j = 0; j < serverLevel.m_6907_().size(); ++j) {
                ServerPlayer serverplayer = (ServerPlayer)serverLevel.m_6907_().get(j);
                BlockPos blockpos = serverplayer.m_20183_();
                if (!blockpos.m_203195_((Position)new Vec3(creeper.m_20185_(), creeper.m_20186_() + 0.5, creeper.m_20189_()), 16.0)) continue;
                serverLevel.m_8624_(serverplayer, (ParticleOptions)ParticleTypes.f_123792_, false, creeper.m_20185_(), creeper.m_20186_() + 1.1, creeper.m_20189_(), 1, 0.15, 0.15, 0.15, 0.0);
            }
        }
    }

    public static boolean shouldDisableFallingSwelling() {
        return Feature.isEnabled(CreeperSwell.class) && disableFallingSwelling != false;
    }
}

