/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.pets.feature;

import insane96mcp.enhancedai.modules.pets.ai.RangedSnowGolemAttackGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Snow Golems")
@LoadFeature(module="enhancedai:pets")
public class SnowGolems
extends Feature {
    public static final String SHOOTING_COOLDOWN = "enhancedai:shooting_cooldown";
    private static final String ON_SPAWN_PROCESSED = "enhancedai:snow_golems_on_spawn_processed";
    @Config
    @Label(name="Damaging Snowballs")
    public static Boolean damagingSnowballs = true;
    @Config
    @Label(name="Freezing Snowballs")
    public static Boolean freezingSnowballs = true;
    @Config
    @Label(name="Healing Snowballs", description="If true, snowballs hitting snow golems will heal them.")
    public static Boolean healingSnowballs = true;
    @Config
    @Label(name="Entity Blacklist", description="Entities that will not be affected by this feature.")
    public static Blacklist entityBlacklist = new Blacklist(Collections.emptyList(), false);

    public SnowGolems(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent event) {
        LivingEntity entityHit;
        SnowGolem snowGolem;
        block6: {
            block5: {
                EntityHitResult entityHitResult;
                Entity entity;
                if (!this.isEnabled() || !damagingSnowballs.booleanValue() && !freezingSnowballs.booleanValue() || !((entity = event.getProjectile().m_19749_()) instanceof SnowGolem) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(snowGolem = (SnowGolem)entity)) || !((entity = event.getRayTraceResult()) instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)entity).m_82443_()) instanceof LivingEntity)) break block5;
                entityHit = (LivingEntity)entity;
                if (!(entityHitResult.m_82443_() instanceof SnowGolem)) break block6;
            }
            return;
        }
        if (damagingSnowballs.booleanValue()) {
            DamageSource damageSource = snowGolem.m_269291_().m_269299_((Entity)event.getProjectile(), (LivingEntity)snowGolem);
            entityHit.m_6469_(damageSource, 1.0f);
        }
        if (freezingSnowballs.booleanValue()) {
            entityHit.m_146917_(140);
        }
    }

    @SubscribeEvent
    public void onProjectileImpactSnowGolemEvent(ProjectileImpactEvent event) {
        SnowGolem snowGolemHit;
        EntityHitResult entityHitResult;
        HitResult hitResult;
        if (!(this.isEnabled() && healingSnowballs.booleanValue() && event.getProjectile() instanceof Snowball && (hitResult = event.getRayTraceResult()) instanceof EntityHitResult && (hitResult = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof SnowGolem && !entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(snowGolemHit = (SnowGolem)hitResult)))) {
            return;
        }
        snowGolemHit.m_5634_(1.0f);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        SnowGolem snowGolem;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof SnowGolem) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(snowGolem = (SnowGolem)entity))) {
            return;
        }
        CompoundTag persistentData = snowGolem.getPersistentData();
        int shootingCooldown = NBTUtils.getIntOrPutDefault(persistentData, SHOOTING_COOLDOWN, 10);
        snowGolem.f_21345_.f_25345_.removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof RangedAttackGoal);
        snowGolem.f_21345_.m_25352_(1, new RangedSnowGolemAttackGoal(snowGolem, 1.0, 24.0f).setAttackCooldown(shootingCooldown));
        if (persistentData.m_128441_(ON_SPAWN_PROCESSED)) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)snowGolem, (Attribute)Attributes.f_22284_, (UUID)UUID.fromString("4be0baaf-17a5-4bad-af5a-1b1944ed0bf3"), (String)"Armor for snow golems", (double)5.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)true);
        persistentData.m_128379_(ON_SPAWN_PROCESSED, true);
    }
}

