/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.villager.feature;

import insane96mcp.enhancedai.modules.villager.EAVillagerHurtByTargetGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Villager Attacking", description="Make villagers fight back")
@LoadFeature(module="enhancedai:villager")
public class VillagerAttacking
extends Feature {
    @Config
    @Label(name="Villagers Fight back", description="If true, when attacked, villagers will call other villagers for help and attack back. Attack damage can't be changed via config due to limitation so use mods like Mobs Properties Randomness to change the damage. Base damage is 4")
    public static Boolean villagersFightBack = true;
    @Config
    @Label(name="Villagers Fight back Enemies", description="If false villagers will not attack back monsters")
    public static Boolean villagersFightBackEnemies = false;
    @Config
    @Label(name="Reputation for Fight back", description="Villagers will only attack players that have below this reputation (like Iron Golems by default). https://minecraft.fandom.com/wiki/Villager#Gossiping")
    public static Integer minReputationFightBack = -100;
    @Config(min=0.0, max=4.0)
    @Label(name="Movement Speed Multiplier", description="Movement speed multiplier when attacking")
    public static Double speedMultiplier = 0.8;
    @Config
    @Label(name="Entity Blacklist", description="Entities that shouldn't be affected by this feature")
    public static Blacklist entityBlacklist = new Blacklist(List.of(), false);

    public VillagerAttacking(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Villager villager;
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Villager) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(villager = (Villager)entity))) {
            return;
        }
        CompoundTag persistentData = villager.getPersistentData();
        double movementSpeedMultiplier = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:speed_multiplier_when_aggroed", speedMultiplier);
        if (villagersFightBack.booleanValue()) {
            villager.f_21346_.m_25352_(1, (Goal)new EAVillagerHurtByTargetGoal(villager, new Class[0]).m_26044_(new Class[0]));
            villager.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)villager, movementSpeedMultiplier, false));
        }
    }
}

