/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.feature;

import insane96mcp.enhancedai.modules.witch.ai.DarkArtWitchGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Dark Arts Witches", description="Witches summon Villagers and cast a lightning upon them.")
@LoadFeature(module="enhancedai:witch")
public class DarkArtWitch
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Dark Art Chance", description="Chance for a witch to get the Dark Art AI (as soon as they have a target and are less than 10 blocks away from the target will summon a Villager and cast a lightning bolt on them")
    public static Double darkArtChance = 0.333;

    public DarkArtWitch(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Witch)) {
            return;
        }
        Witch witch = (Witch)entity;
        CompoundTag persistentData = witch.getPersistentData();
        boolean darkArt = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:dark_arts", witch.m_217043_().m_188500_() < darkArtChance);
        if (!darkArt) {
            return;
        }
        DarkArtWitchGoal darkArtWitchGoal = new DarkArtWitchGoal(witch);
        witch.f_21345_.m_25352_(1, (Goal)darkArtWitchGoal);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_ || !((livingEntity = event.getEntity()) instanceof Witch)) {
            return;
        }
        Witch witch = (Witch)livingEntity;
        witch.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            DarkArtWitchGoal goal;
            Goal patt2617$temp = prioritizedGoal.m_26015_();
            if (patt2617$temp instanceof DarkArtWitchGoal && (goal = (DarkArtWitchGoal)patt2617$temp).isRunning()) {
                goal.forceStop();
            }
        });
    }
}

