/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.base.feature;

import insane96mcp.enhancedai.modules.base.ai.EANearestAttackableTarget;
import insane96mcp.enhancedai.modules.base.ai.EASpiderTargetGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.EAAttributes;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import insane96mcp.insanelib.config.MinMax;
import insane96mcp.insanelib.util.MCUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Targeting", description="Change how mobs target players")
public class Targeting
extends Feature {
    private final MinMax.Config followRangeOverrideConfig;
    private final MinMax.Config xRayRangeOverrideConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> instaTargetConfig;
    private final ForgeConfigSpec.BooleanValue betterPathfindingConfig;
    private final Blacklist.Config entityBlacklistConfig;
    private final List<String> entityBlacklistDefault = List.of("minecraft:enderman");
    public MinMax followRangeOverride = new MinMax(32.0, 64.0);
    public MinMax xrayRangeOverride = new MinMax(16.0, 32.0);
    public boolean instaTarget = true;
    public boolean betterPathfinding = true;
    public Blacklist entityBlacklist;

    public Targeting(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.followRangeOverrideConfig = new MinMax.Config(Config.builder, "Follow Range Override", "How far away can the mobs see the player. This overrides the vanilla value (16 for most mobs). Setting 'Max' to 0 will leave the follow range as vanilla. I recommend using mods like Mobs Properties Randomness to have more control over the attribute.").setMinMax(0.0, 128.0, this.followRangeOverride).build();
        this.xRayRangeOverrideConfig = new MinMax.Config(Config.builder, "XRay Range Override", "How far away can the mobs see the player even through walls. Setting 'Max' to 0 will make mobs not able to see through walls. I recommend using mods like Mobs Properties Randomness to have more control over the attribute; the attribute name is 'enhancedai:generic.xray_follow_range'.").setMinMax(0.0, 128.0, this.xrayRangeOverride).build();
        this.instaTargetConfig = Config.builder.comment("Mobs will no longer take random time to target a player.").define("Instant Target", this.instaTarget);
        this.betterPathfindingConfig = Config.builder.comment("Mobs will be able to find better paths to the target. Note that this might hit performance a bit.").define("Better Path Finding", this.betterPathfinding);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities in here will not have the TargetAI changed").setDefaultList(this.entityBlacklistDefault).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.followRangeOverride = this.followRangeOverrideConfig.get();
        this.xrayRangeOverride = this.xRayRangeOverrideConfig.get();
        this.instaTarget = (Boolean)this.instaTargetConfig.get();
        this.betterPathfinding = (Boolean)this.betterPathfindingConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    public static void xrayRangeAttribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, (Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get())) continue;
            event.add(entityType, (Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get(), 0.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onMobSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mobEntity = (Mob)entity;
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)mobEntity)) {
            return;
        }
        CompoundTag persistentData = mobEntity.getPersistentData();
        if (!persistentData.m_128471_("enhancedai:follow_ranges_processed")) {
            if (this.followRangeOverride.min != 0.0 && mobEntity.m_21051_(Attributes.f_22277_) != null && mobEntity.m_21051_(Attributes.f_22277_).m_22115_() < this.followRangeOverride.min) {
                MCUtils.setAttributeValue((LivingEntity)mobEntity, (Attribute)Attributes.f_22277_, (double)this.followRangeOverride.getIntRandBetween(mobEntity.m_21187_()));
            }
            if (this.xrayRangeOverride.min != 0.0 && mobEntity.m_21051_((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()) != null && mobEntity.m_21051_((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()).m_22115_() < this.xrayRangeOverride.min) {
                MCUtils.setAttributeValue((LivingEntity)mobEntity, (Attribute)((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()), (double)this.xrayRangeOverride.getIntRandBetween(mobEntity.m_21187_()));
            }
            persistentData.m_128379_("enhancedai:follow_ranges_processed", true);
        }
        boolean hasTargetGoal = false;
        Predicate predicate = null;
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (WrappedGoal prioritizedGoal : mobEntity.f_21346_.f_25345_) {
            Goal goal = prioritizedGoal.m_26015_();
            if (!(goal instanceof NearestAttackableTargetGoal)) continue;
            NearestAttackableTargetGoal goal2 = (NearestAttackableTargetGoal)goal;
            if (goal2.f_26048_ != Player.class) continue;
            predicate = goal2.f_26051_.f_26879_;
            goalsToRemove.add(prioritizedGoal.m_26015_());
            hasTargetGoal = true;
        }
        if (!hasTargetGoal) {
            return;
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)mobEntity.f_21346_).m_25363_(arg_0));
        EANearestAttackableTarget targetGoal = mobEntity instanceof Spider ? new EASpiderTargetGoal<Player>((Spider)mobEntity, Player.class, true, false, (Predicate<LivingEntity>)predicate) : new EANearestAttackableTarget(mobEntity, Player.class, false, false, predicate);
        if (this.instaTarget) {
            targetGoal.setInstaTarget();
        }
        mobEntity.f_21346_.m_25352_(2, targetGoal);
        if (this.betterPathfinding) {
            mobEntity.m_21573_().m_26529_(4.0f);
        }
    }
}

