/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.enderman.feature;

import insane96mcp.enhancedai.modules.enderman.ai.GetOverHereGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="[Experimental] Get Over Here", description="Endermen teleport the player near him when can't reach him for a while.")
public class GetOverHere
extends Feature {
    private final ForgeConfigSpec.DoubleValue getOverHereChanceConfig;
    public double getOverHereChance = 0.15;

    public GetOverHere(Module module) {
        super(Config.builder, module, false);
        super.pushConfig(Config.builder);
        this.getOverHereChanceConfig = Config.builder.comment("Chance for a enderman to get the Get Over Here AI").defineInRange("Get Over Here Chance", this.getOverHereChance, 0.0, 1.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.getOverHereChance = (Double)this.getOverHereChanceConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getWorld().f_46443_ || !((entity = event.getEntity()) instanceof EnderMan)) {
            return;
        }
        EnderMan enderman = (EnderMan)entity;
        boolean getOverHere = NBTUtils.getBooleanOrPutDefault(enderman.getPersistentData(), "enhancedai:get_over_here", enderman.f_19853_.f_46441_.nextDouble() < this.getOverHereChance);
        if (!getOverHere) {
            return;
        }
        GetOverHereGoal getOverHereGoal = new GetOverHereGoal(enderman);
        enderman.f_21345_.m_25352_(1, (Goal)getOverHereGoal);
    }
}

