/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.avoidexplosions;

import insane96mcp.enhancedai.modules.mobs.avoidexplosions.AvoidExplosionGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Avoid Explosions", description="Mobs will run away from exploding creepers / TNT. Use the entity type tag enhancedai:no_run_from_explosion to blacklist them")
@LoadFeature(module="enhancedai:mobs")
public class AvoidExplosions
extends Feature {
    public static final TagKey<EntityType<?>> NO_RUN_FROM_EXPLOSION = TagKey.m_203882_((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)new ResourceLocation("enhancedai", "no_run_from_explosion"));
    @Config(min=0.0, max=10.0)
    @Label(name="Flee speed Multiplier Near", description="Speed multiplier when the mob runs from explosions and it's within 7 blocks from him.")
    public static Double runSpeedNear = 1.25;
    @Config(min=0.0, max=10.0)
    @Label(name="Flee speed Multiplier Far", description="Speed multiplier when the mob runs from explosions and it's farther than 7 blocks from him.")
    public static Double runSpeedFar = 1.1;
    @Config(min=0.0, max=10.0)
    @Label(name="Flee TNT", description="Entities also flee from TnTs")
    public static Boolean fleeTnt = false;

    public AvoidExplosions(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinLevelEvent event) {
        if (!this.isEnabled() || event.getEntity().m_6095_().m_204039_(NO_RUN_FROM_EXPLOSION)) {
            return;
        }
        this.addAvoidAI(event);
        this.alertTNT(event);
    }

    private void addAvoidAI(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob creatureEntity = (PathfinderMob)entity;
        creatureEntity.f_21345_.m_25352_(1, (Goal)new AvoidExplosionGoal(creatureEntity, runSpeedNear, runSpeedFar));
    }

    private void alertTNT(EntityJoinLevelEvent event) {
        if (!fleeTnt.booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof PrimedTnt)) {
            return;
        }
        PrimedTnt tnt = (PrimedTnt)entity;
        List creaturesNearby = tnt.level().m_45976_(PathfinderMob.class, tnt.m_142469_().m_82400_(8.0));
        for (PathfinderMob creatureEntity : creaturesNearby) {
            creatureEntity.f_21345_.f_25345_.forEach(prioritizedGoal -> {
                Goal patt2931$temp = prioritizedGoal.m_26015_();
                if (patt2931$temp instanceof AvoidExplosionGoal) {
                    AvoidExplosionGoal avoidExplosionGoal = (AvoidExplosionGoal)patt2931$temp;
                    avoidExplosionGoal.run((Entity)tnt, 8.0);
                }
            });
        }
    }
}

